/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.PropertyComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CustomPanelInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    Map<PropertyComponentHandler, CustomPanel> myCachedCustomComponents = new HashMap<PropertyComponentHandler, CustomPanel>();

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components.size() != 1) {
            return false;
        }
        NlComponent firstComponent = components.get(0);
        ViewHandler handler = NlComponentHelperKt.getViewHandler(firstComponent);
        if (handler == null) {
            return false;
        }
        if (this.myCachedCustomComponents.containsKey(handler)) {
            return true;
        }
        CustomPanel customComponent = handler.getCustomPanel();
        if (customComponent == null) {
            return false;
        }
        this.myCachedCustomComponents.put(handler, customComponent);
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        assert (components.size() == 1);
        ViewHandler handler = NlComponentHelperKt.getViewHandler(components.get(0));
        CustomPanel customPanel = this.myCachedCustomComponents.get(handler);
        assert (customPanel != null);
        CustomPanelInspectorComponent inspector = new CustomPanelInspectorComponent(customPanel);
        inspector.updateProperties(components, properties, propertiesManager);
        return inspector;
    }

    @Override
    public void resetCache() {
        this.myCachedCustomComponents.clear();
    }

    private static class CustomPanelInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final CustomPanel myPanel;
        private NlComponent myComponent;

        public CustomPanelInspectorComponent(CustomPanel panel2) {
            this.myPanel = panel2;
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            assert (components.size() == 1);
            this.myComponent = components.get(0);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return Collections.emptyList();
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addPanel(this.myPanel.getPanel());
        }

        @Override
        public void refresh() {
            this.myPanel.useComponent(this.myComponent, null);
        }
    }
}

