/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private final List<String> myStarredPropertyNames = new ArrayList<String>();
    private FavoritesInspectorComponent myInspectorComponent;
    private String myLastStarredPropertyListValue;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        this.loadStarredPropertiesIfNeeded();
        for (String propertyName : this.myStarredPropertyNames) {
            if (!properties.containsKey(FavoritesInspectorProvider.removePropertyPrefix(propertyName))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (this.myInspectorComponent == null) {
            this.myInspectorComponent = new FavoritesInspectorComponent(this.myStarredPropertyNames);
        }
        this.myInspectorComponent.updateProperties(components, properties, propertiesManager);
        return this.myInspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myLastStarredPropertyListValue = null;
        this.myStarredPropertyNames.clear();
        this.myInspectorComponent = null;
    }

    private void loadStarredPropertiesIfNeeded() {
        if (!Objects.equals(this.myLastStarredPropertyListValue, NlProperties.getStarredPropertiesAsString())) {
            this.loadStarredProperties();
        }
    }

    private void loadStarredProperties() {
        this.myLastStarredPropertyListValue = NlProperties.getStarredPropertiesAsString();
        this.myStarredPropertyNames.clear();
        for (String propertyName : NlProperties.getStarredProperties()) {
            if (!propertyName.startsWith("tools:")) {
                propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName);
            }
            this.myStarredPropertyNames.add(propertyName);
        }
        Collections.sort(this.myStarredPropertyNames);
    }

    @NotNull
    private static String removePropertyPrefix(@NotNull String propertyName) {
        return propertyName.substring(propertyName.indexOf(58) + 1);
    }

    private static class FavoritesInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final List<String> myStarredPropertyNames;
        private final Map<String, NlComponentEditor> myEditorMap;

        private FavoritesInspectorComponent(@NotNull List<String> starredPropertyNames) {
            this.myStarredPropertyNames = starredPropertyNames;
            this.myEditorMap = new HashMap<String, NlComponentEditor>(starredPropertyNames.size());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            for (String propertyName : this.myStarredPropertyNames) {
                NlProperty property2 = FavoritesInspectorComponent.findProperty(propertyName, properties);
                NlComponentEditor editor2 = this.myEditorMap.get(propertyName);
                if (property2 == null) {
                    if (editor2 == null) continue;
                    this.myEditorMap.remove(propertyName);
                    continue;
                }
                if (editor2 == null) {
                    editor2 = propertiesManager.getPropertyEditors().create(property2);
                    this.myEditorMap.put(propertyName, editor2);
                }
                editor2.setProperty(property2);
            }
        }

        @Nullable
        private static NlProperty findProperty(@NotNull String propertyName, @NotNull Map<String, NlProperty> properties) {
            boolean designPropertyRequired = propertyName.startsWith("tools:");
            NlProperty property2 = properties.get(propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName));
            if (property2 == null) {
                return null;
            }
            if (designPropertyRequired) {
                property2 = property2.getDesignTimeProperty();
            }
            return property2;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myStarredPropertyNames.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            inspector.addTitle("Favorite Attributes");
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor2 = this.myEditorMap.get(propertyName);
                if (editor2 == null) continue;
                NlProperty property2 = editor2.getProperty();
                JLabel label = inspector.addComponent(property2.getName(), property2.getTooltipText(), editor2.getComponent());
                if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
                    label.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
                }
                editor2.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor2 = this.myEditorMap.get(propertyName);
                if (editor2 == null) continue;
                editor2.refresh();
            }
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            ArrayList<NlComponentEditor> editors = new ArrayList<NlComponentEditor>(this.myStarredPropertyNames.size());
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor2 = this.myEditorMap.get(propertyName);
                if (editor2 == null) continue;
                editors.add(editor2);
            }
            return editors;
        }
    }
}

