/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private final ViewHandlerManager myViewHandlerManager;
    private final Map<String, InspectorComponent<NlPropertiesManager>> myParentInspectors;

    public LayoutInspectorProvider(@NotNull Project project) {
        this.myViewHandlerManager = ViewHandlerManager.get(project);
        this.myParentInspectors = new HashMap<String, InspectorComponent<NlPropertiesManager>>();
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        assert (components.size() >= 1);
        String parentTagName = LayoutInspectorProvider.getParentTagName(components);
        if (parentTagName == null) {
            return false;
        }
        String tagName = parentTagName.substring(parentTagName.lastIndexOf(46) + 1) + "_layout";
        if (this.myParentInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = this.myViewHandlerManager.getHandler(parentTagName);
        if (handler == null || handler.getLayoutInspectorProperties().isEmpty()) {
            return false;
        }
        this.myParentInspectors.put(parentTagName, new LayoutInspectorComponent(tagName, properties, propertiesManager, handler.getLayoutInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        assert (components.size() >= 1);
        String parentTagName = LayoutInspectorProvider.getParentTagName(components);
        InspectorComponent<NlPropertiesManager> inspector = this.myParentInspectors.get(parentTagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        return inspector;
    }

    @Override
    public void resetCache() {
        this.myParentInspectors.clear();
    }

    @Nullable
    private static String getParentTagName(@NotNull List<NlComponent> components) {
        String parentTagName = null;
        for (NlComponent component : components) {
            if (component.getParent() == null) {
                return null;
            }
            if (parentTagName != null && !component.getParent().getTagName().equals(parentTagName)) {
                return null;
            }
            parentTagName = component.getParent().getTagName();
        }
        return parentTagName;
    }

    private static class LayoutInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final String myTagName;
        private final List<String> myPropertyNames;
        private final List<NlComponentEditor> myEditors;

        public LayoutInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            this.myPropertyNames = propertyNames;
            this.myTagName = tagName;
            this.myEditors = new ArrayList<NlComponentEditor>(propertyNames.size());
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            for (String propertyName : this.myPropertyNames) {
                NlProperty property2 = properties.get(propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:"));
                if (property2 == null) continue;
                NlComponentEditor editor2 = propertiesManager.getPropertyEditors().create(property2);
                editor2.setProperty(property2);
                this.myEditors.add(editor2);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return this.myEditors;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle(this.myTagName);
            for (NlComponentEditor editor2 : this.myEditors) {
                NlProperty property2 = editor2.getProperty();
                String propertyName = property2.getName();
                JLabel label = inspector.addComponent(propertyName, property2.getTooltipText(), editor2.getComponent());
                if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
                    label.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
                }
                editor2.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }
    }
}

