/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.mockup.editor.MockUpFileChooser;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private static final Set<String> MOCKUP_PROPERTIES = ImmutableSet.of((Object)"mockup");
    private MockupInspectorComponent myInspector;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        return (Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get() != false && properties.keySet().containsAll(MOCKUP_PROPERTIES) && !components.isEmpty() && components.get(0).getAttribute("http://schemas.android.com/tools", "mockup") != null;
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (this.myInspector == null) {
            this.myInspector = new MockupInspectorComponent(propertiesManager.getProject());
        }
        this.myInspector.updateProperties(components, properties, propertiesManager);
        return this.myInspector;
    }

    @Override
    public void resetCache() {
        this.myInspector = null;
    }

    private static class MockupInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        public static final String TITLE = "View Mockup";
        private final NlReferenceEditor myOpacityEditor;
        private NlProperty myMockupPath;
        private NlProperty myOpacityProperty;
        private TextFieldWithBrowseButton myFileChooser;

        public MockupInspectorComponent(@NotNull Project project) {
            this.myOpacityEditor = NlReferenceEditor.createForInspector(project, NlEditingListener.DEFAULT_LISTENER);
            this.myFileChooser = this.createFileChooserButton();
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myMockupPath = properties.get("mockup");
            this.myOpacityProperty = properties.get("mockup_opacity");
        }

        @Override
        public int getMaxNumberOfRows() {
            return 3;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle(TITLE);
            inspector.addComponent("mockup", this.myMockupPath.getTooltipText(), (Component)this.myFileChooser);
            inspector.addComponent("mockup_opacity", null, this.myOpacityEditor.getComponent());
        }

        private TextFieldWithBrowseButton createFileChooserButton() {
            TextFieldWithBrowseButton button2 = new TextFieldWithBrowseButton();
            button2.setEditable(false);
            button2.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            button2.addActionListener(event -> {
                NlComponent component = this.getSelectionComponent();
                if (component == null) {
                    return;
                }
                MockUpFileChooser.INSTANCE.chooseMockUpFile(component, path -> {
                    button2.setText(path);
                    this.myMockupPath.setValue(path);
                });
            });
            return button2;
        }

        @Nullable
        private NlComponent getSelectionComponent() {
            if (this.myMockupPath == null || this.myMockupPath.getComponents().isEmpty()) {
                return null;
            }
            return this.myMockupPath.getComponents().get(0);
        }

        @Override
        public void refresh() {
            if (this.myFileChooser != null && !this.myFileChooser.getText().equals(this.myMockupPath.getValue())) {
                this.myFileChooser.setText(this.myMockupPath.getValue());
            }
            this.myOpacityEditor.setProperty(this.myOpacityProperty);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return ImmutableList.of((Object)this.myOpacityEditor);
        }
    }
}

