/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBarInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private InspectorComponent<NlPropertiesManager> myComponent;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        return components.size() == 1 && components.get(0).getTagName().equals("ProgressBar");
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (this.myComponent == null) {
            this.myComponent = new ProgressBarInspectorComponent(propertiesManager);
        }
        this.myComponent.updateProperties(components, properties, propertiesManager);
        return this.myComponent;
    }

    @Override
    public void resetCache() {
        this.myComponent = null;
    }

    private static class ProgressBarInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final InspectorPanel myInspector;
        private final NlEnumEditor myStyleEditor;
        private final NlReferenceEditor myDrawableEditor;
        private final NlReferenceEditor myIndeterminateDrawableEditor;
        private final NlReferenceEditor myTintEditor;
        private final NlReferenceEditor myIndeterminateTintEditor;
        private final NlReferenceEditor myMaxEditor;
        private final NlReferenceEditor myProgressEditor;
        private final NlEnumEditor myVisibilityEditor;
        private final NlEnumEditor myDesignVisibilityEditor;
        private final NlBooleanEditor myIndeterminateEditor;
        private NlProperty myStyle;
        private NlProperty myProgressDrawable;
        private NlProperty myIndeterminateDrawable;
        private NlProperty myProgressTint;
        private NlProperty myIndeterminateTint;
        private NlProperty myMax;
        private NlProperty myProgress;
        @Nullable
        private NlProperty myVisibility;
        @Nullable
        private NlProperty myDesignVisibility;
        private NlProperty myIndeterminate;

        public ProgressBarInspectorComponent(@NotNull NlPropertiesManager propertiesManager) {
            this.myInspector = propertiesManager.getInspector();
            Project project = propertiesManager.getProject();
            this.myStyleEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            this.myDrawableEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myIndeterminateDrawableEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myTintEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myIndeterminateTintEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myMaxEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myProgressEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myVisibilityEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myDesignVisibilityEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myIndeterminateEditor = NlBooleanEditor.createForInspector(this.createIndeterminateListener());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myStyle = properties.get("style");
            this.myProgressDrawable = properties.get("progressDrawable");
            this.myIndeterminateDrawable = properties.get("indeterminateDrawable");
            this.myProgressTint = properties.get("progressTint");
            this.myIndeterminateTint = properties.get("indeterminateTint");
            this.myMax = properties.get("max");
            this.myProgress = properties.get("progress");
            this.myVisibility = properties.get("visibility");
            this.myDesignVisibility = this.myVisibility != null ? this.myVisibility.getDesignTimeProperty() : null;
            this.myIndeterminate = properties.get("indeterminate");
        }

        @Override
        public int getMaxNumberOfRows() {
            return 11;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle("ProgressBar");
            inspector.addComponent("style", this.myStyle.getTooltipText(), this.myStyleEditor.getComponent());
            this.myDrawableEditor.setLabel(inspector.addComponent("progressDrawable", this.myProgressDrawable.getTooltipText(), this.myDrawableEditor.getComponent()));
            this.myIndeterminateDrawableEditor.setLabel(inspector.addComponent("indeterminateDrawable", this.myIndeterminateDrawable.getTooltipText(), this.myIndeterminateDrawableEditor.getComponent()));
            this.myTintEditor.setLabel(inspector.addComponent("progressTint", this.myProgressTint != null ? this.myProgressTint.getTooltipText() : null, this.myTintEditor.getComponent()));
            this.myIndeterminateTintEditor.setLabel(inspector.addComponent("indeterminateTint", this.myIndeterminateTint != null ? this.myIndeterminateTint.getTooltipText() : null, this.myIndeterminateTintEditor.getComponent()));
            this.myMaxEditor.setLabel(inspector.addComponent("max", this.myMax.getTooltipText(), this.myMaxEditor.getComponent()));
            this.myProgressEditor.setLabel(inspector.addComponent("progress", this.myProgress.getTooltipText(), this.myProgressEditor.getComponent()));
            inspector.addComponent("visibility", this.myVisibility != null ? this.myVisibility.getTooltipText() : null, this.myVisibilityEditor.getComponent());
            JLabel designVisibility = inspector.addComponent("visibility", this.myDesignVisibility != null ? this.myDesignVisibility.getTooltipText() : null, this.myDesignVisibilityEditor.getComponent());
            designVisibility.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
            inspector.addComponent("indeterminate", this.myIndeterminate.getTooltipText(), this.myIndeterminateEditor.getComponent());
        }

        @Override
        public void refresh() {
            this.myStyleEditor.setProperty(this.myStyle);
            this.myDrawableEditor.setProperty(this.myProgressDrawable);
            this.myIndeterminateDrawableEditor.setProperty(this.myIndeterminateDrawable);
            if (this.myProgressTint != null) {
                this.myTintEditor.setProperty(this.myProgressTint);
            }
            if (this.myIndeterminateTint != null) {
                this.myIndeterminateTintEditor.setProperty(this.myIndeterminateTint);
            }
            this.myMaxEditor.setProperty(this.myMax);
            this.myProgressEditor.setProperty(this.myProgress);
            if (this.myVisibility != null) {
                this.myVisibilityEditor.setProperty(this.myVisibility);
            }
            if (this.myDesignVisibility != null) {
                this.myDesignVisibilityEditor.setProperty(this.myDesignVisibility);
            }
            this.myIndeterminateEditor.setProperty(this.myIndeterminate);
            this.updateVisibility();
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return ImmutableList.of((Object)this.myStyleEditor, (Object)this.myDrawableEditor, (Object)this.myIndeterminateDrawableEditor, (Object)this.myTintEditor, (Object)this.myIndeterminateTintEditor, (Object)this.myMaxEditor, (Object)this.myProgressEditor, (Object)this.myVisibilityEditor, (Object)this.myDesignVisibilityEditor, (Object)this.myIndeterminateEditor);
        }

        @Override
        public void updateVisibility() {
            if (!this.myInspector.getFilter().isEmpty()) {
                return;
            }
            boolean indeterminate = "true".equalsIgnoreCase(this.myIndeterminate.getResolvedValue());
            this.myDrawableEditor.setVisible(!indeterminate);
            this.myTintEditor.setVisible(this.myProgressTint != null && !indeterminate);
            this.myIndeterminateDrawableEditor.setVisible(this.myIndeterminateTint != null && indeterminate);
            this.myIndeterminateTintEditor.setVisible(indeterminate);
            this.myMaxEditor.setVisible(!indeterminate);
            this.myProgressEditor.setVisible(!indeterminate);
        }

        private NlEditingListener createIndeterminateListener() {
            return new NlEditingListener(){

                @Override
                public void stopEditing(@NotNull NlComponentEditor editor2, @Nullable Object value2) {
                    myIndeterminate.setValue(value2);
                    this.refresh();
                }

                @Override
                public void cancelEditing(@NotNull NlComponentEditor editor2) {
                }
            };
        }
    }
}

