/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class ViewInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private static final Set<String> TAG_EXCEPTIONS = ImmutableSet.of((Object)"TextView", (Object)"ProgressBar");
    private final Map<String, InspectorComponent<NlPropertiesManager>> myInspectors = new HashMap<String, InspectorComponent<NlPropertiesManager>>();

    ViewInspectorProvider() {
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components.size() != 1) {
            return false;
        }
        NlComponent firstComponent = components.get(0);
        String tagName = firstComponent.getTagName();
        if (TAG_EXCEPTIONS.contains(tagName)) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = NlComponentHelperKt.getViewHandler(firstComponent);
        if (handler == null || handler.getInspectorProperties().isEmpty()) {
            return false;
        }
        this.myInspectors.put(tagName, new ViewInspectorComponent(tagName, properties, propertiesManager, handler.getInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        assert (components.size() == 1);
        String tagName = components.get(0).getTagName();
        InspectorComponent<NlPropertiesManager> inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        return inspector;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }

    private static class ViewInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final String myComponentName;
        private final List<String> myPropertyNames;
        private final List<NlComponentEditor> myEditors;
        private final int mySrcPropertyIndex;
        private final int mySrcPropertyToolsIndex;

        public ViewInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myPropertyNames = new ArrayList<String>(propertyNames);
            this.mySrcPropertyIndex = this.myPropertyNames.indexOf("src");
            this.mySrcPropertyToolsIndex = this.myPropertyNames.indexOf("tools:src");
            this.myEditors = new ArrayList<NlComponentEditor>(this.myPropertyNames.size());
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull PropertiesManager propertiesManager) {
            for (String propertyName : this.myPropertyNames) {
                boolean designPropertyRequired = propertyName.startsWith("tools:");
                NlProperty property2 = properties.get(propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:"));
                if (property2 == null) continue;
                if (designPropertyRequired) {
                    property2 = property2.getDesignTimeProperty();
                }
                NlComponentEditor editor2 = propertiesManager.getPropertyEditors().create(property2);
                editor2.setProperty(property2);
                this.myEditors.add(editor2);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.useSrcCompatIfExist(properties);
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return this.myEditors;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (NlComponentEditor editor2 : this.myEditors) {
                NlProperty property2 = editor2.getProperty();
                String propertyName = property2.getName();
                JLabel label = inspector.addComponent(propertyName, property2.getTooltipText(), editor2.getComponent());
                if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
                    label.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
                }
                editor2.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }

        private void useSrcCompatIfExist(@NotNull Map<String, NlProperty> properties) {
            if (this.mySrcPropertyIndex >= 0) {
                String nameToUse = properties.containsKey("srcCompat") ? "srcCompat" : "src";
                this.myPropertyNames.set(this.mySrcPropertyIndex, nameToUse);
                if (this.mySrcPropertyToolsIndex >= 0) {
                    this.myPropertyNames.set(this.mySrcPropertyToolsIndex, "tools:" + nameToUse);
                }
            }
        }
    }
}

