/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Set;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanRenderer
extends NlAttributeRenderer {
    private final ThreeStateCheckBox myCheckbox;

    public NlBooleanRenderer() {
        JPanel panel2 = this.getContentPanel();
        this.myCheckbox = new ThreeStateCheckBox();
        panel2.add((Component)this.myCheckbox, "Before");
    }

    @Override
    protected void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem item, boolean selected, boolean focus, int row, int col) {
        ResourceResolver resourceResolver;
        if (!(item instanceof NlProperty)) {
            return;
        }
        NlProperty property2 = (NlProperty)((Object)item);
        this.myCheckbox.setEnabled(true);
        String propValue = property2.getValue();
        ThreeStateCheckBox.State state = NlBooleanRenderer.getState(propValue);
        if (state == null && propValue != null && (resourceResolver = property2.getResolver()) != null) {
            this.append(propValue, NlBooleanRenderer.modifyAttributes(selected, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES));
            ResourceValue resource = resourceResolver.findResValue(propValue, false);
            String resolvedValue = resource != null ? resource.getValue() : null;
            state = NlBooleanRenderer.getState(resolvedValue);
        }
        if (state != null) {
            this.myCheckbox.setEnabled(true);
            this.myCheckbox.setState(state);
        } else {
            this.myCheckbox.setEnabled(false);
        }
    }

    @NotNull
    private static SimpleTextAttributes modifyAttributes(boolean selected, SimpleTextAttributes attributes) {
        return selected ? new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTableSelectionForeground()) : attributes;
    }

    @Nullable
    public static ThreeStateCheckBox.State getState(@Nullable String s) {
        if (s == null) {
            return ThreeStateCheckBox.State.DONT_CARE;
        }
        if ("true".equalsIgnoreCase(s)) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        if ("false".equalsIgnoreCase(s)) {
            return ThreeStateCheckBox.State.NOT_SELECTED;
        }
        return null;
    }

    @Nullable
    public static Boolean getBoolean(ThreeStateCheckBox.State state) {
        switch (state) {
            case DONT_CARE: {
                return null;
            }
            case SELECTED: {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean getNextState(ThreeStateCheckBox.State state) {
        switch (state) {
            case DONT_CARE: {
                return Boolean.TRUE;
            }
            case SELECTED: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public boolean canRender(@NotNull NlProperty item, @NotNull Set<AttributeFormat> formats) {
        return formats.contains(AttributeFormat.BOOLEAN);
    }
}

