/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDefaultRenderer
extends NlAttributeRenderer {
    public static final int ICON_SIZE = 14;

    @Override
    protected void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem value2, boolean selected, boolean hasFocus, int row, int col) {
        if (value2 instanceof NlProperty) {
            this.customize((NlProperty)((Object)value2), col, selected);
        }
    }

    void customize(NlProperty property2, int column, boolean selected) {
        if (column == 0) {
            this.appendName(property2);
        } else {
            this.appendValue(property2, selected);
        }
    }

    private void appendValue(@NotNull NlProperty property2, boolean selected) {
        String value2 = property2.getValue();
        String text = StringUtil.notNullize((String)value2);
        Icon icon2 = NlDefaultRenderer.getIcon(property2, 14);
        if (icon2 != null) {
            this.setIcon(icon2);
        }
        if (!selected && !property2.isDefaultValue(value2)) {
            this.setForeground((Color)JBColor.BLUE);
        }
        this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setToolTipText(text);
    }

    @Nullable
    public static Icon getIcon(@NotNull NlProperty property2, int iconSize) {
        String text = property2.getResolvedValue();
        if (text == null) {
            return null;
        }
        if (NlDefaultRenderer.isColorValue(text)) {
            return NlDefaultRenderer.getColorIcon(text, iconSize);
        }
        Configuration configuration = property2.getModel().getConfiguration();
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        if (text.startsWith("@color/") || text.startsWith("@android:color/")) {
            return NlDefaultRenderer.getColorIcon(resolver, property2, text, iconSize);
        }
        if (text.startsWith("@drawable/") || text.startsWith("@android:drawable/") || text.startsWith("@mipmap/")) {
            return NlDefaultRenderer.getDrawableIcon(resolver, property2, text);
        }
        return null;
    }

    @Nullable
    private static Icon getDrawableIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property2, @NotNull String value2) {
        ResourceType type = value2.startsWith("@mipmap/") ? ResourceType.MIPMAP : ResourceType.DRAWABLE;
        ResourceValue drawable = resolver.resolveResValue((ResourceValue)new ResourceValueImpl(new ResourceReference(ResourceNamespace.TODO(), type, property2.getName()), value2));
        if (drawable == null) {
            return null;
        }
        VirtualFile bitmap = ResourceHelper.resolveDrawable((RenderResources)resolver, drawable, property2.getModel().getProject());
        return (bitmap = AndroidAnnotatorUtil.pickBestBitmap(bitmap)) == null ? null : GutterIconCache.getInstance().getIcon(bitmap, (RenderResources)resolver, property2.getModel().getFacet());
    }

    @Nullable
    private static Icon getColorIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property2, @NotNull String value2, int iconSize) {
        ResourceValue resourceValue2 = resolver.resolveResValue((ResourceValue)new ResourceValueImpl(new ResourceReference(ResourceNamespace.TODO(), ResourceType.COLOR, property2.getName()), value2));
        if (resourceValue2 == null) {
            return null;
        }
        String resolvedValue = resourceValue2.getValue();
        if (NlDefaultRenderer.isColorValue(resolvedValue)) {
            return NlDefaultRenderer.getColorIcon(resolvedValue, iconSize);
        }
        return null;
    }

    private static boolean isColorValue(@Nullable String value2) {
        return value2 != null && value2.startsWith("#") && value2.matches("#\\p{XDigit}+");
    }

    @Nullable
    private static Icon getColorIcon(@NotNull String hexColor, int iconSize) {
        Color color = ResourceHelper.parseColor(hexColor);
        return color == null ? null : JBUI.scale((JBUI.JBIcon)new ColorIcon(iconSize, color, true));
    }

    private void appendName(@NotNull NlProperty property2) {
        this.append(property2.getName());
        this.setToolTipText(property2.getTooltipText());
    }

    @Override
    public boolean canRender(@NotNull NlProperty p, @NotNull Set<AttributeFormat> formats) {
        return true;
    }

    SimpleColoredComponent getLabel() {
        return this;
    }
}

