/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItemValue;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlDefaultRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagItemRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlTableNameRenderer;
import com.android.tools.property.ptable.PNameRenderer;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellRenderer;
import com.android.tools.property.ptable.PTableCellRendererProvider;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableItem;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;

public class NlPropertyRenderers
implements PTableCellRendererProvider {
    private static NlPropertyRenderers ourInstance = new NlPropertyRenderers();
    private final NlTableNameRenderer myTableNameRenderer = new NlTableNameRenderer();
    private final NlBooleanRenderer myBooleanRenderer = new NlBooleanRenderer();
    private final NlFlagRenderer myFlagRenderer = new NlFlagRenderer();
    private final NlFlagItemRenderer myFlagItemRenderer = new NlFlagItemRenderer();
    private final NlDefaultRenderer myDefaultRenderer = new NlDefaultRenderer();
    private final TableCellRenderer myGroupRenderer = NlPropertyRenderers.createGroupTableCellRenderer();

    public static NlPropertyRenderers getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlPropertyRenderers();
        }
        return ourInstance;
    }

    private NlPropertyRenderers() {
    }

    @Override
    @NotNull
    public PNameRenderer getNameCellRenderer(@NotNull PTableItem item) {
        return this.myTableNameRenderer;
    }

    @Override
    @NotNull
    public TableCellRenderer getValueCellRenderer(@NotNull PTableItem item) {
        if (item instanceof PTableGroupItem) {
            return this.myGroupRenderer;
        }
        if (item instanceof NlProperty) {
            return this.get((NlProperty)((Object)item));
        }
        throw new IllegalArgumentException("Unrecognized table item " + item);
    }

    @NotNull
    public NlAttributeRenderer get(@NotNull NlProperty property2) {
        if (property2 instanceof NlFlagPropertyItemValue) {
            return this.myFlagItemRenderer;
        }
        AttributeDefinition definition = property2.getDefinition();
        if (definition == null) {
            return this.myDefaultRenderer;
        }
        Set<AttributeFormat> formats = definition.getFormats();
        if (formats.size() == 1 && formats.contains(AttributeFormat.BOOLEAN) && this.myBooleanRenderer.canRender(property2, formats)) {
            return this.myBooleanRenderer;
        }
        if (formats.contains(AttributeFormat.FLAGS) && this.myFlagRenderer.canRender(property2, formats)) {
            return this.myFlagRenderer;
        }
        return this.myDefaultRenderer;
    }

    private static TableCellRenderer createGroupTableCellRenderer() {
        return new PTableCellRenderer(){

            @Override
            protected void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem value2, boolean selected, boolean hasFocus, int row, int column) {
            }
        };
    }
}

