/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.property.ptable.PNameRenderer;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellRenderer;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.StarState;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTableNameRenderer
extends PTableCellRenderer
implements PNameRenderer {
    private static final int BEFORE_STAR_SPACING = 2;
    private static final int STAR_SIZE = 16;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JLabel myStarLabel = new JBLabel();

    public NlTableNameRenderer() {
        this.myStarLabel.setPreferredSize((Dimension)new JBDimension(18, 16));
        this.myStarLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        this.myPanel.add((Component)this.myStarLabel, "West");
        this.myPanel.add((Component)((Object)this), "Center");
    }

    @Override
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
        this.myPanel.setBackground(this.getBackground());
        return this.myPanel;
    }

    @Nullable
    private static Icon getStar(@NotNull StarState state, boolean isSelected, boolean isHovering) {
        switch (state) {
            case STARRED: {
                return isSelected ? StudioIcons.LayoutEditor.Properties.FAVORITES_SELECTED : StudioIcons.LayoutEditor.Properties.FAVORITES;
            }
            case STAR_ABLE: {
                return isHovering ? StudioIcons.LayoutEditor.Properties.FAVORITES_HOVER : null;
            }
        }
        return null;
    }

    @Override
    protected void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem item, boolean selected, boolean hasFocus, int row, int col) {
        String label = item.getParent() != null ? item.getParent().getChildLabel(item) : item.getName();
        this.append(label, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setToolTipText(item.getTooltipText());
        Point hoverPos = table2.getHoverPosition();
        boolean hoveringOnStar = table2.isHover(row, col) && this.hitTestStarIcon(hoverPos.x, hoverPos.y);
        this.myStarLabel.setIcon(NlTableNameRenderer.getStar(item.getStarState(), selected, hoveringOnStar));
        this.setIcon(item, selected, hasFocus);
        this.setPaintFocusBorder(false);
        this.setFocusBorderAroundIcon(true);
    }

    private void setIcon(PTableItem item, boolean selected, boolean hasFocus) {
        int textGap;
        int indent;
        Icon icon2;
        Icon groupIcon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
        int beforeGroupIcon = NlTableNameRenderer.getBeforeIconSpacing(NlTableNameRenderer.getDepth(item), groupIcon.getIconWidth());
        int afterGroupIcon = NlTableNameRenderer.getAfterIconSpacing(groupIcon.getIconWidth());
        if (item.hasChildren()) {
            icon2 = groupIcon;
            indent = beforeGroupIcon;
            textGap = afterGroupIcon;
        } else {
            icon2 = null;
            indent = beforeGroupIcon + groupIcon.getIconWidth() + afterGroupIcon;
            textGap = 0;
        }
        if ("http://schemas.android.com/tools".equals(item.getNamespace())) {
            if (icon2 == null) {
                icon2 = StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE;
            } else {
                LayeredIcon layered = new LayeredIcon(new Icon[]{icon2, StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE});
                layered.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE, 1, afterGroupIcon + icon2.getIconWidth(), 0);
                icon2 = layered;
            }
            textGap = 4;
        }
        super.setIcon(icon2);
        this.setIconTextGap(textGap);
        this.setIpad((Insets)JBUI.insetsLeft((int)indent));
    }

    @Override
    public boolean hitTestStarIcon(int x, int y) {
        return x >= 2 && x < 18;
    }

    @Override
    public boolean hitTestTreeNodeIcon(@NotNull PTableItem item, int x, int y) {
        Icon icon2 = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        int beforeIcon = 18 + NlTableNameRenderer.getBeforeIconSpacing(NlTableNameRenderer.getDepth(item), icon2.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon2.getIconWidth();
    }

    private static int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return nodeIndent * depth + leftIconOffset;
    }

    private static int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    private static int getDepth(@NotNull PTableItem item) {
        int result2 = 0;
        while (item.getParent() != null) {
            ++result2;
            item = item.getParent();
            assert (item != null);
        }
        return result2;
    }
}

