/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.tools.idea.uibuilder.menu.NavigationViewSceneView;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneDecoratorFactory;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.Timer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class LayoutlibSceneManager
extends SceneManager {
    private static final SceneDecoratorFactory DECORATOR_FACTORY = new NlSceneDecoratorFactory();
    private final RenderSettings myRenderSettings;
    @Nullable
    private SceneView mySecondarySceneView;
    private int myDpi = 0;
    private final SelectionChangeListener mySelectionChangeListener = new SelectionChangeListener();
    private final ModelChangeListener myModelChangeListener = new ModelChangeListener();
    private final ConfigurationListener myConfigurationChangeListener = new ConfigurationChangeListener();
    private boolean myAreListenersRegistered;
    private final Object myProgressLock = new Object();
    @GuardedBy(value="myProgressLock")
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private final Object myRenderingQueueLock = new Object();
    @GuardedBy(value="myRenderingQueueLock")
    private MergingUpdateQueue myRenderingQueue;
    private static final int RENDER_DELAY_MS = 10;
    private RenderTask myRenderTask;
    private final Object myRenderingTaskLock = new Object();
    private ResourceNotificationManager.ResourceVersion myRenderedVersion;
    private final ReentrantReadWriteLock myRenderResultLock = new ReentrantReadWriteLock();
    @GuardedBy(value="myRenderResultLock")
    private RenderResult myRenderResult;
    private String myPreviousDeviceName;
    private Locale myPreviousLocale;
    private String myPreviousVersion;
    private String myPreviousTheme;
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;
    private long myElapsedFrameTimeMs = -1L;
    private final LinkedList<CompletableFuture<Void>> myRenderFutures = new LinkedList();
    private final Semaphore myUpdateHierarchyLock = new Semaphore(1);
    @NotNull
    private final ViewEditor myViewEditor;
    private final ListenerCollection<RenderListener> myRenderListeners = ListenerCollection.createWithDirectExecutor();
    @NotNull
    private final Executor myRenderTaskDisposerExecutor;
    private final AtomicBoolean myIsCurrentlyRendering = new AtomicBoolean(false);
    private static boolean ourRenderViewPort;

    protected static LayoutEditorRenderResult.Trigger getTriggerFromChangeType(@Nullable NlModel.ChangeType changeType) {
        if (changeType == null) {
            return null;
        }
        switch (changeType) {
            case RESOURCE_EDIT: 
            case RESOURCE_CHANGED: {
                return LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE;
            }
            case EDIT: 
            case ADD_COMPONENTS: 
            case DELETE: 
            case DND_COMMIT: 
            case DND_END: 
            case DROP: 
            case RESIZE_END: 
            case RESIZE_COMMIT: {
                return LayoutEditorRenderResult.Trigger.EDIT;
            }
            case BUILD: {
                return LayoutEditorRenderResult.Trigger.BUILD;
            }
        }
        return null;
    }

    protected LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, @NotNull RenderSettings settings, @NotNull Executor renderTaskDisposerExecutor) {
        super(model2, designSurface, settings);
        this.myRenderSettings = settings;
        this.myRenderTaskDisposerExecutor = renderTaskDisposerExecutor;
        this.createSceneView();
        this.updateTrackingConfiguration();
        this.getDesignSurface().getSelectionModel().addListener(this.mySelectionChangeListener);
        Scene scene = this.getScene();
        this.myViewEditor = new ViewEditorImpl(model2, scene);
        model2.getConfiguration().addListener(this.myConfigurationChangeListener);
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!components.isEmpty()) {
            NlComponent rootComponent = ((NlComponent)components.get(0)).getRoot();
            boolean previous = this.getScene().isAnimated();
            scene.setAnimated(false);
            List<SceneComponent> hierarchy = this.createHierarchy(rootComponent);
            SceneComponent root = hierarchy.isEmpty() ? null : hierarchy.get(0);
            this.updateFromComponent(root, new HashSet<SceneComponent>());
            scene.setRoot(root);
            this.updateTargets();
            scene.setAnimated(previous);
        }
        model2.addListener(this.myModelChangeListener);
        this.myAreListenersRegistered = true;
        scene.selectionChanged(this.getDesignSurface().getSelectionModel(), (List<NlComponent>)this.getDesignSurface().getSelectionModel().getSelection());
    }

    public LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface) {
        this(model2, designSurface, RenderSettings.getProjectSettings(model2.getProject()), PooledThreadExecutor.INSTANCE);
    }

    @NotNull
    public ViewEditor getViewEditor() {
        return this.myViewEditor;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component) {
        Scene scene = this.getScene();
        assert (scene.getRoot() != null);
        TemporarySceneComponent tempComponent = new TemporarySceneComponent(this.getScene(), component);
        tempComponent.setTargetProvider(sceneComponent -> ImmutableList.of((Object)new ConstraintDragDndTarget()));
        scene.setAnimated(false);
        scene.getRoot().addChild(tempComponent);
        this.updateFromComponent(tempComponent);
        scene.setAnimated(true);
        return tempComponent;
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        return DECORATOR_FACTORY;
    }

    @Override
    public void dispose() {
        if (this.myAreListenersRegistered) {
            NlModel model2 = this.getModel();
            this.getDesignSurface().getSelectionModel().removeListener(this.mySelectionChangeListener);
            model2.getConfiguration().removeListener(this.myConfigurationChangeListener);
            model2.removeListener(this.myModelChangeListener);
            model2.removeListener(this.myModelChangeListener);
        }
        this.myRenderListeners.clear();
        this.stopProgressIndicator();
        super.dispose();
        this.myRenderTaskDisposerExecutor.execute(() -> {
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask != null) {
                    this.myRenderTask.dispose();
                    this.myRenderTask = null;
                }
            }
            this.myRenderResultLock.writeLock().lock();
            try {
                if (this.myRenderResult != null) {
                    this.myRenderResult.dispose();
                }
                this.myRenderResult = null;
            }
            finally {
                this.myRenderResultLock.writeLock().unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProgressIndicator() {
        Object object = this.myProgressLock;
        synchronized (object) {
            if (this.myCurrentIndicator != null) {
                this.myCurrentIndicator.stop();
                this.myCurrentIndicator = null;
            }
        }
    }

    @Override
    @NotNull
    protected NlDesignSurface getDesignSurface() {
        return (NlDesignSurface)super.getDesignSurface();
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NlModel model2 = this.getModel();
        DesignerEditorFileType type = model2.getType();
        if (type == MenuFileType.INSTANCE) {
            return this.createSceneViewsForMenu();
        }
        SceneMode mode = this.getDesignSurface().getSceneMode();
        ScreenView primarySceneView = mode.createPrimarySceneView(this.getDesignSurface(), this);
        this.mySecondarySceneView = mode.createSecondarySceneView(this.getDesignSurface(), this);
        this.getDesignSurface().updateErrorDisplay();
        this.getDesignSurface().getLayeredPane().setPreferredSize(primarySceneView.getPreferredSize());
        return primarySceneView;
    }

    private SceneView createSceneViewsForMenu() {
        NlModel model2 = this.getModel();
        XmlTag tag = model2.getFile().getRootTag();
        ScreenView sceneView = tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view") ? new NavigationViewSceneView(this.getDesignSurface(), this) : new ScreenView(this.getDesignSurface(), this);
        this.getDesignSurface().updateErrorDisplay();
        this.getDesignSurface().getLayeredPane().setPreferredSize(sceneView.getPreferredSize());
        return sceneView;
    }

    @Override
    @NotNull
    public ImmutableList<Layer> getLayers() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(super.getLayers());
        if (this.mySecondarySceneView != null) {
            builder.addAll(this.mySecondarySceneView.getLayers());
        }
        return builder.build();
    }

    @Nullable
    public SceneView getSecondarySceneView() {
        return this.mySecondarySceneView;
    }

    @Override
    protected void updateFromComponent(SceneComponent sceneComponent) {
        boolean animate;
        super.updateFromComponent(sceneComponent);
        NlComponent component = sceneComponent.getNlComponent();
        boolean bl = animate = this.getScene().isAnimated() && !sceneComponent.hasNoDimension();
        if (animate) {
            long time2 = System.currentTimeMillis();
            sceneComponent.setPositionTarget(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getX(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getY(component)), time2);
            sceneComponent.setSizeTarget(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getW(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getH(component)), time2);
        } else {
            sceneComponent.setPosition(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getX(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getY(component)));
            sceneComponent.setSize(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getW(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getH(component)));
        }
    }

    public void updateTargets() {
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            LayoutlibSceneManager.updateTargetProviders(root);
            root.updateTargets();
        }
    }

    private static void updateTargetProviders(@NotNull SceneComponent component) {
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component.getNlComponent());
        component.setTargetProvider(handler);
        for (SceneComponent child : component.getChildren()) {
            LayoutlibSceneManager.updateTargetProviders(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompletableFuture<Void> requestRender(final @Nullable LayoutEditorRenderResult.Trigger trigger) {
        CompletableFuture<Void> callback2 = new CompletableFuture<Void>();
        LinkedList<CompletableFuture<Void>> linkedList = this.myRenderFutures;
        synchronized (linkedList) {
            this.myRenderFutures.add(callback2);
        }
        if (this.myIsCurrentlyRendering.get()) {
            return callback2;
        }
        this.getRenderingQueue().queue(new Update("model.render", 999){

            public void run() {
                LayoutlibSceneManager.this.render(trigger);
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
        return callback2;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRender() {
        return this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    @NotNull
    public CompletableFuture<Void> requestUserInitiatedRender() {
        return this.requestRender(LayoutEditorRenderResult.Trigger.USER);
    }

    @Override
    public void requestLayoutAndRender(boolean animate) {
        if (this.getDesignSurface().getSceneMode() == SceneMode.BLUEPRINT_ONLY) {
            this.layout(animate);
            return;
        }
        this.doRequestLayoutAndRender(animate);
    }

    void doRequestLayoutAndRender(boolean animate) {
        this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType())).whenCompleteAsync((result2, ex) -> this.notifyListenersModelLayoutComplete(animate), (Executor)PooledThreadExecutor.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestModelUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myProgressLock;
        synchronized (object) {
            if (this.myCurrentIndicator == null) {
                this.myCurrentIndicator = new AndroidPreviewProgressIndicator();
                this.myCurrentIndicator.start();
            }
        }
        this.getRenderingQueue().queue(new Update("model.update", 10){

            public void run() {
                NlModel model2 = LayoutlibSceneManager.this.getModel();
                Project project = model2.getModule().getProject();
                if (!project.isOpen()) {
                    return;
                }
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    if (model2.getVirtualFile().isValid() && !model2.getFacet().isDisposed()) {
                        LayoutlibSceneManager.this.updateModel().whenComplete((result2, ex) -> LayoutlibSceneManager.this.stopProgressIndicator());
                    } else {
                        LayoutlibSceneManager.this.stopProgressIndicator();
                    }
                });
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MergingUpdateQueue getRenderingQueue() {
        Object object = this.myRenderingQueueLock;
        synchronized (object) {
            if (this.myRenderingQueue == null) {
                this.myRenderingQueue = new MergingUpdateQueue("android.layout.rendering", 10, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
                this.myRenderingQueue.setRestartTimerOnAdd(true);
            }
            return this.myRenderingQueue;
        }
    }

    public static void setRenderViewPort(boolean state) {
        ourRenderViewPort = state;
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layout(boolean animate) {
        CompletableFuture<RenderResult> futureResult;
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask == null) {
                return;
            }
            futureResult = this.myRenderTask.layout();
        }
        try {
            RenderResult result2 = (RenderResult)futureResult.get();
            if (result2 != null) {
                this.updateHierarchy(result2);
                this.notifyListenersModelLayoutComplete(animate);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("Unable to run layout()", (Throwable)e);
        }
    }

    @Nullable
    public RenderResult getRenderResult() {
        this.myRenderResultLock.readLock().lock();
        try {
            RenderResult renderResult = this.myRenderResult;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        this.myRenderResultLock.readLock().lock();
        try {
            if (this.myRenderResult == null) {
                Map<Object, Map<ResourceReference, ResourceValue>> map2 = Collections.emptyMap();
                return map2;
            }
            Map<Object, Map<ResourceReference, ResourceValue>> map3 = this.myRenderResult.getDefaultProperties();
            return map3;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public Map<Object, String> getDefaultStyles() {
        this.myRenderResultLock.readLock().lock();
        try {
            if (this.myRenderResult == null) {
                Map<Object, String> map2 = Collections.emptyMap();
                return map2;
            }
            Map<Object, String> map3 = this.myRenderResult.getDefaultStyles();
            return map3;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    private void updateHierarchy(@Nullable RenderResult result2) {
        try {
            this.myUpdateHierarchyLock.acquire();
            try {
                if (result2 == null || !result2.getRenderResult().isSuccess()) {
                    LayoutlibSceneManager.updateHierarchy(Collections.emptyList(), this.getModel());
                } else {
                    LayoutlibSceneManager.updateHierarchy(this.getRootViews(result2), this.getModel());
                }
            }
            finally {
                this.myUpdateHierarchyLock.release();
            }
            this.getModel().checkStructure();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    private List<ViewInfo> getRootViews(@NotNull RenderResult result2) {
        return this.getModel().getType() == MenuFileType.INSTANCE ? result2.getSystemRootViews() : result2.getRootViews();
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        model2.syncWithPsi(rootTag, rootViews.stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList()));
        LayoutlibSceneManager.updateBounds(rootViews, model2);
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        XmlTag root = LayoutlibSceneManager.getRootTag(model2);
        if (root != null) {
            LayoutlibSceneManager.updateHierarchy(root, rootViews, model2);
        }
    }

    @Nullable
    private static XmlTag getRootTag(@NotNull NlModel model2) {
        if (Disposer.isDisposed((Disposable)model2)) {
            return null;
        }
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(model2.getProject(), model2.getVirtualFile());
        if (file == null) {
            return null;
        }
        return AndroidPsiUtils.getRootTagSafely(model2.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> inflate(boolean force) {
        Configuration configuration = this.getModel().getConfiguration();
        Project project = this.getModel().getProject();
        if (project.isDisposed()) {
            return CompletableFuture.completedFuture(false);
        }
        ResourceNotificationManager resourceNotificationManager = ResourceNotificationManager.getInstance(project);
        LayoutPullParsers.saveFileIfNecessary((PsiFile)this.getModel().getFile());
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null && !force) {
                return CompletableFuture.completedFuture(false);
            }
        }
        AndroidFacet facet = this.getModel().getFacet();
        this.myRenderedVersion = resourceNotificationManager.getCurrentVersion(facet, (PsiFile)this.getModel().getFile(), configuration);
        RenderService renderService = RenderService.getInstance(this.getModel().getProject());
        RenderService.RenderTaskBuilder renderTaskBuilder = renderService.taskBuilder(facet, configuration).withPsiFile((PsiFile)this.getModel().getFile());
        return this.setupRenderTaskBuilder(renderTaskBuilder).build().thenCompose(newTask -> {
            if (newTask != null) {
                newTask.getLayoutlibCallback().setAdaptiveIconMaskPath(this.getDesignSurface().getAdaptiveIconShape().getPathDescription());
                return ((CompletableFuture)((CompletableFuture)newTask.inflate().whenComplete((result2, exception) -> {
                    if (exception != null) {
                        Logger.getInstance(LayoutlibSceneManager.class).warn(exception);
                    }
                    if (result2 == null || !result2.getRenderResult().isSuccess()) {
                        newTask.dispose();
                    } else {
                        Object object = this.myRenderingTaskLock;
                        synchronized (object) {
                            if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                                this.myRenderTask.dispose();
                            }
                            this.myRenderTask = newTask;
                        }
                    }
                })).thenApply(result2 -> result2 != null ? result2 : RenderResult.createBlank((PsiFile)this.getModel().getFile()))).thenApply(result2 -> {
                    if (project.isDisposed()) {
                        return false;
                    }
                    this.updateHierarchy((RenderResult)result2);
                    this.myRenderResultLock.writeLock().lock();
                    try {
                        this.updateCachedRenderResult((RenderResult)result2);
                    }
                    finally {
                        this.myRenderResultLock.writeLock().unlock();
                    }
                    return true;
                });
            }
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                    this.myRenderTask.dispose();
                }
            }
            return CompletableFuture.completedFuture(false);
        });
    }

    @GuardedBy(value="myRenderResultLock")
    private void updateCachedRenderResult(RenderResult result2) {
        if (this.myRenderResult != null && this.myRenderResult != result2) {
            this.myRenderResult.dispose();
        }
        this.myRenderResult = result2;
    }

    @VisibleForTesting
    @NotNull
    protected RenderService.RenderTaskBuilder setupRenderTaskBuilder(@NotNull RenderService.RenderTaskBuilder taskBuilder) {
        RenderSettings settings = this.myRenderSettings;
        if (!settings.getUseLiveRendering()) {
            taskBuilder.disableImagePool();
        }
        if (settings.getQuality() < 1.0f) {
            taskBuilder.withDownscaleFactor(settings.getQuality());
        }
        if (!settings.getShowDecorations()) {
            taskBuilder.disableDecorations();
        }
        return taskBuilder;
    }

    protected CompletableFuture<Void> updateModel() {
        return ((CompletableFuture)this.inflate(true).whenCompleteAsync((result2, exception) -> this.notifyListenersModelUpdateComplete(), (Executor)PooledThreadExecutor.INSTANCE)).thenApply(result2 -> null);
    }

    protected void notifyListenersModelLayoutComplete(boolean animate) {
        this.getModel().notifyListenersModelLayoutComplete(animate);
    }

    protected void notifyListenersModelUpdateComplete() {
        this.getModel().notifyListenersModelUpdateComplete();
    }

    private void logConfigurationChange(@NotNull DesignSurface surface) {
        Configuration configuration = this.getModel().getConfiguration();
        if (this.getModel().getConfigurationModificationCount() != configuration.getModificationCount()) {
            if (!StringUtil.equals((CharSequence)configuration.getTheme(), (CharSequence)this.myPreviousTheme)) {
                this.myPreviousTheme = configuration.getTheme();
                NlUsageTracker.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.THEME_CHANGE);
            } else if (configuration.getTarget() != null && !StringUtil.equals((CharSequence)configuration.getTarget().getVersionName(), (CharSequence)this.myPreviousVersion)) {
                this.myPreviousVersion = configuration.getTarget().getVersionName();
                NlUsageTracker.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.API_LEVEL_CHANGE);
            } else if (!configuration.getLocale().equals(this.myPreviousLocale)) {
                this.myPreviousLocale = configuration.getLocale();
                NlUsageTracker.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.LANGUAGE_CHANGE);
            } else if (configuration.getDevice() != null && !StringUtil.equals((CharSequence)configuration.getDevice().getDisplayName(), (CharSequence)this.myPreviousDeviceName)) {
                this.myPreviousDeviceName = configuration.getDevice().getDisplayName();
                NlUsageTracker.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.DEVICE_CHANGE);
            }
        }
    }

    @NotNull
    protected CompletableFuture<RenderResult> render(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        this.myIsCurrentlyRendering.set(true);
        try {
            NlDesignSurface surface = this.getDesignSurface();
            this.logConfigurationChange(surface);
            this.getModel().resetLastChange();
            long renderStartTimeMs = System.currentTimeMillis();
            return this.renderImpl().thenApply(result2 -> {
                if (result2 == null) {
                    this.completeRender();
                    return null;
                }
                this.myRenderResultLock.writeLock().lock();
                try {
                    this.updateCachedRenderResult((RenderResult)result2);
                    this.myRenderResultLock.readLock().lock();
                }
                finally {
                    this.myRenderResultLock.writeLock().unlock();
                }
                try {
                    long renderTimeMs = System.currentTimeMillis() - renderStartTimeMs;
                    NlDiagnosticsManager.getWriteInstance(surface).recordRender(renderTimeMs, this.myRenderResult.getRenderedImage().getWidth() * this.myRenderResult.getRenderedImage().getHeight() * 4);
                    NlUsageTracker.getInstance(surface).logRenderResult(trigger, this.myRenderResult, renderTimeMs);
                }
                finally {
                    this.myRenderResultLock.readLock().unlock();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!Disposer.isDisposed((Disposable)this)) {
                        this.update();
                    }
                });
                this.fireRenderListeners();
                this.completeRender();
                return result2;
            });
        }
        catch (Throwable e) {
            if (!this.getModel().getFacet().isDisposed()) {
                this.completeRender();
                throw e;
            }
            this.completeRender();
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRender() {
        ImmutableList callbacks;
        LinkedList<CompletableFuture<Void>> linkedList = this.myRenderFutures;
        synchronized (linkedList) {
            callbacks = ImmutableList.copyOf(this.myRenderFutures);
            this.myRenderFutures.clear();
        }
        callbacks.forEach(callback2 -> callback2.complete(null));
        this.myIsCurrentlyRendering.set(false);
    }

    @NotNull
    private CompletableFuture<RenderResult> renderImpl() {
        return ((CompletableFuture)this.inflate(false).whenCompleteAsync((result2, ex) -> {
            if (result2.booleanValue()) {
                this.notifyListenersModelUpdateComplete();
            }
        }, (Executor)PooledThreadExecutor.INSTANCE)).thenCompose(inflated -> {
            long elapsedFrameTimeMs = this.myElapsedFrameTimeMs;
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask == null) {
                    this.getDesignSurface().updateErrorDisplay();
                    return CompletableFuture.completedFuture(null);
                }
                if (elapsedFrameTimeMs != -1L) {
                    this.myRenderTask.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(elapsedFrameTimeMs));
                }
                return this.myRenderTask.render().thenApply(result2 -> {
                    if (result2 != null && !inflated.booleanValue()) {
                        this.updateHierarchy((RenderResult)result2);
                    }
                    return result2;
                });
            }
        });
    }

    public void setElapsedFrameTimeMs(long ms) {
        this.myElapsedFrameTimeMs = ms;
    }

    private void updateTrackingConfiguration() {
        Configuration configuration = this.getModel().getConfiguration();
        this.myPreviousDeviceName = configuration.getDevice() != null ? configuration.getDevice().getDisplayName() : null;
        this.myPreviousVersion = configuration.getTarget() != null ? configuration.getTarget().getVersionName() : null;
        this.myPreviousLocale = configuration.getLocale();
        this.myPreviousTheme = configuration.getTheme();
    }

    private static void clearDerivedData(@NotNull NlComponent component) {
        NlComponentHelperKt.setBounds(component, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component, null);
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        model2.flattenComponents().forEach(LayoutlibSceneManager::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getTagDeprecated, Function.identity()));
        for (ViewInfo view : rootViews) {
            LayoutlibSceneManager.updateBounds(view, 0, 0, snapshotToComponent, tagToComponent);
        }
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!rootViews.isEmpty() && !components.isEmpty()) {
            LayoutlibSceneManager.fixBounds((NlComponent)components.get(0));
        }
    }

    private static void fixBounds(@NotNull NlComponent root) {
        List<NlComponent> children;
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root) == -1 && NlComponentHelperKt.getH(root) == -1) {
            computeBounds = true;
            NlComponent parent = root.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if (!(children = root.getChildren()).isEmpty()) {
            for (NlComponent child : children) {
                LayoutlibSceneManager.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root), NlComponentHelperKt.getY(root), NlComponentHelperKt.getW(root), NlComponentHelperKt.getH(root));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void updateBounds(@NotNull ViewInfo view, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent) {
        ViewInfo bounds = RenderService.getSafeBounds(view);
        Object cookie = view.getCookie();
        if (cookie != null && cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            NlComponent component = snapshotToComponent.get(snapshot);
            if (component == null) {
                component = tagToComponent.get(snapshot.tag);
            }
            if (component != null && NlComponentHelperKt.getViewInfo(component) == null) {
                NlComponentHelperKt.setViewInfo(component, view);
                int left2 = parentX + bounds.getLeft();
                int top = parentY + bounds.getTop();
                int width = bounds.getRight() - bounds.getLeft();
                int height = bounds.getBottom() - bounds.getTop();
                NlComponentHelperKt.setBounds(component, left2, top, Math.max(width, 1), Math.max(height, 1));
            }
        }
        parentX += bounds.getLeft();
        parentY += bounds.getTop();
        for (ViewInfo child : view.getChildren()) {
            LayoutlibSceneManager.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent);
        }
    }

    protected void fireRenderListeners() {
        this.myRenderListeners.forEach(RenderListener::onRenderCompleted);
    }

    public void addRenderListener(@NotNull RenderListener listener2) {
        this.myRenderListeners.add(listener2);
    }

    public void removeRenderListener(@NotNull RenderListener listener2) {
        this.myRenderListeners.remove(listener2);
    }

    private static class ViewInfoTagSnapshotNode
    implements NlModel.TagSnapshotTreeNode {
        private final ViewInfo myViewInfo;

        public ViewInfoTagSnapshotNode(ViewInfo info) {
            this.myViewInfo = info;
        }

        @Override
        @Nullable
        public TagSnapshot getTagSnapshot() {
            Object result2 = this.myViewInfo.getCookie();
            return result2 instanceof TagSnapshot ? (TagSnapshot)result2 : null;
        }

        @Override
        @NotNull
        public List<NlModel.TagSnapshotTreeNode> getChildren() {
            return this.myViewInfo.getChildren().stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList());
        }
    }

    private class AndroidPreviewProgressIndicator
    extends ProgressIndicatorBase {
        private final Object myLock = new Object();

        private AndroidPreviewProgressIndicator() {
        }

        public void start() {
            super.start();
            UIUtil.invokeLaterIfNeeded(() -> {
                Timer timer2 = UIUtil.createNamedTimer((String)"Android rendering progress timer", (int)0, event -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.isRunning()) {
                            LayoutlibSceneManager.this.getDesignSurface().registerIndicator((ProgressIndicator)this);
                        }
                    }
                });
                timer2.setRepeats(false);
                timer2.start();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.myLock;
            synchronized (object) {
                super.stop();
                ApplicationManager.getApplication().invokeLater(() -> LayoutlibSceneManager.this.getDesignSurface().unregisterIndicator((ProgressIndicator)this));
            }
        }
    }

    private class ConfigurationChangeListener
    implements ConfigurationListener {
        private ConfigurationChangeListener() {
        }

        @Override
        public boolean changed(int flags) {
            if ((flags & 2) != 0) {
                int newDpi = LayoutlibSceneManager.this.getModel().getConfiguration().getDensity().getDpiValue();
                if (LayoutlibSceneManager.this.myDpi != newDpi) {
                    LayoutlibSceneManager.this.myDpi = newDpi;
                    LayoutlibSceneManager.this.update();
                }
            }
            return true;
        }
    }

    private class SelectionChangeListener
    implements SelectionListener {
        private SelectionChangeListener() {
        }

        @Override
        public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
            LayoutlibSceneManager.this.updateTargets();
            LayoutlibSceneManager.this.getScene().needsRebuildList();
        }
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model2) {
            NlDesignSurface surface = LayoutlibSceneManager.this.getDesignSurface();
            LayoutlibSceneManager.this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(model2.getLastChangeType())).thenRunAsync(() -> LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(surface.getSelectionModel(), (List<NlComponent>)surface.getSelectionModel().getSelection()), (Executor)EdtExecutor.INSTANCE);
        }

        @Override
        public void modelChanged(@NotNull NlModel model2) {
            LayoutlibSceneManager.this.requestModelUpdate();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(LayoutlibSceneManager.this.getDesignSurface().getSelectionModel(), (List<NlComponent>)LayoutlibSceneManager.this.getDesignSurface().getSelectionModel().getSelection());
                }
            });
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    boolean previous = LayoutlibSceneManager.this.getScene().isAnimated();
                    LayoutlibSceneManager.this.getScene().setAnimated(animate);
                    LayoutlibSceneManager.this.update();
                    LayoutlibSceneManager.this.getScene().setAnimated(previous);
                }
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model2) {
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(LayoutlibSceneManager.this.getModel().getProject());
            ResourceNotificationManager.ResourceVersion version2 = manager.getCurrentVersion(LayoutlibSceneManager.this.getModel().getFacet(), (PsiFile)LayoutlibSceneManager.this.getModel().getFile(), LayoutlibSceneManager.this.getModel().getConfiguration());
            if (!version2.equals(LayoutlibSceneManager.this.myRenderedVersion)) {
                LayoutlibSceneManager.this.requestModelUpdate();
                model2.updateTheme();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modelDeactivated(@NotNull NlModel model2) {
            Object object = LayoutlibSceneManager.this.myRenderingQueueLock;
            synchronized (object) {
                if (LayoutlibSceneManager.this.myRenderingQueue != null) {
                    LayoutlibSceneManager.this.myRenderingQueue.cancelAllUpdates();
                }
            }
        }

        @Override
        public void modelLiveUpdate(@NotNull NlModel model2, boolean animate) {
            boolean needsRender;
            NlDesignSurface surface = LayoutlibSceneManager.this.getDesignSurface();
            boolean bl = needsRender = surface.getSceneMode() != SceneMode.BLUEPRINT_ONLY;
            if (needsRender) {
                LayoutlibSceneManager.this.requestLayoutAndRender(animate);
            } else {
                LayoutlibSceneManager.this.layout(animate);
            }
        }
    }
}

