/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DecoratorUtilities {
    public static final String VIEW = "view";
    public static final String TOP_CONNECTION = "north";
    public static final String LEFT_CONNECTION = "left";
    public static final String RIGHT_CONNECTION = "right";
    public static final String BOTTOM_CONNECTION = "bottom";
    public static final String BASELINE_CONNECTION = "baseline";
    private static final String MODE_SUFFIX = "_mode";
    private static final String PREV_SUFFIX = "_prev";
    private static final String TIME_SUFFIX = "_time";
    private static final String TRY_TO_CONNECT = "trying_to_connect";
    public static final int MASK_TOP = 1;
    public static final int MASK_BOTTOM = 2;
    public static final int MASK_LEFT = 4;
    public static final int MASK_RIGHT = 8;
    public static final int MASK_BASELINE = 16;

    public static ViewStates mapState(SceneComponent.DrawState sState) {
        switch (sState) {
            case SUBDUED: {
                return ViewStates.SUBDUED;
            }
            case HOVER: {
                return ViewStates.HOVER;
            }
            case SELECTED: {
                return ViewStates.SELECTED;
            }
            case DRAG: {
                return ViewStates.DRAG;
            }
        }
        return ViewStates.NORMAL;
    }

    public static void setTimeChange(NlComponent component, String type, long time2, ViewStates from, ViewStates to) {
        component.putClientProperty(type + MODE_SUFFIX, (Object)to);
        component.putClientProperty(type + PREV_SUFFIX, (Object)from);
        component.putClientProperty(type + TIME_SUFFIX, time2);
    }

    public static void setTimeChange(NlComponent component, String type, ViewStates from, ViewStates to) {
        long time2 = System.nanoTime();
        component.putClientProperty(type + MODE_SUFFIX, (Object)to);
        component.putClientProperty(type + PREV_SUFFIX, (Object)from);
        component.putClientProperty(type + TIME_SUFFIX, time2);
    }

    public static void setTimeChange(@NotNull NlComponent component, @NotNull String type, @NotNull ViewStates newMode) {
        long time2 = System.nanoTime();
        ViewStates previousMode = (ViewStates)((Object)component.getClientProperty(type + MODE_SUFFIX));
        if (previousMode == null) {
            previousMode = ViewStates.NORMAL;
        }
        component.putClientProperty(type + MODE_SUFFIX, (Object)newMode);
        component.putClientProperty(type + PREV_SUFFIX, (Object)previousMode);
        component.putClientProperty(type + TIME_SUFFIX, time2);
    }

    public static ViewStates getTimedChange_prev(NlComponent component, String type) {
        return (ViewStates)((Object)component.getClientProperty(type + PREV_SUFFIX));
    }

    public static ViewStates getTimedChange_value(NlComponent component, String type) {
        return (ViewStates)((Object)component.getClientProperty(type + MODE_SUFFIX));
    }

    public static Long getTimedChange_time(NlComponent component, String type) {
        return (Long)component.getClientProperty(type + TIME_SUFFIX);
    }

    static HashSet<String> getConnected(NlComponent c, List<NlComponent> sisters, ArrayList<String> ... list) {
        int lastCount;
        HashSet<String> set = new HashSet<String>();
        String id = c.getId();
        if (id == null) {
            return set;
        }
        set.add(id);
        do {
            lastCount = set.size();
            for (NlComponent sister : sisters) {
                for (int i2 = 0; i2 < list.length; ++i2) {
                    String str = ConstraintComponentUtilities.getConnectionId(sister, "http://schemas.android.com/apk/res-auto", list[i2]);
                    if (!set.contains(str)) continue;
                    set.add(sister.getId());
                }
            }
        } while (set.size() > lastCount);
        return set;
    }

    public static HashSet<NlComponent> getConnectedNlComponents(NlComponent c, List<NlComponent> sisters, ArrayList<String> ... list) {
        int lastCount;
        HashSet<NlComponent> set = new HashSet<NlComponent>();
        String id = c.getId();
        if (id == null) {
            return set;
        }
        set.add(c);
        do {
            lastCount = set.size();
            for (NlComponent sister : sisters) {
                block2: for (int i2 = 0; i2 < list.length; ++i2) {
                    String str = ConstraintComponentUtilities.getConnectionId(sister, "http://schemas.android.com/apk/res-auto", list[i2]);
                    if (str == null || str.isEmpty()) continue;
                    for (NlComponent connectedComponent : set) {
                        String connectedId = connectedComponent.getId();
                        if (connectedId == null || !connectedId.equals(str)) continue;
                        set.add(sister);
                        continue block2;
                    }
                }
            }
        } while (set.size() > lastCount);
        return set;
    }

    public static void setTryingToConnectState(NlComponent component, AnchorTarget.Type type, boolean on) {
        List<NlComponent> sisters = component.getParent().getChildren();
        DecoratorUtilities.setTryingToConnectState(component, sisters, type, on);
    }

    public static void setTryingToConnectState(NlComponent srcComponent, List<NlComponent> dstComponents, AnchorTarget.Type type, boolean on) {
        block10: {
            block9: {
                if (!on) break block9;
                srcComponent.putClientProperty(TRY_TO_CONNECT, 0);
                switch (type) {
                    case TOP: 
                    case BOTTOM: {
                        Integer mask = 3;
                        HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(srcComponent, dstComponents, ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes);
                        for (NlComponent dstComponent : dstComponents) {
                            if (dstComponent == srcComponent || connected.contains(dstComponent)) continue;
                            dstComponent.putClientProperty(TRY_TO_CONNECT, mask);
                        }
                        break block10;
                    }
                    case RIGHT: 
                    case LEFT: {
                        Integer mask = 12;
                        HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(srcComponent, dstComponents, ConstraintComponentUtilities.ourRightAttributes, ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes);
                        for (NlComponent dstComponent : dstComponents) {
                            if (dstComponent == srcComponent || connected.contains(dstComponent)) continue;
                            dstComponent.putClientProperty(TRY_TO_CONNECT, mask);
                        }
                        break block10;
                    }
                    case BASELINE: {
                        Integer mask = 16;
                        HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(srcComponent, dstComponents, ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBaselineAttributes);
                        for (NlComponent dstComponent : dstComponents) {
                            if (dstComponent == srcComponent || connected.contains(dstComponent)) continue;
                            dstComponent.putClientProperty(TRY_TO_CONNECT, mask);
                        }
                        break;
                    }
                }
                break block10;
            }
            for (NlComponent dstComponent : dstComponents) {
                dstComponent.removeClientProperty(TRY_TO_CONNECT);
            }
            srcComponent.removeClientProperty(TRY_TO_CONNECT);
        }
    }

    public static Integer getTryingToConnectState(NlComponent component) {
        return (Integer)component.getClientProperty(TRY_TO_CONNECT);
    }

    public static enum ViewStates {
        NORMAL(0),
        SUBDUED(1),
        SELECTED(2),
        HOVER(3),
        TARGETED(4),
        SECONDARY(5),
        WILL_DESTROY(6),
        INFERRED(7),
        DRAG(8);

        public static final int NORMAL_VALUE = 0;
        public static final int SUBDUED_VALUE = 1;
        public static final int SELECTED_VALUE = 2;
        public static final int HOVER_VALUE = 3;
        public static final int TARGETED_VALUE = 4;
        public static final int SECONDARY_VALUE = 5;
        public static final int WILL_DESTROY_VALUE = 6;
        public static final int INFERRED_VALUE = 7;
        public static final int DRAG_VALUE = 8;
        private final int val;

        private ViewStates(int v) {
            this.val = v;
        }

        public int getVal() {
            return this.val;
        }
    }
}

