/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutDecorator;
import com.android.tools.idea.uibuilder.handlers.grid.draw.GridLayoutDecorator;
import com.android.tools.idea.uibuilder.handlers.grid.draw.GridLayoutV7Decorator;
import com.android.tools.idea.uibuilder.handlers.relative.draw.RelativeLayoutDecorator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.ButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.CheckBoxDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ImageViewDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.LinearLayoutDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneFrameFactory;
import com.android.tools.idea.uibuilder.scene.decorator.ProgressBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.RadioButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SeekBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SwitchDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.TextViewDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ToggleButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.UnknownViewDecorator;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class NlSceneDecoratorFactory
extends SceneDecoratorFactory {
    private static final NlSceneFrameFactory FRAME_FRACTORY = new NlSceneFrameFactory();
    protected static final SceneDecorator BASIC_NL_DECORATOR = new UnknownViewDecorator();
    private static Map<String, Constructor<? extends SceneDecorator>> ourConstructorMap = new HashMap<String, Constructor<? extends SceneDecorator>>();
    private static Map<String, SceneDecorator> ourSceneMap = new HashMap<String, SceneDecorator>();

    @Override
    @NotNull
    public SceneDecorator get(@NotNull NlComponent component) {
        String className;
        String parentTag;
        String tag = component.getTagName();
        if (tag.equalsIgnoreCase("merge") && (parentTag = component.getAttribute("http://schemas.android.com/tools", "parentTag")) != null) {
            tag = parentTag;
        }
        if ((className = NlComponentHelperKt.getMostSpecificClass(component, ourConstructorMap.keySet())) != null) {
            SceneDecorator decorator = NlSceneDecoratorFactory.get(className).orElse(BASIC_NL_DECORATOR);
            decorator.setFrameFactory(FRAME_FRACTORY);
            return decorator;
        }
        SceneDecorator decorator = NlSceneDecoratorFactory.get(tag).orElse(BASIC_NL_DECORATOR);
        decorator.setFrameFactory(FRAME_FRACTORY);
        return decorator;
    }

    @NotNull
    private static Optional<SceneDecorator> get(@NotNull String key) {
        if (ourConstructorMap.containsKey(key)) {
            if (!ourSceneMap.containsKey(key)) {
                try {
                    ourSceneMap.put(key, ourConstructorMap.get(key).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    ourSceneMap.put(key, null);
                }
            }
            return Optional.of(ourSceneMap.get(key));
        }
        return Optional.empty();
    }

    static {
        try {
            ourConstructorMap.put(SdkConstants.CLASS_CONSTRAINT_LAYOUT.oldName(), ConstraintLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put(SdkConstants.CLASS_CONSTRAINT_LAYOUT.newName(), ConstraintLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("ProgressBar", ProgressBarDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("Button", ButtonDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("ToggleButton", ToggleButtonDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("TextView", TextViewDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("ImageView", ImageViewDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("CheckBox", CheckBoxDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("RadioButton", RadioButtonDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("SeekBar", SeekBarDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("Switch", SwitchDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("LinearLayout", LinearLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("GridLayout", GridLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put(SdkConstants.CLASS_GRID_LAYOUT_V7.oldName(), GridLayoutV7Decorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put(SdkConstants.CLASS_GRID_LAYOUT_V7.newName(), GridLayoutV7Decorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("RelativeLayout", RelativeLayoutDecorator.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

