/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawTextRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;

public class SwitchDecorator
extends SceneDecorator {
    @Override
    public void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        super.addContent(list, time2, sceneContext, component);
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time2, rect);
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        int baseLineOffset = sceneContext.getSwingDimensionDip(component.getBaseline());
        String text = ConstraintUtilities.getResolvedText(component.getNlComponent());
        if (text == null) {
            text = "";
        }
        int mode = component.isSelected() ? 2 : 0;
        list.add(new DrawSwitch(l, t, w, h, mode, baseLineOffset, text));
    }

    public static class DrawSwitch
    extends DrawTextRegion {
        private static final int MARGIN = 4;

        @Override
        public int getLevel() {
            return 20;
        }

        DrawSwitch(int x, int y, int width, int height, int mode, int baseLineOffset, String string) {
            super(x, y, width, height, mode, baseLineOffset, string);
        }

        DrawSwitch(int x, int y, int width, int height, int mode, int baseLineOffset, boolean singleLine, boolean toUpperCase, int alignmentX, int alignmentY, String string) {
            super(x, y, width, height, mode, baseLineOffset, string, singleLine, toUpperCase, alignmentX, alignmentY, 14, 1.0f);
        }

        @NotNull
        public static DrawSwitch createFromString(@NotNull String s) {
            String[] sp = s.split(",");
            int c = 0;
            int x = Integer.parseInt(sp[c++]);
            int y = Integer.parseInt(sp[c++]);
            int width = Integer.parseInt(sp[c++]);
            int height = Integer.parseInt(sp[c++]);
            int mode = Integer.parseInt(sp[c++]);
            int baseLineOffset = Integer.parseInt(sp[c++]);
            boolean singleLine = Boolean.parseBoolean(sp[c++]);
            boolean toUpperCase = Boolean.parseBoolean(sp[c++]);
            int alignmentX = Integer.parseInt(sp[c++]);
            int alignmentY = Integer.parseInt(sp[c++]);
            String text = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
            return new DrawSwitch(x, y, width, height, mode, baseLineOffset, text);
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            super.paint(g, sceneContext);
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                Shape origClip = g.getClip();
                g.clipRect(this.x, this.y, this.width, this.height);
                g.setColor(colorSet.getFakeUI());
                int sHeight = this.mFont.getSize() / 2;
                int sWidth = sHeight * 4;
                int sx = this.x + this.width - sWidth - 4;
                int sy = this.y + (this.height - sHeight) / 2;
                g.drawRoundRect(sx, sy, sWidth, sHeight, sHeight, sHeight);
                int bh = sHeight * 2;
                int bx = sx - bh / 2;
                int by = sy + sHeight / 2 - bh / 2;
                g.fillRoundRect(bx, by, bh, bh, bh, bh);
                g.setClip(origClip);
            }
        }
    }
}

