/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawVerticalLine
extends DrawRegion {
    protected Font mFont = new Font("Helvetica", 0, 14);

    public DrawVerticalLine(String s) {
        super(s);
    }

    public DrawVerticalLine(int x, int y, int height) {
        super(x, y, x, height);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Stroke stroke = g.getStroke();
        g.setColor(colorSet.getFrames());
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawLine(this.x, this.y, this.x, this.y + this.height);
        g.setStroke(stroke);
    }

    public static void add(DisplayList list, SceneContext transform2, float left2, float top, float bottom2) {
        int l = transform2.getSwingXDip(left2);
        int t = transform2.getSwingYDip(top);
        int h = transform2.getSwingDimensionDip(bottom2 - top);
        list.add(new DrawVerticalLine(l, t, h));
    }
}

