/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.util.Optional;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetSnapper {
    public static final int PARENT = 1;
    public static final int PARENT_TARGET = 2;
    public static final int CHILD = 4;
    public static final int CHILD_TARGET = 8;
    public static final int ALL = 15;
    @NotNull
    private ImmutableList<Notch> myNotchesForSnapping = ImmutableList.of();
    @Nullable
    private Notch myHorizontalNotch = null;
    @Nullable
    private Notch myVerticalNotch = null;
    @Nullable
    private Notch myCircularNotch = null;
    private int myNotchesSourcesMask = 15;

    public void gatherNotches(@NotNull SceneComponent snappable) {
        Notch.Provider notchProvider;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        SceneComponent parent = snappable.getParent();
        if (parent == null) {
            return;
        }
        if ((this.myNotchesSourcesMask & 1) > 0 && (notchProvider = parent.getNotchProvider()) != null) {
            notchProvider.fill(parent, snappable, (ImmutableList.Builder<Notch>)builder);
        }
        if ((this.myNotchesSourcesMask & 2) > 0) {
            TargetSnapper.gatherNotchFromTargets(parent, snappable, (ImmutableList.Builder<Notch>)builder);
        }
        if ((this.myNotchesSourcesMask & 0xC) > 0) {
            int count = parent.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Notch.Provider provider;
                SceneComponent child = parent.getChild(i2);
                if (child == snappable) continue;
                if ((this.myNotchesSourcesMask & 4) > 0 && (provider = child.getNotchProvider()) != null) {
                    provider.fill(child, snappable, (ImmutableList.Builder<Notch>)builder);
                }
                if ((this.myNotchesSourcesMask & 8) <= 0) continue;
                TargetSnapper.gatherNotchFromTargets(child, snappable, (ImmutableList.Builder<Notch>)builder);
            }
        }
        this.myNotchesForSnapping = builder.build();
    }

    private static void gatherNotchFromTargets(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ImmutableList.Builder<Notch> builder) {
        for (Target target : owner.getTargets()) {
            if (!(target instanceof Notch.Provider)) continue;
            ((Notch.Provider)((Object)target)).fill(owner, snappableComponent, builder);
        }
    }

    @NotNull
    public OptionalInt trySnapHorizontal(int x) {
        this.myHorizontalNotch = this.findSnappedNotch(1, x, -1);
        if (this.myHorizontalNotch != null) {
            Point p = new Point();
            this.myHorizontalNotch.isSnappable(x, -1, p);
            return OptionalInt.of(p.x);
        }
        return OptionalInt.empty();
    }

    @NotNull
    public OptionalInt trySnapVertical(int y) {
        this.myVerticalNotch = this.findSnappedNotch(2, -1, y);
        if (this.myVerticalNotch != null) {
            Point p = new Point();
            this.myVerticalNotch.isSnappable(-1, y, p);
            return OptionalInt.of(p.y);
        }
        return OptionalInt.empty();
    }

    @NotNull
    public Optional<Point> trySnapCircle(int x, int y) {
        this.myCircularNotch = this.findSnappedNotch(4, x, y);
        if (this.myCircularNotch != null) {
            Point p = new Point();
            this.myCircularNotch.isSnappable(x, y, p);
            return Optional.of(p);
        }
        return Optional.empty();
    }

    @Nullable
    private Notch findSnappedNotch(int type, int x, int y) {
        double distance = Double.MAX_VALUE;
        Notch ret = null;
        Point p = new Point();
        for (Notch notch2 : this.myNotchesForSnapping) {
            double d;
            if (notch2.getType() != type || !notch2.isSnappable(x, y, p) || !((d = p.distanceSq(x, y)) < distance)) continue;
            distance = d;
            ret = notch2;
        }
        return ret;
    }

    public void applyNotches(@NotNull NlAttributesHolder attributes) {
        if (this.myHorizontalNotch != null) {
            this.myHorizontalNotch.applyAction(attributes);
        }
        if (this.myVerticalNotch != null) {
            this.myVerticalNotch.applyAction(attributes);
        }
        if (this.myCircularNotch != null) {
            this.myCircularNotch.applyAction(attributes);
        }
    }

    public void renderSnappedNotches(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        if (this.myHorizontalNotch != null) {
            this.myHorizontalNotch.render(list, sceneContext, component);
        }
        if (this.myVerticalNotch != null) {
            this.myVerticalNotch.render(list, sceneContext, component);
        }
        if (this.myCircularNotch != null) {
            this.myCircularNotch.render(list, sceneContext, component);
        }
    }

    @Nullable
    public Target getSnappedHorizontalTarget() {
        return this.myHorizontalNotch == null ? null : this.myHorizontalNotch.myTarget;
    }

    @Nullable
    public Target getSnappedVerticalTarget() {
        return this.myVerticalNotch == null ? null : this.myVerticalNotch.myTarget;
    }

    public void clearSnappedNotches() {
        this.myHorizontalNotch = null;
        this.myVerticalNotch = null;
        this.myCircularNotch = null;
    }

    public void reset() {
        this.myNotchesForSnapping = ImmutableList.of();
        this.clearSnappedNotches();
    }

    public void setSources(int sourceMask) {
        this.myNotchesSourcesMask = sourceMask;
    }
}

