/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class ScoutChains {
    static final int MAX_ERROR = 1000;
    static final int MIN_SPREAD = 3;
    private static final boolean DEBUG = true;

    public static void pick(ScoutWidget[] list) {
        ChainMode chain_mode;
        int errorPacked;
        int[] marginsPacked;
        int errorInside;
        int[] marginsInside;
        int errorSpread;
        int[] marginsSpread;
        int[] margins;
        Dir dir;
        ScoutWidget[] group;
        ScoutWidget child;
        int i2;
        ScoutWidget base = list[0];
        ScoutWidget[] children = new ScoutWidget[list.length - 1];
        System.arraycopy(list, 1, children, 0, children.length);
        for (i2 = 0; i2 < children.length; ++i2) {
            child = children[i2];
            child.mCheckedForChain = child.isConnected(Direction.LEFT) | child.isConnected(Direction.RIGHT);
        }
        block11: for (i2 = 0; i2 < children.length; ++i2) {
            child = children[i2];
            group = ScoutChains.getCandiateListX(base, child, children);
            if ((group = ScoutChains.removeOverlapsX(group)) == null) continue;
            dir = Dir.HORIZONTAL;
            if (ScoutChains.anyNotWrap(group, dir)) {
                margins = new int[group.length + 1];
                ScoutChains.getMargins(base, group, margins, dir);
                ScoutChains.creatHorizontalChain(group, base, ChainMode.CHAIN_SPREAD, margins);
                continue;
            }
            marginsSpread = new int[group.length + 1];
            errorSpread = ScoutChains.getMarginsSpread(base, group, marginsSpread, dir);
            marginsInside = new int[group.length + 1];
            errorInside = ScoutChains.getMarginsInside(base, group, marginsInside, dir);
            marginsPacked = new int[group.length + 1];
            errorPacked = ScoutChains.getMarginsPacked(base, group, marginsPacked, dir);
            chain_mode = errorInside < errorSpread ? (errorInside < errorPacked ? ChainMode.CHAIN_SPREAD_INSIDE : ChainMode.CHAIN_PACKED) : (errorSpread < errorPacked ? ChainMode.CHAIN_SPREAD : ChainMode.CHAIN_PACKED);
            switch (chain_mode) {
                case CHAIN_PACKED: {
                    if (errorPacked > 1000) {
                        return;
                    }
                    ScoutChains.creatHorizontalChain(group, base, chain_mode, marginsPacked);
                    continue block11;
                }
                case CHAIN_SPREAD: {
                    if (errorSpread > 1000) {
                        return;
                    }
                    ScoutChains.creatHorizontalChain(group, base, chain_mode, marginsSpread);
                    continue block11;
                }
                case CHAIN_SPREAD_INSIDE: {
                    if (errorInside > 1000 || group.length < 3) {
                        return;
                    }
                    ScoutChains.creatHorizontalChain(group, base, chain_mode, marginsInside);
                }
            }
        }
        for (i2 = 0; i2 < children.length; ++i2) {
            child = children[i2];
            child.mCheckedForChain = child.isConnected(Direction.BOTTOM) | child.isConnected(Direction.TOP) | child.isConnected(Direction.BASELINE);
        }
        block13: for (i2 = 0; i2 < children.length; ++i2) {
            child = children[i2];
            group = ScoutChains.getCandiateListY(base, child, children);
            if ((group = ScoutChains.removeOverlapsY(group)) == null) continue;
            dir = Dir.VERTICAL;
            if (ScoutChains.anyNotWrap(group, dir)) {
                margins = new int[group.length + 1];
                ScoutChains.getMargins(base, group, margins, dir);
                ScoutChains.creatVerticalChain(group, base, ChainMode.CHAIN_SPREAD, margins);
                continue;
            }
            marginsSpread = new int[group.length + 1];
            errorSpread = ScoutChains.getMarginsSpread(base, group, marginsSpread, dir);
            marginsInside = new int[group.length + 1];
            errorInside = ScoutChains.getMarginsInside(base, group, marginsInside, dir);
            marginsPacked = new int[group.length + 1];
            errorPacked = ScoutChains.getMarginsPacked(base, group, marginsPacked, dir);
            chain_mode = errorInside < errorSpread ? (errorInside < errorPacked ? ChainMode.CHAIN_SPREAD_INSIDE : ChainMode.CHAIN_PACKED) : (errorSpread < errorPacked ? ChainMode.CHAIN_SPREAD : ChainMode.CHAIN_PACKED);
            switch (chain_mode) {
                case CHAIN_PACKED: {
                    if (errorPacked > 1000) {
                        return;
                    }
                    ScoutChains.creatVerticalChain(group, base, chain_mode, marginsPacked);
                    continue block13;
                }
                case CHAIN_SPREAD: {
                    if (errorSpread > 1000) {
                        return;
                    }
                    ScoutChains.creatVerticalChain(group, base, chain_mode, marginsSpread);
                    continue block13;
                }
                case CHAIN_SPREAD_INSIDE: {
                    if (errorInside > 1000 || group.length < 3) {
                        return;
                    }
                    ScoutChains.creatVerticalChain(group, base, chain_mode, marginsInside);
                }
            }
        }
    }

    private static void getMargins(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        if (dir == Dir.HORIZONTAL) {
            margin[0] = group[0].getDpX();
            for (int i2 = 1; i2 < group.length; ++i2) {
                margin[i2] = group[i2].getDpX() - group[i2 - 1].getDpX() - group[i2 - 1].getDpWidth();
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX();
        } else {
            margin[0] = group[0].getDpY();
            for (int i3 = 1; i3 < group.length; ++i3) {
                margin[i3] = group[i3].getDpY() - group[i3 - 1].getDpY() - group[i3 - 1].getDpHeight();
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY();
        }
    }

    private static int getMarginsSpread(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        int i2;
        int naturalSpace;
        int gap;
        int i3;
        int minGap;
        int error = 0;
        if (dir == Dir.HORIZONTAL) {
            minGap = group[0].getDpX();
            for (i3 = 1; i3 < group.length; ++i3) {
                gap = group[i3].getDpX() - group[i3 - 1].getDpX() - group[i3 - 1].getDpWidth();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap = Math.min(minGap, base.getDpWidth() - group[group.length - 1].getDpX() - group[group.length - 1].getDpWidth());
            margin[0] = group[0].getDpX() - naturalSpace;
            for (i2 = 1; i2 < group.length; ++i2) {
                margin[i2] = group[i2].getDpX() - group[i2 - 1].getDpX() - group[i2 - 1].getDpWidth() - naturalSpace;
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX() - naturalSpace;
        } else {
            minGap = group[0].getDpY();
            for (i3 = 1; i3 < group.length; ++i3) {
                gap = group[i3].getDpY() - group[i3 - 1].getDpY() - group[i3 - 1].getDpHeight();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap = Math.min(minGap, base.getDpHeight() - group[group.length - 1].getDpY() - group[group.length - 1].getDpHeight());
            margin[0] = group[0].getDpY() - naturalSpace;
            for (i2 = 1; i2 < group.length; ++i2) {
                margin[i2] = group[i2].getDpY() - group[i2 - 1].getDpY() - group[i2 - 1].getDpHeight() - naturalSpace;
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY() - naturalSpace;
        }
        for (int i4 = 0; i4 < margin.length; ++i4) {
            int e = margin[i4];
            if (e < -2) {
                error = Integer.MAX_VALUE;
                return error;
            }
            error += e * e;
        }
        System.out.println(" error = " + error);
        return error;
    }

    private static int getMarginsInside(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        int i2;
        int naturalSpace;
        int gap;
        int i3;
        int minGap;
        int error = 0;
        if (dir == Dir.HORIZONTAL) {
            minGap = Integer.MAX_VALUE;
            for (i3 = 1; i3 < group.length; ++i3) {
                gap = group[i3].getDpX() - group[i3 - 1].getDpX() - group[i3 - 1].getDpWidth();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap;
            margin[0] = group[0].getDpX();
            for (i2 = 1; i2 < group.length; ++i2) {
                margin[i2] = group[i2].getDpX() - group[i2 - 1].getDpX() - group[i2 - 1].getDpWidth() - naturalSpace;
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX();
        } else {
            minGap = Integer.MAX_VALUE;
            for (i3 = 1; i3 < group.length; ++i3) {
                gap = group[i3].getDpY() - group[i3 - 1].getDpY() - group[i3 - 1].getDpHeight();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap;
            margin[0] = group[0].getDpY();
            for (i2 = 1; i2 < group.length; ++i2) {
                margin[i2] = group[i2].getDpY() - group[i2 - 1].getDpY() - group[i2 - 1].getDpHeight() - naturalSpace;
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY();
        }
        for (int i4 = 0; i4 < margin.length; ++i4) {
            int e = margin[i4];
            if (e < -2) {
                error = Integer.MAX_VALUE;
                return error;
            }
            error += e * e;
        }
        return error;
    }

    private static int getMarginsPacked(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        int i2;
        int naturalSpace;
        int bottomSpace;
        int topSpace;
        int error = 0;
        if (dir == Dir.HORIZONTAL) {
            topSpace = group[0].getDpX();
            bottomSpace = base.getDpWidth() - (group[group.length - 1].getDpWidth() + group[group.length - 1].getDpX());
            naturalSpace = Math.min(topSpace, bottomSpace);
            margin[0] = group[0].getDpX() - naturalSpace;
            for (i2 = 1; i2 < group.length; ++i2) {
                margin[i2] = group[i2].getDpX() - group[i2 - 1].getDpX() - group[i2 - 1].getDpWidth();
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX() - naturalSpace;
        } else {
            topSpace = group[0].getDpY();
            bottomSpace = base.getDpHeight() - (group[group.length - 1].getDpHeight() + group[group.length - 1].getDpY());
            naturalSpace = Math.min(topSpace, bottomSpace);
            margin[0] = group[0].getDpY() - naturalSpace;
            for (i2 = 1; i2 < group.length; ++i2) {
                margin[i2] = group[i2].getDpY() - group[i2 - 1].getDpY() - group[i2 - 1].getDpHeight();
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY() - naturalSpace;
        }
        for (int i3 = 0; i3 < margin.length; ++i3) {
            int e = margin[i3];
            if (e < -2) {
                error = Integer.MAX_VALUE;
                return error;
            }
            error += e * e;
        }
        return error;
    }

    private static boolean anyNotWrap(ScoutWidget[] group, Dir dir) {
        for (int i2 = 0; i2 < group.length; ++i2) {
            ScoutWidget widget = group[i2];
            if (!widget.isCandidateResizable(dir == Dir.HORIZONTAL ? 1 : 0)) continue;
            return true;
        }
        return false;
    }

    private static void creatHorizontalChain(ScoutWidget[] scoutWidgets, ScoutWidget parentScoutWidget, ChainMode chain_mode, int[] margins) {
        ArrayList<String[]> attrList = new ArrayList<String[]>();
        for (int i2 = 0; i2 < scoutWidgets.length; ++i2) {
            int gap;
            ScoutWidget leftConnect;
            ScoutWidget rightConnect;
            ScoutWidget widget = scoutWidgets[i2];
            Direction ldir = Direction.RIGHT;
            Direction rdir = Direction.LEFT;
            if (i2 + 1 < scoutWidgets.length) {
                rightConnect = scoutWidgets[i2 + 1];
            } else {
                rightConnect = parentScoutWidget;
                rdir = Direction.RIGHT;
            }
            if (i2 > 0) {
                leftConnect = scoutWidgets[i2 - 1];
            } else {
                leftConnect = parentScoutWidget;
                ldir = Direction.LEFT;
            }
            attrList.clear();
            if (widget.isCandidateResizable(1)) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_width", "0dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.LEFT, leftConnect.mNlComponent, ldir, attrList);
            attrList.clear();
            String[] modes = new String[]{"spread", "spread_inside", "packed"};
            if (i2 == 0) {
                int gap2;
                String mode = modes[chain_mode.ordinal()];
                if (chain_mode != ChainMode.CHAIN_SPREAD) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_chainStyle", mode});
                }
                if ((gap2 = margins[i2]) > 0) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginStart", Integer.toString(gap2) + "dp"});
                    attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginLeft", Integer.toString(gap2) + "dp"});
                }
            }
            if ((gap = margins[i2 + 1]) > 0) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginEnd", Integer.toString(gap) + "dp"});
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginRight", Integer.toString(gap) + "dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.RIGHT, rightConnect.mNlComponent, rdir, attrList);
        }
    }

    private static void creatVerticalChain(ScoutWidget[] scoutWidgets, ScoutWidget parentScoutWidget, ChainMode chain_mode, int[] margin) {
        Arrays.sort(scoutWidgets, ScoutArrange.sSortRecY);
        NlComponent parent = parentScoutWidget.mNlComponent;
        ArrayList<String[]> attrList = new ArrayList<String[]>();
        for (int i2 = 0; i2 < scoutWidgets.length; ++i2) {
            int gap;
            ScoutWidget topConnect;
            ScoutWidget bottomConnect;
            ScoutWidget widget = scoutWidgets[i2];
            Direction tdir = Direction.BOTTOM;
            Direction bdir = Direction.TOP;
            if (i2 + 1 < scoutWidgets.length) {
                bottomConnect = scoutWidgets[i2 + 1];
            } else {
                bottomConnect = parentScoutWidget;
                bdir = Direction.BOTTOM;
            }
            if (i2 > 0) {
                topConnect = scoutWidgets[i2 - 1];
            } else {
                topConnect = parentScoutWidget;
                tdir = Direction.TOP;
            }
            attrList.clear();
            if (widget.isCandidateResizable(0)) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_height", "0dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.TOP, topConnect.mNlComponent, tdir, attrList);
            attrList.clear();
            String[] modes = new String[]{"spread", "spread_inside", "packed"};
            if (i2 == 0) {
                int gap2;
                String mode = modes[chain_mode.ordinal()];
                if (chain_mode != ChainMode.CHAIN_SPREAD) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res-auto", "layout_constraintVertical_chainStyle", mode});
                }
                if ((gap2 = margin[i2]) > 0) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginTop", Integer.toString(gap2) + "dp"});
                }
            }
            if ((gap = margin[i2 + 1]) > 0) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginBottom", Integer.toString(gap) + "dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.BOTTOM, bottomConnect.mNlComponent, bdir, attrList);
        }
    }

    private static int[] getGapsX(ScoutWidget[] group) {
        int[] ret = new int[group.length - 1];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = group[i2 + 1].getDpX() - (group[i2].getDpX() + group[i2].getDpWidth());
        }
        return ret;
    }

    private static int consistantGapX(ScoutWidget[] group) {
        int sum = 0;
        int count = 0;
        int max_error = 0;
        int len_1 = group.length - 1;
        for (int i2 = 0; i2 < len_1; ++i2) {
            int dist = group[i2 + 1].getDpX() - (group[i2].getDpX() + group[i2].getDpWidth());
            ++count;
            sum += dist;
        }
        int avg_gap = sum / count;
        for (int i3 = 0; i3 < len_1; ++i3) {
            int dist = group[i3 + 1].getDpX() - (group[i3].getDpX() + group[i3].getDpWidth());
            max_error = Math.max(max_error, Math.abs(dist - avg_gap));
        }
        if (max_error > 4) {
            return -1;
        }
        return avg_gap;
    }

    private static int consistantGapY(ScoutWidget[] group) {
        int sum = 0;
        int count = 0;
        int max_error = 0;
        int len_1 = group.length - 1;
        for (int i2 = 0; i2 < len_1; ++i2) {
            int dist = group[i2 + 1].getDpY() - (group[i2].getDpY() + group[i2].getDpHeight());
            ++count;
            sum += dist;
        }
        int avg_gap = sum / count;
        for (int i3 = 0; i3 < len_1; ++i3) {
            int dist = group[i3 + 1].getDpY() - (group[i3].getDpY() + group[i3].getDpHeight());
            max_error = Math.max(max_error, Math.abs(dist - avg_gap));
        }
        if (max_error > 4) {
            return -1;
        }
        return avg_gap;
    }

    private static ScoutWidget[] removeOverlapsX(ScoutWidget[] group) {
        if (group == null || group.length < 3) {
            return group;
        }
        boolean overlap = false;
        for (int i2 = 1; i2 < group.length; ++i2) {
            if (!ScoutChains.xRangeOverlap(group[i2 - 1], group[i2 - 1])) continue;
            overlap = true;
            break;
        }
        if (!overlap) {
            return group;
        }
        ArrayList<ScoutWidget> list = new ArrayList<ScoutWidget>();
        for (int i3 = 0; i3 < group.length; ++i3) {
            if (i3 + 1 < group.length && ScoutChains.xRangeOverlap(group[i3], group[i3 + 1])) {
                int p = ScoutChains.medianY(group, i3);
                int first = group[i3].getDpY() + group[i3].getDpHeight() / 2;
                int second = group[i3 + 1].getDpY() + group[i3 + 1].getDpHeight() / 2;
                list.add(Math.abs(first - p) > Math.abs(second - p) ? group[i3] : group[i3 + 1]);
                ++i3;
                continue;
            }
            list.add(group[i3]);
        }
        return list.toArray(new ScoutWidget[list.size()]);
    }

    private static ScoutWidget[] removeOverlapsY(ScoutWidget[] group) {
        if (group == null || group.length < 3) {
            return group;
        }
        boolean overlap = false;
        for (int i2 = 1; i2 < group.length; ++i2) {
            if (!ScoutChains.yRangeOverlap(group[i2 - 1], group[i2 - 1])) continue;
            overlap = true;
            break;
        }
        if (!overlap) {
            return group;
        }
        ArrayList<ScoutWidget> list = new ArrayList<ScoutWidget>();
        for (int i3 = 0; i3 < group.length; ++i3) {
            if (i3 + 1 < group.length && ScoutChains.yRangeOverlap(group[i3], group[i3 + 1])) {
                int p = ScoutChains.medianX(group, i3);
                int first = group[i3].getDpX() + group[i3].getDpWidth() / 2;
                int second = group[i3 + 1].getDpX() + group[i3 + 1].getDpWidth() / 2;
                list.add(Math.abs(first - p) > Math.abs(second - p) ? group[i3] : group[i3 + 1]);
                ++i3;
                continue;
            }
            list.add(group[i3]);
        }
        return list.toArray(new ScoutWidget[list.size()]);
    }

    private static int medianX(ScoutWidget[] group, int excluding) {
        int count = 0;
        int sum = 0;
        for (int i2 = 0; i2 < group.length; ++i2) {
            if (i2 >= excluding && i2 <= excluding + 1) continue;
            ++count;
            sum += group[i2].getDpX() + group[i2].getDpWidth() / 2;
        }
        return sum / count;
    }

    private static int medianY(ScoutWidget[] group, int excluding) {
        int count = 0;
        int sum = 0;
        for (int i2 = 0; i2 < group.length; ++i2) {
            if (i2 >= excluding && i2 <= excluding + 1) continue;
            ++count;
            sum += group[i2].getDpY() + group[i2].getDpHeight() / 2;
        }
        return sum / count;
    }

    public static ScoutWidget[] getCandiateListX(ScoutWidget base, ScoutWidget candidate, ScoutWidget[] list) {
        ScoutWidget a = candidate;
        ScoutWidget[] shortList = new ScoutWidget[list.length];
        int shortListCount = 1;
        shortList[0] = candidate;
        for (int j = 0; j < list.length; ++j) {
            int ab_gap;
            int ba_gap;
            ScoutWidget b = list[j];
            if (b.mCheckedForChain || a == b || !ScoutChains.yRangeOverlap(a, b) || (ba_gap = b.getDpX() + b.getDpWidth() - a.getDpX()) * (ab_gap = a.getDpX() + a.getDpWidth() - b.getDpX()) > 0) continue;
            shortList[shortListCount++] = b;
            int n = b.getDpX() > a.getDpX() ? -ab_gap : -ba_gap;
        }
        if (shortListCount < 2) {
            return null;
        }
        shortList = Arrays.copyOf(shortList, shortListCount);
        for (int i2 = 0; i2 < shortList.length; ++i2) {
            shortList[i2].mCheckedForChain = true;
        }
        Arrays.sort(shortList, new Comparator<ScoutWidget>(){

            @Override
            public int compare(ScoutWidget o1, ScoutWidget o2) {
                return Float.compare(o1.getDpX(), o2.getDpX());
            }
        });
        return shortList;
    }

    public static ScoutWidget[] getCandiateListY(ScoutWidget base, ScoutWidget candidate, ScoutWidget[] list) {
        ScoutWidget a = candidate;
        ScoutWidget[] shortList = new ScoutWidget[list.length];
        int shortListCount = 1;
        shortList[0] = candidate;
        for (int j = 0; j < list.length; ++j) {
            int ab_gap;
            int ba_gap;
            ScoutWidget b = list[j];
            if (b.mCheckedForChain || a == b || !ScoutChains.xRangeOverlap(a, b) || (ba_gap = b.getDpY() + b.getDpHeight() - a.getDpY()) * (ab_gap = a.getDpY() + a.getDpHeight() - b.getDpY()) > 0) continue;
            shortList[shortListCount++] = b;
            int n = b.getDpY() > a.getDpY() ? -ab_gap : -ba_gap;
        }
        if (shortListCount < 2) {
            return null;
        }
        shortList = Arrays.copyOf(shortList, shortListCount);
        for (int i2 = 0; i2 < shortList.length; ++i2) {
            shortList[i2].mCheckedForChain = true;
        }
        Arrays.sort(shortList, new Comparator<ScoutWidget>(){

            @Override
            public int compare(ScoutWidget o1, ScoutWidget o2) {
                return Float.compare(o1.getDpY(), o2.getDpY());
            }
        });
        return shortList;
    }

    static boolean xRangeOverlap(ScoutWidget a, ScoutWidget b) {
        return ScoutChains.rangeOverlap(a.getDpX(), a.getDpWidth(), b.getDpX(), b.getDpWidth());
    }

    static boolean yRangeOverlap(ScoutWidget a, ScoutWidget b) {
        return ScoutChains.rangeOverlap(a.getDpY(), a.getDpHeight(), b.getDpY(), b.getDpHeight());
    }

    static boolean rangeOverlap(int x1, int w1, int x2, int w2) {
        return x1 < x2 + w2 && x2 < x1 + w1;
    }

    static enum Dir {
        HORIZONTAL,
        VERTICAL;

    }

    static enum ChainMode {
        CHAIN_SPREAD,
        CHAIN_SPREAD_INSIDE,
        CHAIN_PACKED;

    }
}

