/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;

public class ScoutMotionConvert {
    public static boolean convert(NlComponent layout2) {
        Project project = layout2.getModel().getProject();
        PsiFile layoutFile = layout2.getTagPointer().getContainingFile();
        String fname = layoutFile.getName();
        fname = fname.substring(0, fname.lastIndexOf("."));
        String motion_scene_name = fname + "_scene";
        if (layout2.getParent() != null) {
            String name = layout2.getId();
            if (name == null) {
                name = layout2.assignId();
            }
            motion_scene_name = layoutFile.getName() + "_" + name + "_scene";
        }
        String text = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<MotionScene \n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:motion=\"http://schemas.android.com/apk/res-auto\">\n\n    <Transition\n        motion:constraintSetEnd=\"@+id/end\"\n        motion:constraintSetStart=\"@id/start\"\n        motion:duration=\"1000\">\n       <KeyFrameSet>\n       </KeyFrameSet>\n    </Transition>\n\n    <ConstraintSet android:id=\"@+id/start\">\n    </ConstraintSet>\n\n    <ConstraintSet android:id=\"@+id/end\">\n    </ConstraintSet>\n</MotionScene>";
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(motion_scene_name + ".xml", (FileType)XmlFileType.INSTANCE, (CharSequence)text);
        EditorFactory editorFactory = EditorFactory.getInstance();
        PsiDirectory xmlDir = layoutFile.getParent().getParent().findSubdirectory("xml");
        if (xmlDir == null) {
            xmlDir = layoutFile.getParent().getParent().createSubdirectory("xml");
        }
        xmlDir.add((PsiElement)file);
        AttributesTransaction transaction = layout2.startAttributeTransaction();
        layout2.getTagDeprecated().setName(DependencyManagementUtil.mapAndroidxName(layout2.getModel().getModule(), SdkConstants.CLASS_MOTION_LAYOUT));
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription", "@xml/" + motion_scene_name);
        transaction.commit();
        return true;
    }
}

