/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.statelist;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum State {
    PRESSED("Pressed", 16842919),
    FOCUSED("Focused", 16842908),
    HOVERED("Hovered", 16843623),
    SELECTED("Selected", 0x10100A1),
    CHECKABLE("Checkable", 16842911),
    CHECKED("Checked", 0x10100A0),
    ENABLED("Enabled", 16842910),
    ACTIVATED("Activated", 16843518),
    WINDOW_FOCUSED("Window Focused", 16842909);

    private final String myText;
    private final int myIntValue;

    private State(String text, int intValue) {
        this.myText = text;
        this.myIntValue = intValue;
    }

    @NotNull
    final String getText() {
        return this.myText;
    }

    final int getIntValue() {
        return this.myIntValue;
    }

    @NotNull
    public final String toString() {
        return "state_" + this.myText.toLowerCase(Locale.ROOT).replace(' ', '_');
    }

    @Nullable
    static State valueOfString(@NotNull String string) {
        Optional<State> optionalValue = Arrays.stream(State.values()).filter(value2 -> value2.toString().equals(string)).findFirst();
        return optionalValue.orElse(null);
    }
}

