/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.statelist;

import android.widget.ImageView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.statelist.State;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ToggleStateAction
extends ToggleAction {
    private final State myState;
    private final DesignSurface mySurface;

    ToggleStateAction(@NotNull State state, @NotNull DesignSurface surface) {
        super(state.getText(), null, EmptyIcon.ICON_0);
        this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        this.myState = state;
        this.mySurface = surface;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        ImageView image = this.getImageView();
        return image != null && Ints.contains((int[])image.getDrawableState(), (int)this.myState.getIntValue());
    }

    public void setSelected(@NotNull AnActionEvent event, boolean selected) {
        ImageView image = this.getImageView();
        if (image == null) {
            return;
        }
        int[] states = image.getDrawableState();
        int state = this.myState.getIntValue();
        if (selected) {
            assert (!Ints.contains((int[])states, (int)state));
            image.setImageState(ArrayUtil.append((int[])states, (int)state), false);
        } else {
            assert (Ints.contains((int[])states, (int)state));
            int i2 = Ints.indexOf((int[])states, (int)state);
            image.setImageState(ArrayUtil.remove((int[])states, (int)i2), false);
        }
        SceneManager manager = this.mySurface.getSceneManager();
        if (manager == null) {
            return;
        }
        manager.requestRender();
    }

    @Nullable
    private ImageView getImageView() {
        LayoutlibSceneManager manager = (LayoutlibSceneManager)this.mySurface.getSceneManager();
        if (manager == null) {
            return null;
        }
        RenderResult result2 = manager.getRenderResult();
        if (result2 == null) {
            return null;
        }
        ImmutableList<ViewInfo> views2 = result2.getRootViews();
        if (views2.isEmpty()) {
            return null;
        }
        Object view = ((ViewInfo)views2.get(0)).getViewObject();
        if (!(view instanceof ImageView)) {
            return null;
        }
        return (ImageView)view;
    }

    public boolean displayTextInToolbar() {
        return true;
    }
}

