/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.structure.BackNavigationComponent;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.structure.ToggleBoundsVisibility;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponentTreePanel
extends AdtSecondaryPanel
implements ToolContent<DesignSurface> {
    private final NlComponentTree myTree;
    private final BackNavigationComponent myNavigationComponent;

    public NlComponentTreePanel(@NotNull Project project, @NotNull Disposable parentDisposable) {
        super((LayoutManager)new BorderLayout());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myTree = new NlComponentTree(project, null);
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)20, (int)31);
        pane.setBorder(null);
        this.myNavigationComponent = new BackNavigationComponent();
        this.add(this.myNavigationComponent, "North");
        this.add(pane, "Center");
        this.myTree.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        Disposer.register((Disposable)this, (Disposable)this.myTree);
    }

    public void dispose() {
        this.myNavigationComponent.setDesignSurface(null);
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        this.myNavigationComponent.setDesignSurface(designSurface);
        this.myTree.setDesignSurface((NlDesignSurface)designSurface);
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        if (!Boolean.getBoolean("idea.is.internal")) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ToggleBoundsVisibility(PropertiesComponent.getInstance(), (Component)((Object)this.myTree)));
    }
}

