/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NlDropInsertionPicker {
    private final JTree myTree;

    public NlDropInsertionPicker(@NotNull NlComponentTree tree) {
        this((JTree)((Object)tree));
    }

    NlDropInsertionPicker(@NotNull JTree tree) {
        this.myTree = tree;
    }

    public Result findInsertionPointAt(@NotNull Point location, @NotNull List<NlComponent> dragged) {
        return this.findInsertionPointAt(location, dragged, false);
    }

    @Nullable
    public Result findInsertionPointAt(@NotNull Point location, @NotNull List<NlComponent> dragged, boolean ignoreMissingDependency) {
        if (dragged.isEmpty()) {
            return this.findInsertionPointAt(location);
        }
        Result result2 = new Result();
        result2.receiver = null;
        result2.nextComponent = null;
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        result2.row = this.myTree.getRowForPath(referencePath);
        if (referencePath == null) {
            return null;
        }
        result2.depth = 1;
        Object last = referencePath.getLastPathComponent();
        if (!(last instanceof NlComponent)) {
            return null;
        }
        NlComponent receiverComponent = (NlComponent)last;
        if (this.canChangeInsertionDepth(referencePath, receiverComponent)) {
            Rectangle referenceBounds;
            TreePath parentPath;
            while ((parentPath = referencePath.getParentPath()) != null && (referenceBounds = this.myTree.getPathBounds(referencePath)) != null && this.canSelectLowerDepth(result2.row, result2.depth) && location.x < referenceBounds.x) {
                --result2.depth;
                referencePath = parentPath;
            }
            receiverComponent = (NlComponent)referencePath.getLastPathComponent();
        }
        if (NlDropInsertionPicker.canAddComponent(receiverComponent.getModel(), receiverComponent, dragged, ignoreMissingDependency)) {
            result2.receiver = receiverComponent;
            if (receiverComponent.getChildCount() != 0) {
                TreePath nextPath = this.myTree.getPathForRow(result2.row + 1);
                result2.nextComponent = nextPath == null ? null : (NlComponent)nextPath.getLastPathComponent();
            }
        } else {
            NlComponent parent = receiverComponent.getParent();
            --result2.depth;
            if (parent == null) {
                result2.receiver = receiverComponent;
            } else {
                result2.receiver = parent;
                result2.nextComponent = receiverComponent.getNextSibling();
                if (result2.depth <= 0) {
                    this.updateInsertionPointAfterLastDescendant(referencePath, result2);
                }
            }
            if (!NlDropInsertionPicker.canAddComponent(result2.receiver.getModel(), result2.receiver, dragged, ignoreMissingDependency)) {
                result2.receiver = null;
                result2.nextComponent = null;
                return null;
            }
        }
        return result2;
    }

    private void updateInsertionPointAfterLastDescendant(@NotNull TreePath receiverPath, @NotNull Result result2) {
        TreePath currentPath;
        TreePath lastDescendantPath = currentPath = receiverPath;
        int lastDesendantRow = result2.row;
        int currentDepth = result2.depth;
        Enumeration<TreePath> descendants = this.myTree.getExpandedDescendants(currentPath);
        while (descendants != null && descendants.hasMoreElements()) {
            do {
                lastDescendantPath = currentPath = descendants.nextElement();
                lastDesendantRow = Math.max(lastDesendantRow, this.myTree.getRowForPath(currentPath));
            } while (descendants.hasMoreElements());
            descendants = this.myTree.getExpandedDescendants(currentPath);
            --currentDepth;
        }
        result2.row = lastDesendantRow + this.myTree.getModel().getChildCount(lastDescendantPath.getLastPathComponent());
        result2.depth = currentDepth;
    }

    private Result findInsertionPointAt(@NotNull Point location) {
        TreePath path = this.myTree.getSelectionPath();
        TreePath parent = path.getParentPath();
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        Result result2 = new Result();
        result2.shouldDelegate = true;
        result2.receiver = (NlComponent)parent.getLastPathComponent();
        if (referencePath == parent) {
            result2.depth = 1;
            result2.row = this.myTree.getRowForPath(referencePath);
            return result2;
        }
        if (referencePath.getParentPath() == parent) {
            result2.depth = 0;
            result2.row = this.myTree.getRowForPath(referencePath);
            return result2;
        }
        return null;
    }

    private boolean canChangeInsertionDepth(@NotNull TreePath path, @NotNull NlComponent component) {
        return component.getNextSibling() == null && this.myTree.getExpandedDescendants(path) == null;
    }

    private static boolean canAddComponent(@NotNull NlModel model2, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged, boolean ignoreMissingDependency) {
        return model2.canAddComponents(dragged, receiver, receiver.getChild(0), ignoreMissingDependency) || NlComponentHelperKt.isMorphableToViewGroup(receiver) && !NlComponentUtil.isDescendant(receiver, dragged);
    }

    private boolean canSelectLowerDepth(int row, int relativeDepth) {
        return row == this.myTree.getRowCount() - 1 || relativeDepth > -1;
    }

    public static class Result {
        NlComponent receiver;
        NlComponent nextComponent;
        int depth;
        int row;
        boolean shouldDelegate = false;
    }
}

