/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.utils.SdkUtils;
import com.android.utils.SparseIntArray;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTreeBadgeHandler {
    private static final int BADGE_MARGIN = 5;
    private static final int MESSAGE_WIDTH = 50;
    private static final int BADGE_ICON = 0;
    private static final int LOCK_ICON = 1;
    private static final String TOGGLE_LOCK_MESSAGE = "Toggle Tool Locking";
    private final BadgeMouseMotionListener myBadgeMouseMotionListener = new BadgeMouseMotionListener();
    private final JBLabel myHintLabel = new JBLabel();
    private final Point myHintLocation = new Point();
    @Nullable
    private LightweightHint myTooltipHint;
    @Nullable
    private TreePath myHoveredPath;
    private int myHoveredIcon = 0;
    private NlComponent myHoveredComponent;
    @Nullable
    private NlModel myNlModel;
    private int myBadgeX;
    private int myLockIconX;
    @Nullable
    private IssuePanel myIssuePanel;
    private final SparseIntArray myBadgeWidthForRows = new SparseIntArray();

    public void setNlModel(@Nullable NlModel nlModel) {
        this.myNlModel = nlModel;
    }

    public void setIssuePanel(@Nullable IssuePanel issuePanel) {
        this.myIssuePanel = issuePanel;
    }

    public void paintBadges(@NotNull Graphics2D g, @NotNull NlComponentTree tree) {
        this.myBadgeX = Integer.MAX_VALUE;
        this.myBadgeWidthForRows.clear();
        if (this.myNlModel == null) {
            return;
        }
        LintAnnotationsModel lintAnnotationsModel = this.myNlModel.getLintAnnotationsModel();
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            Icon firstIcon;
            TreePath path = tree.getPathForRow(i2);
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) continue;
            NlComponent component = (NlComponent)last;
            Rectangle pathBounds = tree.getPathBounds(path);
            if (pathBounds == null) continue;
            int y = pathBounds.y + pathBounds.height / 2;
            if (lintAnnotationsModel == null || (firstIcon = lintAnnotationsModel.getIssueIcon(component, false, tree.isRowSelected(i2) && tree.hasFocus())) == null) continue;
            int x = tree.getWidth() - firstIcon.getIconWidth() - 5;
            int iy = y - firstIcon.getIconHeight() / 2;
            firstIcon.paintIcon((Component)((Object)tree), g, x, iy);
            this.myBadgeWidthForRows.put(i2, firstIcon.getIconWidth());
            this.myBadgeX = Math.min(x, this.myBadgeX);
        }
    }

    private void showErrorTooltip(@NotNull JTree tree, @NotNull TreePath path, @NotNull String message2) {
        Window activeFrame = UIUtil.getWindow((Component)tree);
        if (activeFrame == null) {
            return;
        }
        Rectangle bounds = tree.getPathBounds(path);
        if (bounds != null) {
            HintHint hint = this.createHint(tree);
            message2 = SdkUtils.wrap((String)message2, (int)50, null);
            message2 = HintUtil.prepareHintText((String)message2, (HintHint)hint);
            this.myHintLabel.setText(message2);
            this.myHintLocation.x = tree.getWidth() - 5;
            this.myHintLocation.y = bounds.y + bounds.height / 2;
            hint = this.ensureHintCanBeDisplayed(hint, message2, tree, activeFrame);
            if (hint == null) {
                return;
            }
            if (this.myTooltipHint == null) {
                this.myTooltipHint = new LightweightHint((JComponent)this.myHintLabel);
            }
            this.myTooltipHint.show((JComponent)tree, this.myHintLocation.x, this.myHintLocation.y, (JComponent)tree, hint);
        }
    }

    @Nullable
    private HintHint ensureHintCanBeDisplayed(@NotNull HintHint hint, @NotNull String message2, @NotNull Component component, @NotNull Window activeFrame) {
        int labelWidth = this.myHintLabel.getFontMetrics(this.myHintLabel.getFont()).stringWidth(message2.substring(0, Math.min(message2.length(), 50)));
        int labelRight = component.getLocationOnScreen().x + component.getWidth() + labelWidth;
        int frameRight = activeFrame.getLocationOnScreen().x + activeFrame.getWidth();
        if (activeFrame.getWidth() < labelWidth) {
            return null;
        }
        if (frameRight < labelRight) {
            this.myHintLocation.x = 5;
            hint.setPreferredPosition(Balloon.Position.below);
        }
        return hint;
    }

    private HintHint createHint(@NotNull Component component) {
        return new HintHint(component, this.myHintLocation).setPreferredPosition(Balloon.Position.atRight).setBorderColor(JBColor.border()).setAwtTooltip(true).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true).setExplicitClose(true).setAnimationEnabled(true);
    }

    @Nullable
    private static String getIssueMessage(@NotNull TreePath path) {
        Object last = path.getLastPathComponent();
        if (!(last instanceof NlComponent)) {
            return null;
        }
        NlComponent component = (NlComponent)last;
        LintAnnotationsModel lintAnnotationsModel = component.getModel().getLintAnnotationsModel();
        if (lintAnnotationsModel != null) {
            return lintAnnotationsModel.getIssueMessage(component, false);
        }
        return null;
    }

    @NotNull
    public MouseAdapter getBadgeMouseAdapter() {
        return this.myBadgeMouseMotionListener;
    }

    public int getTotalBadgeWidth(int row) {
        return this.myBadgeWidthForRows.get(row, 0) + 5;
    }

    private class BadgeMouseMotionListener
    extends MouseAdapter {
        private BadgeMouseMotionListener() {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
                NlTreeBadgeHandler.this.myTooltipHint = null;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = null;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            JTree tree = (JTree)event.getSource();
            this.handleShowBadge(event, tree);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            this.handleMouseClicked(event, (JTree)event.getSource());
        }

        private void handleMouseClicked(MouseEvent event, JTree tree) {
            Rectangle bounds;
            int limit = NlTreeBadgeHandler.this.myBadgeX;
            if (event.getX() < limit || NlTreeBadgeHandler.this.myIssuePanel == null) {
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds = tree.getPathBounds(path)) == null || event.getY() < bounds.y || event.getY() > bounds.y + bounds.height) {
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlComponent component = (NlComponent)last;
            if (event.getX() > NlTreeBadgeHandler.this.myBadgeX) {
                NlTreeBadgeHandler.this.myIssuePanel.showIssueForComponent(component, true);
            }
        }

        private void toggleLocking(@NotNull NlComponent component) {
            boolean isLocked = SceneManager.isComponentLocked(component);
            if (component.getParent() == null) {
                return;
            }
            NlWriteCommandActionUtil.run(component, "", () -> component.setAttribute("http://schemas.android.com/tools", "locked", isLocked ? null : "true"));
        }

        private void handleShowBadge(@NotNull MouseEvent event, @NotNull JTree tree) {
            Rectangle bounds;
            if (event.getX() < NlTreeBadgeHandler.this.myBadgeX) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds = tree.getPathBounds(path)) == null || event.getY() < bounds.y || event.getY() > bounds.y + bounds.height) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = (NlComponent)last;
            boolean badgeIcon = true;
            if (NlTreeBadgeHandler.this.myHoveredPath == path) {
                if (badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 0) {
                    return;
                }
                if (!badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 1) {
                    return;
                }
            }
            NlTreeBadgeHandler.this.myHoveredPath = path;
            String message2 = null;
            if (badgeIcon) {
                message2 = NlTreeBadgeHandler.getIssueMessage(NlTreeBadgeHandler.this.myHoveredPath);
                NlTreeBadgeHandler.this.myHoveredIcon = 0;
            }
            if (message2 != null) {
                NlTreeBadgeHandler.this.showErrorTooltip(tree, NlTreeBadgeHandler.this.myHoveredPath, message2);
            }
        }

        private void hideTooltip() {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
            }
        }
    }
}

