/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.StructurePaneComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.structure.NlTreeBadgeHandler;
import com.android.tools.lint.detector.api.Lint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u001a\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J@\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010)\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/uibuilder/structure/NlTreeCellRenderer;", "Ljavax/swing/JPanel;", "Ljavax/swing/tree/TreeCellRenderer;", "myBadgeHandler", "Lcom/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler;", "(Lcom/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler;)V", "nlComponentFont", "Ljava/awt/Font;", "kotlin.jvm.PlatformType", "otherFont", "primaryLabel", "Ljavax/swing/JLabel;", "primaryLabelMetrics", "Ljava/awt/FontMetrics;", "secondaryLabel", "secondaryLabelMetrics", "computeAvailableSpace", "", "row", "icon", "Ljavax/swing/Icon;", "cellWidth", "createTooltipText", "", "tagName", "primaryLabelText", "secondaryLabelText", "getHiddenText", "getLeftOffset", "tree", "Ljavax/swing/JTree;", "path", "Ljavax/swing/tree/TreePath;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "value", "", "selected", "", "expanded", "leaf", "hasFocus", "intellij.android.designer"})
public final class NlTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private final JLabel primaryLabel;
    private final JLabel secondaryLabel;
    private final FontMetrics primaryLabelMetrics;
    private final FontMetrics secondaryLabelMetrics;
    private final Font nlComponentFont;
    private final Font otherFont;
    private final NlTreeBadgeHandler myBadgeHandler;

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object object;
        Object primaryLabelText;
        Object object2;
        Object object3;
        this.primaryLabel.setText(null);
        this.primaryLabel.setIcon(null);
        this.secondaryLabel.setText(null);
        this.primaryLabel.setForeground(UIUtil.getListForeground((boolean)hasFocus));
        if (value2 instanceof String) {
            this.primaryLabel.setText((String)value2);
            this.primaryLabel.setFont(this.otherFont);
            return this;
        }
        if (!(value2 instanceof NlComponent)) {
            return this;
        }
        this.primaryLabel.setFont(this.nlComponentFont);
        TreePath path = tree.getPathForRow(row);
        int leftOffset = this.getLeftOffset(tree, path);
        AndroidFacet facet = ((NlComponent)value2).getModel().getFacet();
        ViewHandler handler = ViewHandlerManager.get(facet).getHandler((NlComponent)value2);
        JLabel jLabel = this.primaryLabel;
        Object object4 = handler;
        if (object4 != null && (object4 = ((StructurePaneComponentHandler)object4).getIcon((NlComponent)value2)) != null) {
            Object object5 = object4;
            JLabel jLabel2 = jLabel;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object5;
            boolean bl3 = false;
            Object object6 = hasFocus ? ColoredIconGenerator.INSTANCE.generateWhiteIcon((Icon)it) : it;
            jLabel = jLabel2;
            object3 = object6;
        } else {
            object3 = null;
        }
        jLabel.setIcon((Icon)object3);
        String id = Lint.stripIdPrefix((String)((NlComponent)value2).getId());
        CharSequence charSequence = id;
        boolean it = false;
        if (charSequence.length() > 0) {
            object2 = id;
        } else {
            object2 = handler;
            if (object2 == null || (object2 = ((StructurePaneComponentHandler)object2).getTitle((NlComponent)value2)) == null) {
                object2 = primaryLabelText = ((NlComponent)value2).getTagName();
            }
        }
        if ((object = handler) == null || (object = ((StructurePaneComponentHandler)object).getTitleAttributes((NlComponent)value2)) == null) {
            object = "";
        }
        Object secondaryLabelText = object;
        int treeContainerWidth = tree.getWidth();
        int cellWidth = treeContainerWidth - leftOffset;
        this.primaryLabel.setText((String)primaryLabelText);
        this.secondaryLabel.setText((String)secondaryLabelText);
        JTree jTree = tree;
        if (jTree == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.structure.NlComponentTree");
        }
        if (!((NlComponentTree)((Object)jTree)).shouldDisplayFittedText(row)) {
            return this;
        }
        int availableSpace = this.computeAvailableSpace(row, this.primaryLabel.getIcon(), cellWidth);
        int previousLength = ((String)primaryLabelText).length();
        secondaryLabelText = ((String)(primaryLabelText = AdtUiUtils.shrinkToFit((String)primaryLabelText, (FontMetrics)this.primaryLabelMetrics, (float)availableSpace))).length() == previousLength ? AdtUiUtils.shrinkToFit((String)secondaryLabelText, (FontMetrics)this.secondaryLabelMetrics, (float)(availableSpace -= this.primaryLabelMetrics.stringWidth((String)primaryLabelText))) : "";
        this.setToolTipText(this.createTooltipText(((NlComponent)value2).getTagName(), (String)primaryLabelText, (String)secondaryLabelText));
        this.primaryLabel.setText((String)primaryLabelText);
        this.secondaryLabel.setText((String)secondaryLabelText);
        return this;
    }

    private final String createTooltipText(String tagName, String primaryLabelText, String secondaryLabelText) {
        return StringsKt.trimIndent((String)("\n    <html>\n        " + StringsKt.substringAfterLast((String)tagName, (char)'.', (String)tagName) + "<br/>\n        " + this.getHiddenText(primaryLabelText, secondaryLabelText) + "\n    </html>\n    "));
    }

    private final String getHiddenText(String primaryLabelText, String secondaryLabelText) {
        String tooltip;
        String string = tooltip = Intrinsics.areEqual((Object)this.primaryLabel.getText(), (Object)primaryLabelText) ^ true ? this.primaryLabel.getText() : "";
        if (Intrinsics.areEqual((Object)this.secondaryLabel.getText(), (Object)secondaryLabelText) ^ true) {
            tooltip = tooltip + ' ' + this.secondaryLabel.getText();
        }
        return tooltip;
    }

    private final int getLeftOffset(JTree tree, TreePath path) {
        TreeUI treeUI = tree.getUI();
        if (treeUI == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.plaf.basic.BasicTreeUI");
        }
        BasicTreeUI ui = (BasicTreeUI)treeUI;
        TreePath treePath = path;
        int depth = treePath != null ? treePath.getPathCount() : 1;
        return (ui.getLeftChildIndent() + ui.getRightChildIndent()) * depth;
    }

    private final int computeAvailableSpace(int row, Icon icon2, int cellWidth) {
        Icon icon3 = icon2;
        return cellWidth - this.primaryLabel.getIconTextGap() - this.myBadgeHandler.getTotalBadgeWidth(row) - (icon3 != null ? icon3.getIconWidth() : 0);
    }

    public NlTreeCellRenderer(@NotNull NlTreeBadgeHandler myBadgeHandler) {
        super(new FlowLayout(0, 0, JBUI.scale((int)2)));
        JLabel jLabel;
        this.myBadgeHandler = myBadgeHandler;
        this.primaryLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        NlTreeCellRenderer nlTreeCellRenderer = this;
        boolean bl = false;
        boolean bl2 = false;
        JLabel $receiver = jLabel2;
        boolean bl3 = false;
        $receiver.setForeground(UIUtil.getInactiveTextColor());
        nlTreeCellRenderer.secondaryLabel = jLabel = jLabel2;
        this.primaryLabelMetrics = this.primaryLabel.getFontMetrics(this.primaryLabel.getFont());
        this.secondaryLabelMetrics = this.secondaryLabel.getFontMetrics(this.secondaryLabel.getFont());
        this.nlComponentFont = this.primaryLabel.getFont();
        this.otherFont = this.primaryLabel.getFont().deriveFont(2);
        this.setAlignmentY(0.5f);
        this.add(this.primaryLabel);
        this.add(this.secondaryLabel);
    }
}

