/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEventHandler;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NlTreeUtil {
    @Nullable
    public static DelegatedTreeEventHandler getSelectionTreeHandler(@NotNull NlComponentTree tree) {
        Object parentComponent;
        TreePath parentPath;
        TreePath[] paths2 = tree.getSelectionModel().getSelectionPaths();
        if (paths2.length == 0 || (parentPath = paths2[0].getParentPath()) == null || !((parentComponent = parentPath.getLastPathComponent()) instanceof NlComponent)) {
            return null;
        }
        for (int i2 = 1; i2 < paths2.length; ++i2) {
            if (paths2[i2].getParentPath() == parentPath) continue;
            return null;
        }
        ViewGroupHandler handler = NlComponentHelperKt.getViewGroupHandler((NlComponent)parentComponent);
        if (handler != null && handler instanceof DelegatedTreeEventHandler) {
            return (DelegatedTreeEventHandler)((Object)handler);
        }
        return null;
    }

    @Nullable
    public static TreePath getUniqueParent(@NotNull TreePath[] paths2) {
        TreePath parentPath;
        if (paths2.length == 0 || (parentPath = paths2[0].getParentPath()) == null) {
            return null;
        }
        for (int i2 = 1; i2 < paths2.length; ++i2) {
            if (paths2[i2].getParentPath() == parentPath) continue;
            return null;
        }
        return parentPath;
    }

    static boolean delegateEvent(@NotNull DelegatedTreeEvent.Type type, @NotNull NlComponentTree tree, @NotNull NlComponent receiver, int row) {
        TreePath uniqueParent;
        TreePath[] paths2 = tree.getSelectionPaths();
        if (paths2 != null && (uniqueParent = NlTreeUtil.getUniqueParent(paths2)) != null) {
            DelegatedTreeEventHandler handler;
            TreePath pathForRow;
            List<Object> draggedObject = NlTreeUtil.collectComponentsFromPaths(paths2);
            Object nextObject = null;
            if (row >= 0 && (pathForRow = tree.getPathForRow(row + 1)) != null && pathForRow.getParentPath() == uniqueParent) {
                nextObject = pathForRow.getLastPathComponent();
            }
            if ((handler = NlTreeUtil.getSelectionTreeHandler(tree)) != null) {
                return handler.handleTreeEvent(new DelegatedTreeEvent(tree, type, draggedObject, nextObject), receiver);
            }
        }
        return false;
    }

    @NotNull
    private static List<Object> collectComponentsFromPaths(@NotNull TreePath[] paths2) {
        return Arrays.stream(paths2).map(TreePath::getLastPathComponent).collect(Collectors.toList());
    }

    public static Collection<NlComponent> keepOnlyAncestors(@NotNull Collection<NlComponent> dragged) {
        Set selection = Sets.newIdentityHashSet();
        selection.addAll(dragged);
        Stack<NlComponent> toTraverse = new Stack<NlComponent>();
        for (NlComponent selectedElement : dragged) {
            List<NlComponent> children = selectedElement.getChildren();
            toTraverse.addAll(children);
            while (!toTraverse.isEmpty()) {
                NlComponent child = (NlComponent)toTraverse.pop();
                toTraverse.addAll(child.getChildren());
                if (!selection.contains(child)) continue;
                selection.remove(child);
            }
        }
        return selection;
    }
}

