/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupLayer
extends Layer {
    private final ScreenView myScreenView;
    private Dimension myScreenViewSize = new Dimension();
    @Nullable
    private NlModel myNlModel;
    private List<Mockup> myMockups;

    public MockupLayer(ScreenView screenView) {
        assert (screenView != null);
        this.myScreenView = screenView;
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        this.setNlModel(this.myScreenView.getModel());
        this.myMockups = Mockup.createAll(this.myNlModel);
    }

    public void setNlModel(@Nullable NlModel nlModel) {
        if (nlModel != null && nlModel != this.myNlModel) {
            nlModel.addListener(new ModelListener(){

                @Override
                public void modelDerivedDataChanged(@NotNull NlModel model2) {
                    MockupLayer.this.myMockups = Mockup.createAll(MockupLayer.this.myNlModel);
                }

                @Override
                public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
                }
            });
        }
        this.myNlModel = nlModel;
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        if (!this.myScreenView.getSurface().isMockupVisible() || this.myMockups.isEmpty()) {
            return;
        }
        Composite composite = g.getComposite();
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        for (int i2 = 0; i2 < this.myMockups.size(); ++i2) {
            Mockup mockup = this.myMockups.get(i2);
            this.paintMockup(g, mockup);
        }
        g.setComposite(composite);
    }

    private void paintMockup(@NotNull Graphics2D g, Mockup mockup) {
        BufferedImage image = mockup.getImage();
        if (image != null) {
            Rectangle dest = mockup.getScreenBounds(this.myScreenView);
            Rectangle src = mockup.getComputedCropping();
            g.setComposite(AlphaComposite.getInstance(3, mockup.getAlpha()));
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, dest.x, dest.y, dest.x + dest.width, dest.y + dest.height, src.x, src.y, src.x + src.width, src.y + src.height, null);
        }
    }
}

