/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.adaptiveicon.ShapeMenuAction;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.error.RenderIssueProvider;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfaceActionHandler;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.SimplerCanvasResizeInteraction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDesignSurface
extends DesignSurface
implements ViewGroupHandler.AccessoryPanelVisibility {
    @NotNull
    private SceneMode mySceneMode = SceneMode.Companion.loadPreferredMode();
    private int myScreenX = 70;
    private int myScreenY = 70;
    private boolean myIsCanvasResizing = false;
    private boolean myStackVertically;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private boolean myCentered;
    private final boolean myInPreview;
    private ShapeMenuAction.AdaptiveIconShape myAdaptiveIconShape = ShapeMenuAction.AdaptiveIconShape.getDefaultShape();
    private final RenderListener myRenderListener = this::modelRendered;
    private RenderIssueProvider myRenderIssueProvider;
    private AccessoryPanel myAccessoryPanel = new AccessoryPanel(AccessoryPanel.Type.SOUTH_PANEL, true);

    public NlDesignSurface(@NotNull Project project, boolean inPreview, @NotNull Disposable parentDisposable) {
        super(project, new SelectionModel(), parentDisposable);
        this.myInPreview = inPreview;
        this.myAccessoryPanel.setSurface(this);
    }

    public boolean isPreviewSurface() {
        return this.myInPreview;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    @NotNull
    public SceneMode getSceneMode() {
        return this.mySceneMode;
    }

    public void setScreenMode(@NotNull SceneMode sceneMode, boolean setAsDefault) {
        if (setAsDefault) {
            SceneMode.Companion.savePreferredMode(sceneMode);
        }
        if (sceneMode != this.mySceneMode) {
            this.mySceneMode = sceneMode;
            LayoutlibSceneManager manager = this.getSceneManager();
            if (manager != null) {
                manager.updateSceneView();
                manager.requestLayoutAndRender(false);
            }
            if (!this.contentResizeSkipped()) {
                this.zoomToFit();
            }
            this.layoutContent();
            this.updateScrolledAreaSize();
        }
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model2) {
        LayoutlibSceneManager manager = new LayoutlibSceneManager(model2, this);
        manager.addRenderListener(this.myRenderListener);
        return manager;
    }

    @Override
    @Nullable
    public LayoutlibSceneManager getSceneManager() {
        return (LayoutlibSceneManager)super.getSceneManager();
    }

    private int getSceneViewNumber() {
        return this.myModelToSceneManagers.size() * (this.getSceneMode() == SceneMode.BOTH ? 2 : 1);
    }

    public void forceLayersPaint(boolean value2) {
        for (Layer layer : this.getLayers()) {
            if (!(layer instanceof SceneLayer)) continue;
            SceneLayer sceneLayer = (SceneLayer)layer;
            sceneLayer.setTemporaryShow(value2);
            this.repaint();
        }
    }

    @Override
    @Nullable
    public SceneView getSceneView(int x, int y) {
        SceneView secondarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView primarySceneView = manager != null ? manager.getSceneView() : null;
        SceneView sceneView = secondarySceneView = manager != null ? manager.getSecondarySceneView() : null;
        if (secondarySceneView != null && x >= secondarySceneView.getX() && y >= secondarySceneView.getY()) {
            return secondarySceneView;
        }
        return primarySceneView;
    }

    @Override
    @NotNull
    public Rectangle getRenderableBoundsOfSceneView(@NotNull SceneView sceneView, @Nullable Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        Rectangle viewRect = this.myScrollPane.getViewport().getViewRect();
        LayoutlibSceneManager sceneManager = this.getSceneManager();
        assert (sceneManager != null);
        SceneView primary = sceneManager.getSceneView();
        SceneView secondary = sceneManager.getSecondarySceneView();
        if (secondary == null) {
            rectangle.setBounds(viewRect);
            return rectangle;
        }
        if (this.isStackVertically()) {
            int primaryBottom = primary.getY() + primary.getSize().height;
            int gapMidY = (primaryBottom + secondary.getY()) / 2;
            if (sceneView == primary) {
                viewRect.height = gapMidY;
            } else {
                viewRect.y = gapMidY;
                viewRect.height = viewRect.height - gapMidY + viewRect.y;
            }
        } else {
            int primaryRight = primary.getX() + primary.getSize().width;
            int gapMidX = (primaryRight + secondary.getX()) / 2;
            if (sceneView == primary) {
                viewRect.width = gapMidX;
            } else {
                viewRect.x = gapMidX;
                viewRect.width = viewRect.width - gapMidX + viewRect.x;
            }
        }
        rectangle.setBounds(viewRect);
        return rectangle;
    }

    @Override
    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        SceneView secondarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView primarySceneView = manager != null ? manager.getSceneView() : null;
        SceneView sceneView = secondarySceneView = manager != null ? manager.getSecondarySceneView() : null;
        if (secondarySceneView != null && x >= secondarySceneView.getX() && x <= secondarySceneView.getX() + secondarySceneView.getSize().width && y >= secondarySceneView.getY() && y <= secondarySceneView.getY() + secondarySceneView.getSize().height) {
            return secondarySceneView;
        }
        if (primarySceneView != null && x >= primarySceneView.getX() && x <= primarySceneView.getX() + primarySceneView.getSize().width && y >= primarySceneView.getY() && y <= primarySceneView.getY() + primarySceneView.getSize().height) {
            return primarySceneView;
        }
        return null;
    }

    @Override
    public Dimension getScrolledAreaSize() {
        int contentHeight;
        int contentWidth;
        SceneView primarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView sceneView = primarySceneView = manager != null ? manager.getSceneView() : null;
        if (primarySceneView == null) {
            return null;
        }
        Dimension size = primarySceneView.getSize();
        if (this.isStackVertically()) {
            contentWidth = size.width;
            contentHeight = (size.height + 10) * this.getSceneViewNumber() - 10;
        } else {
            contentWidth = (size.width + 10) * this.getSceneViewNumber() - 10;
            contentHeight = size.height;
        }
        return new Dimension(contentWidth + 100, contentHeight + 100);
    }

    public void setAdaptiveIconShape(@NotNull ShapeMenuAction.AdaptiveIconShape adaptiveIconShape) {
        this.myAdaptiveIconShape = adaptiveIconShape;
    }

    @NotNull
    public ShapeMenuAction.AdaptiveIconShape getAdaptiveIconShape() {
        return this.myAdaptiveIconShape;
    }

    @Override
    @NotNull
    public AccessoryPanel getAccessoryPanel() {
        return this.myAccessoryPanel;
    }

    public void showInspectorAccessoryPanel(boolean show) {
        for (DesignSurfaceListener listener2 : ImmutableList.copyOf((Collection)this.myListeners)) {
            listener2.showAccessoryPanel(this, show);
        }
    }

    @Override
    public void show(@NotNull AccessoryPanel.Type type, boolean show) {
        this.showInspectorAccessoryPanel(show);
    }

    private static boolean isVerticalScreenConfig(int availableWidth, int availableHeight, @NotNull Dimension preferredSize) {
        boolean stackVertically;
        boolean bl = stackVertically = preferredSize.width > preferredSize.height;
        if (availableWidth > 10 && availableHeight > 3 * availableWidth / 2) {
            stackVertically = true;
        }
        return stackVertically;
    }

    public void setCentered(boolean centered) {
        this.myCentered = centered;
    }

    @Override
    public float getSceneScalingFactor() {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            return (float)configuration.getDensity().getDpiValue() / (float)Density.DEFAULT_DENSITY;
        }
        return 1.0f;
    }

    @Override
    public float getScreenScalingFactor() {
        return JBUI.sysScale((Component)((Object)this));
    }

    @NotNull
    protected NlActionManager createActionManager() {
        return new NlActionManager(this);
    }

    @Override
    @NotNull
    public NlActionManager getActionManager() {
        return (NlActionManager)super.getActionManager();
    }

    @Override
    protected void layoutContent() {
        Iterator iterator = this.myModelToSceneManagers.values().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        LayoutlibSceneManager manager = (LayoutlibSceneManager)iterator.next();
        SceneView primarySceneView = manager.getSceneView();
        Dimension screenViewSize = primarySceneView.getSize();
        int availableWidth = this.myScrollPane.getWidth();
        int availableHeight = this.myScrollPane.getHeight();
        this.myStackVertically = NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, screenViewSize);
        if (!this.myIsCanvasResizing) {
            if (this.myCentered && availableWidth > 10 && availableHeight > 10) {
                int requiredWidth = screenViewSize.width;
                if (this.mySceneMode == SceneMode.BOTH && !this.myStackVertically) {
                    requiredWidth += 10;
                    requiredWidth += screenViewSize.width;
                }
                this.myScreenX = Math.max((availableWidth - requiredWidth) / 2, 70);
                int requiredHeight = screenViewSize.height;
                if (this.mySceneMode == SceneMode.BOTH && this.myStackVertically) {
                    requiredHeight += 10;
                    requiredHeight += screenViewSize.height;
                }
                this.myScreenY = Math.max((availableHeight - requiredHeight) / 2, 70);
            } else {
                this.myScreenX = 70;
                this.myScreenY = 70;
            }
        }
        SceneView secondarySceneView = manager.getSecondarySceneView();
        primarySceneView.setLocation(this.myScreenX, this.myScreenY);
        if (secondarySceneView != null) {
            if (this.myStackVertically) {
                secondarySceneView.setLocation(this.myScreenX, this.myScreenY + screenViewSize.height + 10);
            } else {
                secondarySceneView.setLocation(this.myScreenX + screenViewSize.width + 10, this.myScreenY);
            }
        }
        manager.getScene().needsRebuildList();
        int nextX = this.myScreenX + screenViewSize.width + 10;
        while (iterator.hasNext()) {
            LayoutlibSceneManager additionalManager = (LayoutlibSceneManager)iterator.next();
            SceneView view = additionalManager.getSceneView();
            view.setLocation(nextX, this.myScreenY);
            nextX += screenViewSize.width + 10;
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getContentOriginX() {
        return this.myScreenX;
    }

    @Override
    public int getContentOriginY() {
        return this.myScreenY;
    }

    public boolean isStackVertically() {
        return this.myStackVertically;
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension2) {
        SceneView secondarySceneView;
        LayoutlibSceneManager manager;
        if (dimension2 == null) {
            dimension2 = new Dimension();
        }
        SceneView primarySceneView = (manager = this.getSceneManager()) != null ? manager.getSceneView() : null;
        SceneView sceneView = secondarySceneView = manager != null ? manager.getSecondarySceneView() : null;
        if (this.mySceneMode == SceneMode.BOTH && primarySceneView != null && secondarySceneView != null) {
            if (this.isStackVertically()) {
                dimension2.setSize(primarySceneView.getSize().getWidth(), primarySceneView.getSize().getHeight() + secondarySceneView.getSize().getHeight());
            } else {
                dimension2.setSize(primarySceneView.getSize().getWidth() + secondarySceneView.getSize().getWidth(), primarySceneView.getSize().getHeight());
            }
        } else if (this.getCurrentSceneView() != null) {
            dimension2.setSize(this.getCurrentSceneView().getSize().getWidth(), this.getCurrentSceneView().getSize().getHeight());
        }
        if (this.isStackVertically()) {
            dimension2.height *= this.myModelToSceneManagers.size();
        } else {
            dimension2.width *= this.myModelToSceneManagers.size();
        }
        return dimension2;
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(120, 120);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        SceneView primarySceneView;
        LayoutlibSceneManager primarySceneManager = this.getSceneManager();
        SceneView sceneView = primarySceneView = primarySceneManager != null ? primarySceneManager.getSceneView() : null;
        if (primarySceneView == null) {
            return JBUI.emptySize();
        }
        Dimension preferredSize = primarySceneView.getPreferredSize();
        int requiredWidth = preferredSize.width;
        int requiredHeight = preferredSize.height;
        for (SceneManager sceneManager : this.myModelToSceneManagers.values()) {
            if (sceneManager == primarySceneManager) continue;
            Dimension size = sceneManager.getSceneView().getPreferredSize();
            if (this.isStackVertically()) {
                requiredWidth = Math.max(requiredWidth, size.width);
                requiredHeight += size.height;
                requiredHeight += 10;
                continue;
            }
            requiredWidth += size.width;
            requiredWidth += 10;
            requiredHeight = Math.max(requiredHeight, size.height);
        }
        if (this.mySceneMode == SceneMode.BOTH) {
            if (NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, preferredSize)) {
                requiredHeight *= 2;
                requiredHeight += 10;
            } else {
                requiredWidth *= 2;
                requiredWidth += 10;
            }
        }
        return new Dimension(requiredWidth, requiredHeight);
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        this.myAccessoryPanel.setModel(model2);
        return super.setModel(model2);
    }

    @Override
    public void dispose() {
        this.myAccessoryPanel.setSurface(null);
        super.dispose();
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component, int x, int y) {
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component);
        if (handler != null) {
            handler.onActivateInDesignSurface(component, this.getSceneManager().getViewEditor(), x, y);
        }
        super.notifyComponentActivate(component, x, y);
    }

    @Override
    @NotNull
    public Consumer<NlComponent> getComponentRegistrar() {
        return component -> NlComponentHelper.INSTANCE.registerComponent((NlComponent)component);
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    public void updateErrorDisplay() {
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                RenderResult result2;
                LayoutlibSceneManager sceneManager = NlDesignSurface.this.getSceneManager();
                RenderResult renderResult = result2 = sceneManager != null ? sceneManager.getRenderResult() : null;
                if (result2 == null) {
                    return;
                }
                ReadAction.run(() -> {
                    RenderErrorModel model2;
                    Project project = NlDesignSurface.this.getProject();
                    if (project.isDisposed()) {
                        return;
                    }
                    BuildMode gradleBuildMode = BuildSettings.getInstance(project).getBuildMode();
                    RenderErrorModel renderErrorModel = model2 = gradleBuildMode != null && result2.getLogger().hasErrors() ? RenderErrorModel.STILL_BUILDING_ERROR_MODEL : RenderErrorModelFactory.createErrorModel(NlDesignSurface.this, result2, DataManager.getInstance().getDataContext((Component)NlDesignSurface.this.getIssuePanel()));
                    if (NlDesignSurface.this.myRenderIssueProvider != null) {
                        NlDesignSurface.this.getIssueModel().removeIssueProvider(NlDesignSurface.this.myRenderIssueProvider);
                    }
                    NlDesignSurface.this.myRenderIssueProvider = new RenderIssueProvider(model2);
                    NlDesignSurface.this.getIssueModel().addIssueProvider(NlDesignSurface.this.myRenderIssueProvider);
                });
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private void modelRendered() {
        if (this.getCurrentSceneView() != null) {
            this.updateErrorDisplay();
            this.repaint();
            this.layoutContent();
        }
    }

    @Override
    public void forceUserRequestedRefresh() {
        for (SceneManager sceneManager : this.myModelToSceneManagers.values()) {
            LayoutlibSceneManager layoutlibSceneManager = (LayoutlibSceneManager)sceneManager;
            layoutlibSceneManager.requestUserInitiatedRender();
        }
    }

    @Override
    protected boolean useSmallProgressIcon() {
        if (this.getCurrentSceneView() == null) {
            return false;
        }
        LayoutlibSceneManager manager = this.getSceneManager();
        assert (manager != null);
        return manager.getRenderResult() != null;
    }

    @Override
    protected double getMinScale() {
        return Math.min(this.getFitScale(false), 1.0);
    }

    @Override
    protected double getMaxScale() {
        return 10.0;
    }

    @Override
    public boolean canZoomToFit() {
        return Math.abs(this.getScale() - this.getFitScale(true)) > 0.01;
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        Scene scene = this.getScene();
        SceneView view = this.getCurrentSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle componentsArea = new Rectangle(0, 0, -1, -1);
        Rectangle componentRect = new Rectangle();
        list.stream().filter(nlComponent -> !nlComponent.isRoot()).forEach(nlComponent -> {
            SceneComponent component = scene.getSceneComponent((NlComponent)nlComponent);
            if (component == null) {
                return;
            }
            component.fillRect(componentRect);
            if (componentsArea.width < 0) {
                componentsArea.setBounds(componentRect);
            } else {
                componentsArea.add(componentRect);
            }
        });
        Rectangle areaToCenter = Coordinates.getSwingRectDip(view, componentsArea);
        if (areaToCenter.isEmpty() || this.getLayeredPane().getVisibleRect().contains(areaToCenter)) {
            return;
        }
        Dimension swingViewportSize = this.getScrollPane().getViewport().getExtentSize();
        int targetSwingX = (int)areaToCenter.getCenterX();
        int targetSwingY = (int)areaToCenter.getCenterY();
        this.setScrollPosition(targetSwingX - swingViewportSize.width / 2, targetSwingY - swingViewportSize.height / 2);
        double fitScale = this.getFitScale(areaToCenter.getSize(), true);
        if (this.getScale() > fitScale) {
            this.setScale(fitScale, targetSwingX, targetSwingY);
        }
    }

    public boolean isResizeAvailable() {
        Configuration configuration = this.getConfiguration();
        if (configuration == null) {
            return false;
        }
        Device device = configuration.getDevice();
        if (device == null) {
            return false;
        }
        if (((Boolean)StudioFlags.NELE_SIMPLER_RESIZE.get()).booleanValue()) {
            return true;
        }
        return "Custom".equals(device.getId());
    }

    @Override
    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        super.notifySelectionListeners(newSelection);
        this.scrollToCenter(newSelection);
    }

    @Override
    @Nullable
    public Interaction doCreateInteractionOnClick(int mouseX, int mouseY, @NotNull SceneView view) {
        ScreenView screenView = (ScreenView)view;
        Dimension size = screenView.getSize();
        Rectangle resizeZone = new Rectangle(view.getX() + size.width, screenView.getY() + size.height, 48, 48);
        if (resizeZone.contains(mouseX, mouseY) && this.isResizeAvailable()) {
            Configuration configuration = this.getConfiguration();
            assert (configuration != null);
            if (((Boolean)StudioFlags.NELE_SIMPLER_RESIZE.get()).booleanValue()) {
                return new SimplerCanvasResizeInteraction(this, screenView, configuration);
            }
            return new CanvasResizeInteraction(this, screenView, configuration);
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        NlComponent component = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component == null) {
            if (!selectionModel.isEmpty()) {
                component = selectionModel.getPrimary();
            } else {
                return null;
            }
        }
        Interaction interaction = null;
        if (!selectionModel.isEmpty()) {
            ViewGroupHandler handler;
            NlComponent parent;
            NlComponent primary = screenView.getSelectionModel().getPrimary();
            NlComponent nlComponent = parent = primary != null ? primary.getParent() : null;
            if (parent != null && (handler = NlComponentHelperKt.getViewGroupHandler(parent)) != null) {
                interaction = handler.createInteraction(screenView, primary);
            }
        }
        if (interaction == null) {
            ViewGroupHandler viewGroupHandler;
            ViewGroupHandler viewGroupHandler2 = viewGroupHandler = component != null ? NlComponentHelperKt.getViewGroupHandler(component) : null;
            if (viewGroupHandler != null) {
                interaction = viewGroupHandler.createInteraction(screenView, component);
            }
        }
        if (interaction == null) {
            interaction = new SceneInteraction(screenView);
        }
        return interaction;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(@NotNull SceneComponent draggedSceneComponent, @Nullable SceneComponent primary) {
        List<Object> dragged;
        if (primary == null) {
            primary = draggedSceneComponent;
        }
        NlComponent primaryNlComponent = primary.getNlComponent();
        if (this.getSelectionModel().isSelected(draggedSceneComponent.getNlComponent())) {
            dragged = Lists.newArrayList();
            if (primary.getParent() == null) {
                primaryNlComponent = null;
            } else {
                dragged.add(primaryNlComponent);
            }
            for (NlComponent selected : this.getSelectionModel().getSelection()) {
                if (selected.isRoot() || selected == primaryNlComponent) continue;
                dragged.add(selected);
            }
        } else {
            dragged = Collections.singletonList(primaryNlComponent);
        }
        return new DragDropInteraction(this, dragged);
    }

    @Override
    @NotNull
    protected DesignSurfaceActionHandler createActionHandler() {
        return new NlDesignSurfaceActionHandler(this);
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            return Collections.emptyList();
        }
        ImmutableList<NlComponent> roots = model2.getComponents();
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        NlComponent root = (NlComponent)roots.get(0);
        if (root == null) {
            return Collections.emptyList();
        }
        return root.flatten().collect(Collectors.toList());
    }
}

