/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.BorderLayer;
import com.android.tools.idea.uibuilder.surface.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.DiagnosticsLayer;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenViewBase;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;

public class ScreenView
extends ScreenViewBase {
    protected final boolean myShowBorder;

    public ScreenView(@NotNull NlDesignSurface surface, @NotNull LayoutlibSceneManager manager) {
        super(surface, manager);
        this.myShowBorder = !this.getSurface().isPreviewSurface() || surface.getLayoutType() == LayoutFileType.INSTANCE;
    }

    @Override
    @NotNull
    protected ImmutableList<Layer> createLayers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.myShowBorder) {
            builder.add((Object)new BorderLayer(this));
        }
        builder.add((Object)new ScreenViewLayer(this));
        SceneLayer sceneLayer = new SceneLayer(this.getSurface(), this, false);
        sceneLayer.setAlwaysShowSelection(true);
        builder.add((Object)sceneLayer);
        if (this.getSceneManager().getModel().getType().isEditable()) {
            builder.add((Object)new CanvasResizeLayer(this.getSurface(), this));
        }
        if (((Boolean)StudioFlags.NELE_RENDER_DIAGNOSTICS.get()).booleanValue()) {
            builder.add((Object)new DiagnosticsLayer(this.getSurface()));
        }
        return builder.build();
    }
}

