/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.AndroidColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ScreenViewBase
extends SceneView {
    private final ColorSet myColorSet = new AndroidColorSet();
    protected boolean myIsSecondary;

    public ScreenViewBase(@NotNull NlDesignSurface surface, @NotNull LayoutlibSceneManager manager) {
        super(surface, manager);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@Nullable Dimension dimension2) {
        if (dimension2 == null) {
            dimension2 = new Dimension();
        }
        Configuration configuration = this.getConfiguration();
        Device device = configuration.getDevice();
        State state = configuration.getDeviceState();
        if (device != null && state != null) {
            HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
            dimension2.setSize(config.getScreenWidth(), config.getScreenHeight());
        }
        return dimension2;
    }

    @Override
    @Nullable
    public Cursor getCursor(int x, int y) {
        Rectangle resizeZone = new Rectangle(this.getX() + this.getSize().width, this.getY() + this.getSize().height, 48, 48);
        if (resizeZone.contains(x, y) && this.getSurface().isResizeAvailable()) {
            return Cursor.getPredefinedCursor(5);
        }
        return super.getCursor(x, y);
    }

    @Override
    @NotNull
    public LayoutlibSceneManager getSceneManager() {
        return (LayoutlibSceneManager)super.getSceneManager();
    }

    @Override
    @NotNull
    public NlDesignSurface getSurface() {
        return (NlDesignSurface)super.getSurface();
    }

    @Override
    @NotNull
    public ColorSet getColorSet() {
        return this.myColorSet;
    }

    @Nullable
    public RenderResult getResult() {
        return this.getSceneManager().getRenderResult();
    }

    final void setSecondary(boolean isSecondary) {
        this.myIsSecondary = isSecondary;
    }

    protected final boolean isSecondary() {
        return this.myIsSecondary;
    }
}

