/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.diagnostics.PerfDebugHelper;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.surface.DeviceSizeList;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplerCanvasResizeInteraction
extends Interaction {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private static final int MAX_ANDROID_SIZE = 1500;
    private static final String[] DEVICES_TO_SHOW = new String[]{"Nexus 5", "Nexus 7", "Nexus 9", "Nexus 10", "pixel_2", "pixel_3", "pixel_3_xl"};
    @NotNull
    private final NlDesignSurface myDesignSurface;
    @NotNull
    private final ScreenView myScreenView;
    @NotNull
    private final Configuration myConfiguration;
    private final OrientationLayer myOrientationLayer;
    private final SizeBucketLayer mySizeBucketLayer;
    private final List<DeviceLayer> myDeviceLayers = Lists.newArrayList();
    private final Device myOriginalDevice;
    private final State myOriginalDeviceState;
    private final DeviceSizeList myDeviceSizeList = new DeviceSizeList();
    private final MergingUpdateQueue myUpdateQueue;
    private final int myMaxSize;
    private final Update myLayerUpdate = new Update("CanvasResizeLayerUpdate"){

        public void run() {
            SimplerCanvasResizeInteraction.this.mySizeBucketLayer.reset();
            SimplerCanvasResizeInteraction.this.myOrientationLayer.reset();
        }
    };
    private final Update myPositionUpdate = new Update("CanvasResizePositionUpdate"){

        public void run() {
            int androidX = Coordinates.getAndroidX(SimplerCanvasResizeInteraction.this.myScreenView, SimplerCanvasResizeInteraction.this.myCurrentX);
            int androidY = Coordinates.getAndroidY(SimplerCanvasResizeInteraction.this.myScreenView, SimplerCanvasResizeInteraction.this.myCurrentY);
            if (androidX > 0 && androidY > 0 && androidX < SimplerCanvasResizeInteraction.this.myMaxSize && androidY < SimplerCanvasResizeInteraction.this.myMaxSize) {
                NlModelHelperKt.updateConfigurationScreenSize(SimplerCanvasResizeInteraction.this.myConfiguration, androidX, androidY);
            }
        }
    };
    private int myCurrentX;
    private int myCurrentY;
    @Nullable
    private DeviceSizeList.DeviceSize myLastSnappedDevice;
    private final PerfDebugHelper myPerfDebugHelper = new PerfDebugHelper();

    public SimplerCanvasResizeInteraction(@NotNull NlDesignSurface designSurface, @NotNull ScreenView screenView, @NotNull Configuration configuration) {
        List<Object> devicesToShow;
        this.myPerfDebugHelper.start("[Simple Resize] - constructor");
        this.myDesignSurface = designSurface;
        this.myScreenView = screenView;
        this.myConfiguration = configuration;
        this.myOrientationLayer = new OrientationLayer(this.myDesignSurface, this.myScreenView, this.myConfiguration);
        this.mySizeBucketLayer = new SizeBucketLayer();
        this.myUpdateQueue = new MergingUpdateQueue("layout.editor.canvas.resize", 100, true, null, (Disposable)this.myDesignSurface);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        this.myOriginalDevice = configuration.getDevice();
        this.myOriginalDeviceState = configuration.getDeviceState();
        double currentDpi = configuration.getDensity().getDpiValue();
        ConfigurationManager configManager = configuration.getConfigurationManager();
        boolean addSmallScreen = false;
        if (HardwareConfigHelper.isWear((Device)this.myOriginalDevice)) {
            devicesToShow = configManager.getDevices().stream().filter(d -> HardwareConfigHelper.isWear((Device)d) && !"Custom".equals(d.getId())).collect(Collectors.toList());
        } else if (HardwareConfigHelper.isTv((Device)this.myOriginalDevice)) {
            devicesToShow = Collections.singletonList(configManager.getDeviceById("tv_1080p"));
        } else {
            devicesToShow = Lists.newArrayListWithExpectedSize((int)DEVICES_TO_SHOW.length);
            for (String id : DEVICES_TO_SHOW) {
                devicesToShow.add(configManager.getDeviceById(id));
            }
            addSmallScreen = true;
        }
        for (Device device : devicesToShow) {
            assert (device != null);
            Screen screen = device.getDefaultHardware().getScreen();
            double dpiRatio = currentDpi / (double)screen.getPixelDensity().getDpiValue();
            int px = (int)((double)screen.getXDimension() * dpiRatio);
            int py = (int)((double)screen.getYDimension() * dpiRatio);
            this.myDeviceSizeList.add(device, px, py);
            this.myDeviceLayers.add(new DeviceLayer(this.myDesignSurface, this.myScreenView, this.myConfiguration, px, py, device.getDisplayName()));
        }
        this.myDeviceSizeList.sort();
        if (addSmallScreen) {
            this.myDeviceLayers.add(new DeviceLayer(this.myDesignSurface, this.myScreenView, this.myConfiguration, (int)(426.0 * currentDpi / (double)Density.DEFAULT_DENSITY), (int)(320.0 * currentDpi / (double)Density.DEFAULT_DENSITY), "Small Screen"));
        }
        this.myMaxSize = (int)(1500.0 * currentDpi / (double)Density.DEFAULT_DENSITY);
        this.myPerfDebugHelper.end("[Simple Resize] - constructor");
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        this.myPerfDebugHelper.start("[Simple Resize] - begin");
        super.begin(x, y, startMask);
        this.myCurrentX = x;
        this.myCurrentY = y;
        this.myDesignSurface.setResizeMode(true);
        this.myPerfDebugHelper.end("[Simple Resize] - begin");
    }

    private static void constructPolygon(@NotNull Polygon polygon, @Nullable ScreenRatio ratio, int dim, boolean isPortrait) {
        polygon.reset();
        int x1 = isPortrait ? 0 : dim;
        int y1 = isPortrait ? dim : 0;
        int x2 = isPortrait ? dim : 5 * dim / 3;
        int y2 = isPortrait ? 5 * dim / 3 : dim;
        polygon.addPoint(0, 0);
        if (ratio == null) {
            polygon.addPoint(x1, y1);
            polygon.addPoint(dim, dim);
        } else if (ratio == ScreenRatio.LONG) {
            polygon.addPoint(x1, y1);
            polygon.addPoint(x2, y2);
        } else {
            polygon.addPoint(x2, y2);
            polygon.addPoint(dim, dim);
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        this.myPerfDebugHelper.start("[Simple Resize] - update");
        if (this.myOriginalDevice.isScreenRound()) {
            int deltaX = x - this.myStartX;
            int deltaY = y - this.myStartY;
            if (deltaX > deltaY) {
                y = this.myStartY + deltaX;
            } else {
                x = this.myStartX + deltaY;
            }
        }
        this.snapToDevice(x, y);
        super.update(this.myCurrentX, this.myCurrentY, modifiers);
        JComponent layeredPane = this.myDesignSurface.getLayeredPane();
        int maxX = Coordinates.getSwingX((SceneView)this.myScreenView, this.myMaxSize) + 50;
        int maxY = Coordinates.getSwingY((SceneView)this.myScreenView, this.myMaxSize) + 50;
        if (this.myCurrentX < maxX && this.myCurrentY < maxY && (this.myCurrentX > layeredPane.getWidth() || this.myCurrentY > layeredPane.getHeight())) {
            Dimension d = layeredPane.getPreferredSize();
            layeredPane.setPreferredSize(new Dimension(Math.max(d.width, this.myCurrentX), Math.max(d.height, this.myCurrentY)));
            layeredPane.revalidate();
            this.myUpdateQueue.queue(this.myLayerUpdate);
        }
        this.myUpdateQueue.queue(this.myPositionUpdate);
        this.myPerfDebugHelper.end("[Simple Resize] - update");
    }

    private void snapToDevice(int x, int y) {
        int androidX = Coordinates.getAndroidX(this.myScreenView, x);
        int androidY = Coordinates.getAndroidY(this.myScreenView, y);
        int snapThreshold = Coordinates.getAndroidDimension(this.myScreenView, 20);
        this.myLastSnappedDevice = this.myDeviceSizeList.snapToDevice(androidX, androidY, snapThreshold);
        if (this.myLastSnappedDevice != null) {
            this.myCurrentX = Coordinates.getSwingX((SceneView)this.myScreenView, this.myLastSnappedDevice.getX());
            this.myCurrentY = Coordinates.getSwingY((SceneView)this.myScreenView, this.myLastSnappedDevice.getY());
        } else {
            this.myCurrentX = x;
            this.myCurrentY = y;
        }
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        this.myPerfDebugHelper.start("[Simple Resize] - end");
        super.end(x, y, modifiers, canceled);
        this.myDesignSurface.setResizeMode(false);
        int androidX = Coordinates.getAndroidX(this.myScreenView, x);
        int androidY = Coordinates.getAndroidY(this.myScreenView, y);
        if (canceled || androidX < 0 || androidY < 0) {
            this.myConfiguration.setEffectiveDevice(this.myOriginalDevice, this.myOriginalDeviceState);
        } else if (this.myLastSnappedDevice != null) {
            Device deviceToSnap = this.myLastSnappedDevice.getDevice();
            State deviceState = deviceToSnap.getState(androidX < androidY ? "Portrait" : "Landscape");
            this.myConfiguration.setEffectiveDevice(deviceToSnap, deviceState);
        } else {
            NlModelHelperKt.updateConfigurationScreenSize(this.myConfiguration, androidX, androidY);
        }
        this.myPerfDebugHelper.end("[Simple Resize] - end");
        this.myPerfDebugHelper.print();
    }

    @Override
    public synchronized List<Layer> createOverlays() {
        ImmutableList.Builder layers = ImmutableList.builder();
        if (HardwareConfigHelper.isMobile((Device)this.myOriginalDevice)) {
            layers.add((Object)this.mySizeBucketLayer);
        }
        layers.addAll(this.myDeviceLayers);
        layers.add((Object)this.myOrientationLayer);
        layers.add((Object)new ResizeLayer());
        return layers.build();
    }

    private class SizeBucketLayer
    extends Layer {
        private final Polygon myClip = new Polygon();
        private final FontMetrics myFontMetrics;
        private final Map<ScreenSize, SoftReference<BufferedImage>> myPortraitBuckets;
        private final Map<ScreenSize, SoftReference<BufferedImage>> myLandscapeBuckets;
        private int myTotalHeight;
        private int myTotalWidth;

        public SizeBucketLayer() {
            JScrollPane scrollPane = SimplerCanvasResizeInteraction.this.myDesignSurface.getScrollPane();
            JComponent layeredPane = SimplerCanvasResizeInteraction.this.myDesignSurface.getLayeredPane();
            this.myTotalHeight = layeredPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
            this.myTotalWidth = layeredPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
            this.myFontMetrics = SimplerCanvasResizeInteraction.this.myDesignSurface.getFontMetrics(SimplerCanvasResizeInteraction.this.myDesignSurface.getFont());
            int screenSizeNumbers = ScreenSize.values().length;
            this.myPortraitBuckets = Maps.newHashMapWithExpectedSize((int)screenSizeNumbers);
            this.myLandscapeBuckets = Maps.newHashMapWithExpectedSize((int)screenSizeNumbers);
        }

        @Override
        public synchronized void paint(@NotNull Graphics2D g2d) {
            BufferedImage bucket;
            int height;
            State deviceState = SimplerCanvasResizeInteraction.this.myConfiguration.getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            int width = Coordinates.getAndroidXDip(SimplerCanvasResizeInteraction.this.myScreenView, SimplerCanvasResizeInteraction.this.myCurrentX);
            if (width > (height = Coordinates.getAndroidYDip(SimplerCanvasResizeInteraction.this.myScreenView, SimplerCanvasResizeInteraction.this.myCurrentY)) && isDevicePortrait || width < height && !isDevicePortrait) {
                return;
            }
            int small = Math.min(width, height);
            int big = Math.max(width, height);
            ScreenSize screenSizeBucket = this.getScreenSizeBucket(small, big);
            Map<ScreenSize, SoftReference<BufferedImage>> buckets = isDevicePortrait ? this.myPortraitBuckets : this.myLandscapeBuckets;
            SoftReference<BufferedImage> bucketRef = buckets.get(screenSizeBucket);
            BufferedImage bufferedImage = bucket = bucketRef != null ? (BufferedImage)bucketRef.get() : null;
            if (bucket == null) {
                bucket = UIUtil.createImage((int)this.myTotalWidth, (int)this.myTotalHeight, (int)2);
                SimplerCanvasResizeInteraction.constructPolygon(this.myClip, null, Math.max(this.myTotalHeight, this.myTotalWidth), isDevicePortrait);
                this.myClip.translate(SimplerCanvasResizeInteraction.this.myScreenView.getX(), SimplerCanvasResizeInteraction.this.myScreenView.getY());
                Graphics2D graphics = bucket.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.clip(this.myClip);
                graphics.setColor(NlConstants.RESIZING_BUCKET_COLOR);
                Area coveredArea = this.getAreaForScreenSize(screenSizeBucket, SimplerCanvasResizeInteraction.this.myScreenView, isDevicePortrait);
                graphics.fill(coveredArea);
                graphics.setColor(NlConstants.RESIZING_CORNER_COLOR);
                graphics.setStroke(NlConstants.THICK_SOLID_STROKE);
                graphics.draw(coveredArea);
                graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
                Rectangle bounds = coveredArea.getBounds();
                if (isDevicePortrait) {
                    int left2 = bounds.x + 5;
                    int bottom2 = Math.min(bounds.y + bounds.height, this.myTotalHeight) - 5;
                    graphics.drawString(screenSizeBucket.getShortDisplayValue() + " size range", left2, bottom2);
                } else {
                    String text = screenSizeBucket.getShortDisplayValue() + " size range";
                    Rectangle2D textBounds = this.myFontMetrics.getStringBounds(text, null);
                    int left3 = (int)((double)Math.min(bounds.x + bounds.width, this.myTotalWidth) - textBounds.getWidth() - 5.0);
                    int bottom3 = (int)((double)bounds.y + textBounds.getHeight());
                    graphics.drawString(text, left3, bottom3);
                }
                graphics.dispose();
                buckets.put(screenSizeBucket, (SoftReference<BufferedImage>)new SoftReference((Object)bucket));
            }
            UIUtil.drawImage((Graphics)g2d, (BufferedImage)bucket, null, (int)0, (int)0);
        }

        @NotNull
        private ScreenSize getScreenSizeBucket(int small, int big) {
            if (big < 470) {
                return ScreenSize.SMALL;
            }
            if (big >= 960 && small >= 720) {
                return ScreenSize.XLARGE;
            }
            if (big >= 640 && small >= 480) {
                return ScreenSize.LARGE;
            }
            return ScreenSize.NORMAL;
        }

        @NotNull
        private Area getAreaForScreenSize(@NotNull ScreenSize screenSize, @NotNull SceneView screenView, boolean isDevicePortrait) {
            int x0 = screenView.getX();
            int y0 = screenView.getY();
            int smallX = Coordinates.getSwingXDip(screenView, 470);
            int smallY = Coordinates.getSwingYDip(screenView, 470);
            Area smallArea = new Area(new Rectangle(x0 - 2, y0 - 2, smallX - x0 + 2, smallY - y0 + 2));
            if (screenSize == ScreenSize.SMALL) {
                return smallArea;
            }
            int xlargeX = Coordinates.getSwingXDip(screenView, isDevicePortrait ? 720 : 960);
            int xlargeY = Coordinates.getSwingYDip(screenView, isDevicePortrait ? 960 : 720);
            Area xlargeArea = new Area(new Rectangle(xlargeX, xlargeY, this.myTotalWidth, this.myTotalHeight));
            if (screenSize == ScreenSize.XLARGE) {
                return xlargeArea;
            }
            int largeX = Coordinates.getSwingXDip(screenView, isDevicePortrait ? 480 : 640);
            int largeY = Coordinates.getSwingYDip(screenView, isDevicePortrait ? 640 : 480);
            Area largeArea = new Area(new Rectangle(largeX, largeY, this.myTotalWidth, this.myTotalHeight));
            if (screenSize == ScreenSize.LARGE) {
                largeArea.subtract(xlargeArea);
                return largeArea;
            }
            Area normalArea = new Area(new Rectangle(x0 - 2, y0 - 2, this.myTotalWidth, this.myTotalHeight));
            normalArea.subtract(smallArea);
            normalArea.subtract(largeArea);
            return normalArea;
        }

        public synchronized void reset() {
            JScrollPane scrollPane = SimplerCanvasResizeInteraction.this.myDesignSurface.getScrollPane();
            JComponent layeredPane = SimplerCanvasResizeInteraction.this.myDesignSurface.getLayeredPane();
            this.myTotalHeight = layeredPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
            this.myTotalWidth = layeredPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
            this.myPortraitBuckets.clear();
            this.myLandscapeBuckets.clear();
        }
    }

    private static class OrientationLayer
    extends Layer {
        private final Polygon myOrientationPolygon = new Polygon();
        private final double myPortraitWidth;
        private final double myLandscapeWidth;
        @NotNull
        private final NlDesignSurface myDesignSurface;
        @NotNull
        private final ScreenView myScreenView;
        @NotNull
        private final Configuration myConfiguration;
        private BufferedImage myOrientationImage;
        private ScreenOrientation myLastOrientation;

        public OrientationLayer(@NotNull NlDesignSurface designSurface, @NotNull ScreenView screenView, @NotNull Configuration configuration) {
            this.myDesignSurface = designSurface;
            this.myScreenView = screenView;
            this.myConfiguration = configuration;
            FontMetrics fontMetrics = this.myDesignSurface.getFontMetrics(this.myDesignSurface.getFont());
            this.myPortraitWidth = fontMetrics.getStringBounds("Portrait", null).getWidth();
            this.myLandscapeWidth = fontMetrics.getStringBounds("Landscape", null).getWidth();
        }

        @Override
        public synchronized void paint(@NotNull Graphics2D g2d) {
            BufferedImage image;
            State deviceState = this.myConfiguration.getDeviceState();
            assert (deviceState != null);
            ScreenOrientation currentOrientation = deviceState.getOrientation();
            boolean isDevicePortrait = currentOrientation == ScreenOrientation.PORTRAIT;
            BufferedImage bufferedImage = image = currentOrientation == this.myLastOrientation ? this.myOrientationImage : null;
            if (image == null) {
                int yL;
                int xL;
                int yP;
                int xP;
                this.myLastOrientation = currentOrientation;
                JComponent layeredPane = this.myDesignSurface.getLayeredPane();
                JScrollPane scrollPane = this.myDesignSurface.getScrollPane();
                int height = layeredPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
                int width = layeredPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
                int x0 = this.myScreenView.getX();
                int y0 = this.myScreenView.getY();
                int maxDim = Math.max(width, height);
                image = UIUtil.createImage((int)maxDim, (int)maxDim, (int)2);
                SimplerCanvasResizeInteraction.constructPolygon(this.myOrientationPolygon, null, maxDim, !isDevicePortrait);
                this.myOrientationPolygon.translate(x0, y0);
                Graphics2D graphics = image.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(NlConstants.UNAVAILABLE_ZONE_COLOR);
                graphics.fill(this.myOrientationPolygon);
                if ((double)(height - width) < this.myPortraitWidth / SQRT_2) {
                    xP = height - y0 + x0 - (int)(this.myPortraitWidth * SQRT_2) - 5;
                    yP = height;
                } else {
                    xP = width - (int)(this.myPortraitWidth / SQRT_2) - 5;
                    yP = width - x0 + y0 + (int)(this.myPortraitWidth / SQRT_2);
                }
                if ((double)(height - width) < (double)(y0 - x0) - this.myLandscapeWidth / SQRT_2) {
                    xL = height - y0 + x0 + 5;
                    yL = height;
                } else {
                    xL = width - (int)(this.myLandscapeWidth / SQRT_2);
                    yL = width - x0 + y0 - (int)(this.myLandscapeWidth / SQRT_2) - 5;
                }
                graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
                graphics.rotate(-0.7853981633974483, xL, yL);
                graphics.drawString("Landscape", xL, yL);
                graphics.rotate(0.7853981633974483, xL, yL);
                graphics.rotate(-0.7853981633974483, xP, yP);
                graphics.drawString("Portrait", xP, yP);
                graphics.dispose();
                this.myOrientationImage = image;
            }
            UIUtil.drawImage((Graphics)g2d, (BufferedImage)image, null, (int)0, (int)0);
        }

        public synchronized void reset() {
            this.myOrientationImage = null;
        }
    }

    private static class DeviceLayer
    extends Layer {
        private final String myName;
        @NotNull
        private final NlDesignSurface myDesignSurface;
        @NotNull
        private final ScreenView myScreenView;
        @NotNull
        private final Configuration myConfiguration;
        private final int myNameWidth;
        private final int myBigDimension;
        private final int mySmallDimension;

        public DeviceLayer(@NotNull NlDesignSurface designSurface, @NotNull ScreenView screenView, @NotNull Configuration configuration, int pxWidth, int pxHeight, @NotNull String name) {
            this.myDesignSurface = designSurface;
            this.myScreenView = screenView;
            this.myConfiguration = configuration;
            this.myBigDimension = Math.max(pxWidth, pxHeight);
            this.mySmallDimension = Math.min(pxWidth, pxHeight);
            this.myName = name;
            FontMetrics fontMetrics = this.myDesignSurface.getFontMetrics(this.myDesignSurface.getFont());
            this.myNameWidth = (int)fontMetrics.getStringBounds(this.myName, null).getWidth();
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            State deviceState = this.myConfiguration.getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            int x = Coordinates.getSwingX((SceneView)this.myScreenView, isDevicePortrait ? this.mySmallDimension : this.myBigDimension);
            int y = Coordinates.getSwingY((SceneView)this.myScreenView, isDevicePortrait ? this.myBigDimension : this.mySmallDimension);
            Graphics2D graphics = (Graphics2D)g2d.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(NlConstants.RESIZING_CORNER_COLOR);
            graphics.drawLine(x, y, x - 32, y);
            graphics.drawLine(x, y, x, y - 32);
            graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
            graphics.drawString(this.myName, x - this.myNameWidth - 5, y - 5);
            graphics.dispose();
        }
    }

    private class ResizeLayer
    extends Layer {
        private ResizeLayer() {
        }

        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            int x = SimplerCanvasResizeInteraction.this.myScreenView.getX();
            int y = SimplerCanvasResizeInteraction.this.myScreenView.getY();
            if (SimplerCanvasResizeInteraction.this.myCurrentX > x && SimplerCanvasResizeInteraction.this.myCurrentY > y) {
                Graphics2D graphics = (Graphics2D)g2d.create();
                graphics.setColor(NlConstants.RESIZING_CONTOUR_COLOR);
                graphics.setStroke(NlConstants.THICK_SOLID_STROKE);
                graphics.drawRect(x - 1, y - 1, SimplerCanvasResizeInteraction.this.myCurrentX - x, SimplerCanvasResizeInteraction.this.myCurrentY - y);
                graphics.dispose();
            }
        }
    }
}

