/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.PackageOperation;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsTreeNode
extends UpdaterTreeNode {
    private PackageNodeModel myModel;
    private final ChangeListener myChangeListener;
    private SdkUpdaterConfigurable myConfigurable;

    public DetailsTreeNode(@NotNull PackageNodeModel state, @Nullable ChangeListener changeListener, @NotNull SdkUpdaterConfigurable configurable) {
        this.myModel = state;
        this.myModel.setState(this.getInitialState());
        this.myChangeListener = changeListener;
        this.myConfigurable = configurable;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getInitialState() {
        return this.myModel.getPkg().isUpdate() ? PackageNodeModel.SelectedState.MIXED : (this.myModel.getPkg().hasLocal() ? PackageNodeModel.SelectedState.INSTALLED : PackageNodeModel.SelectedState.NOT_INSTALLED);
    }

    @Override
    @Nullable
    public PackageNodeModel.SelectedState getCurrentState() {
        return this.myModel.getState();
    }

    @Override
    public int compareTo(@NotNull UpdaterTreeNode o) {
        if (!(o instanceof DetailsTreeNode)) {
            return this.toString().compareTo(o.toString());
        }
        return this.myModel.getPkg().compareTo(((DetailsTreeNode)o).myModel.getPkg());
    }

    @Override
    protected void setState(@NotNull PackageNodeModel.SelectedState state) {
        this.myModel.setState(state);
        if (this.myChangeListener != null) {
            this.myChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean equals(@NotNull Object obj) {
        if (!(obj instanceof DetailsTreeNode)) {
            return false;
        }
        return this.myModel.getPkg().equals(((DetailsTreeNode)obj).myModel.getPkg());
    }

    @Override
    public boolean includeInSummary() {
        return this.myModel.getPkg().getRepresentative().getTypeDetails() instanceof DetailsTypes.SourceDetailsType || this.myModel.getPkg().getRepresentative().getTypeDetails() instanceof DetailsTypes.PlatformDetailsType;
    }

    @Nullable
    private String getDisplayName() {
        return this.myModel.getTitle();
    }

    @Override
    public boolean isPrimary() {
        return this.myModel.getPkg().getRepresentative().getTypeDetails() instanceof DetailsTypes.PlatformDetailsType;
    }

    @Override
    public void customizeRenderer(@NotNull UpdaterTreeNode.Renderer renderer, @Nullable JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        renderer.getTextRenderer().append(this.getDisplayName(), attributes);
    }

    @NotNull
    public UpdatablePackage getItem() {
        return this.myModel.getPkg();
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.myModel.getPkg().isUpdate();
    }

    @Override
    @NotNull
    public String getStatusString() {
        if (this.getInitialState() == PackageNodeModel.SelectedState.INSTALLED) {
            return "Installed";
        }
        RepoManager mgr = this.myConfigurable.getRepoManager();
        RemotePackage remote = this.getItem().getRemote();
        assert (remote != null);
        PackageOperation installer = mgr.getInProgressInstallOperation((RepoPackage)remote);
        if (installer != null) {
            PackageOperation.InstallStatus status = installer.getInstallStatus();
            if (status == PackageOperation.InstallStatus.PREPARING) {
                return "Preparing install...";
            }
            if (status == PackageOperation.InstallStatus.PREPARED) {
                return "Install ready";
            }
        }
        if (this.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            return "Not installed";
        }
        return "Update Available: " + this.myModel.getPkg().getRemote().getVersion();
    }

    @NotNull
    public RepoPackage getPackage() {
        return this.getItem().getRepresentative();
    }
}

