/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.repository.io.FileOp;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkLocationUtils {
    private SdkLocationUtils() {
    }

    public static boolean isWritable(@NotNull FileOp fileOp, @Nullable File sdkLocation) {
        if (sdkLocation == null) {
            return false;
        }
        if (fileOp.exists(sdkLocation)) {
            return fileOp.isDirectory(sdkLocation) && fileOp.canWrite(sdkLocation);
        }
        File parent = SdkLocationUtils.getFirstExistentParent(fileOp, sdkLocation);
        return parent != null && fileOp.canWrite(parent);
    }

    @Nullable
    private static File getFirstExistentParent(@NotNull FileOp fileOp, @NotNull File file) {
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!fileOp.exists(parent)) continue;
            return parent;
        }
        return null;
    }
}

