/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.io.FileOpUtils;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.ElevatedCommandLine;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.wizard.deprecated.HaxmUninstallInfoStep;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class Haxm
extends InstallableComponent {
    public static final Storage.Unit UI_UNITS = Storage.Unit.MiB;
    public static final Logger LOG = Logger.getInstance(Haxm.class);
    public static final IdDisplay ID_INTEL = IdDisplay.create((String)"intel", (String)"");
    public static final String COMPONENT_PATH = "Hardware_Accelerated_Execution_Manager";
    public static final String REPO_PACKAGE_PATH = "extras;intel;Hardware_Accelerated_Execution_Manager";
    public static final String RUNNING_INTEL_HAXM_INSTALLER_MESSAGE = "Running Intel\u00ae HAXM installer";
    private static final int INTEL_HAXM_INSTALLER_EXIT_CODE_SUCCESS = 0;
    private static final int INTEL_HAXM_INSTALLER_EXIT_CODE_REBOOT_REQUIRED = 2;
    private static final ScopedStateStore.Key<Integer> KEY_EMULATOR_MEMORY_MB = ScopedStateStore.createKey("emulator.memory", ScopedStateStore.Scope.PATH, Integer.class);
    private final ScopedStateStore.Key<Boolean> myIsCustomInstall;
    private ProgressStep myProgressStep;
    private final HaxmInstallationIntention myInstallationIntention;
    private boolean myHaxmInstallerSuccessfullyCompleted = false;
    private static AccelerationErrorCode ourInitialCheck;

    public Haxm(@NotNull HaxmInstallationIntention installationIntention, @NotNull ScopedStateStore store, @NotNull ScopedStateStore.Key<Boolean> isCustomInstall) {
        super(store, "Performance (Intel \u00ae HAXM)", "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)", installationIntention == HaxmInstallationIntention.INSTALL_WITH_UPDATES, FileOpUtils.create());
        this.myIsCustomInstall = isCustomInstall;
        this.myInstallationIntention = installationIntention;
    }

    public HaxmInstallationIntention getInstallationIntention() {
        return this.myInstallationIntention;
    }

    public boolean isConfiguredSuccessfully() {
        return this.myHaxmInstallerSuccessfullyCompleted;
    }

    public static boolean canRun() {
        if (ourInitialCheck == null) {
            ourInitialCheck = Haxm.checkHaxmInstallation();
        }
        switch (ourInitialCheck) {
            case NO_EMULATOR_INSTALLED: 
            case UNKNOWN_ERROR: {
                return SystemInfo.isMac || SystemInfo.isWindows;
            }
            case NOT_ENOUGH_MEMORY: 
            case ALREADY_INSTALLED: {
                return false;
            }
        }
        switch (ourInitialCheck.getSolution()) {
            case INSTALL_HAXM: 
            case REINSTALL_HAXM: {
                return true;
            }
        }
        return false;
    }

    public static AccelerationErrorCode checkHaxmInstallation() {
        if (!SystemInfo.isWindows && !SystemInfo.isMac) {
            return AccelerationErrorCode.CANNOT_INSTALL_ON_THIS_OS;
        }
        AvdManagerConnection manager = AvdManagerConnection.getDefaultAvdManagerConnection();
        return manager.checkAcceleration();
    }

    @NotNull
    private static GeneralCommandLine addInstallParameters(@NotNull GeneralCommandLine cl, int memorySize) {
        cl.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        return cl;
    }

    @NotNull
    private static GeneralCommandLine addUninstallParameters(@NotNull GeneralCommandLine cl) {
        cl.addParameters(new String[]{"-u"});
        return cl;
    }

    private static GeneralCommandLine getMacHaxmCommandLine(File path) throws WizardException {
        Haxm.ensureExistsAndIsExecutable(path, "silent_install.sh");
        File executable = Haxm.ensureExistsAndIsExecutable(path, "HAXM installation");
        return new GeneralCommandLine(new String[]{executable.getAbsolutePath()}).withWorkDirectory(path);
    }

    @NotNull
    private static File ensureExistsAndIsExecutable(File path, String exeName) throws WizardException {
        File executable = new File(path, exeName);
        if (!executable.isFile()) {
            throw new WizardException("HAXM installer executable is missing: " + executable.getAbsolutePath());
        }
        if (executable.canExecute() || executable.setExecutable(true)) {
            return executable;
        }
        throw new WizardException("Unable to set execute permission bit on HAXM installer executable: " + executable.getAbsolutePath());
    }

    @NotNull
    private static GeneralCommandLine getWindowsHaxmCommandLine(File source) throws IOException {
        File batFile = new File(source, "silent_install.bat");
        File logFile = FileUtil.createTempFile((String)"haxm_log", (String)".txt");
        return new ElevatedCommandLine(batFile.getAbsolutePath()).withTempFilePrefix("haxm").withWorkDirectory(source).withParameters(new String[]{"-log", logFile.getPath()});
    }

    private static int getRecommendedMemoryAllocation() {
        return FirstRunWizardDefaults.getRecommendedHaxmMemory(AvdManagerConnection.getMemorySize());
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        this.myProgressStep = progressStep;
        if (this.myInstallationIntention == HaxmInstallationIntention.INSTALL_WITH_UPDATES || this.myInstallationIntention == HaxmInstallationIntention.INSTALL_WITHOUT_UPDATES) {
            this.myStateStore.put(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        }
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        if (this.myInstallationIntention == HaxmInstallationIntention.UNINSTALL) {
            return Collections.singleton(new HaxmUninstallInfoStep());
        }
        return Collections.singleton(new HaxmInstallSettingsStep(this.myIsCustomInstall, this.myKey, KEY_EMULATOR_MEMORY_MB));
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        File sdkRoot = sdkHandler.getLocation();
        if (sdkRoot == null) {
            installContext.print("HAXM installer could not be run because SDK root isn't specified", ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        if (this.myInstallationIntention == HaxmInstallationIntention.UNINSTALL) {
            this.configureForUninstall(installContext, sdkRoot);
            return;
        }
        AccelerationErrorCode accelerationErrorCode = Haxm.checkHaxmInstallation();
        AccelerationErrorSolution.SolutionCode solution = accelerationErrorCode.getSolution();
        if (accelerationErrorCode == AccelerationErrorCode.ALREADY_INSTALLED) {
            if (this.myInstallationIntention == HaxmInstallationIntention.INSTALL_WITHOUT_UPDATES) {
                this.myHaxmInstallerSuccessfullyCompleted = true;
                return;
            }
            solution = AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM;
        }
        switch (solution) {
            case INSTALL_HAXM: 
            case REINSTALL_HAXM: {
                try {
                    GeneralCommandLine commandLine = this.getInstallCommandLine(sdkRoot);
                    this.runInstaller(installContext, commandLine);
                }
                catch (WizardException | IOException e) {
                    LOG.warn(String.format("Tried to install HAXM on %s OS with %s memory size", Platform.current().name(), String.valueOf(AvdManagerConnection.getMemorySize())), (Throwable)e);
                    installContext.print("Unable to install Intel HAXM\n", ConsoleViewContentType.ERROR_OUTPUT);
                    String message2 = e.getMessage();
                    if (!StringUtil.endsWithLineBreak((CharSequence)message2)) {
                        message2 = message2 + "\n";
                    }
                    installContext.print(message2, ConsoleViewContentType.ERROR_OUTPUT);
                }
                break;
            }
            case NONE: {
                String message3 = String.format("Unable to install Intel HAXM\n%1$s\n%2$s\n", accelerationErrorCode.getProblem(), accelerationErrorCode.getSolutionMessage());
                installContext.print(message3, ConsoleViewContentType.ERROR_OUTPUT);
                break;
            }
        }
    }

    private void configureForUninstall(@NotNull InstallContext installContext, @NotNull File sdkRoot) {
        if (Haxm.isInstalled(installContext, sdkRoot)) {
            try {
                GeneralCommandLine commandLine = Haxm.getUninstallCommandLine(sdkRoot);
                this.runInstaller(installContext, commandLine);
            }
            catch (WizardException | IOException e) {
                LOG.warn(String.format("Tried to uninstall HAXM on %s OS", Platform.current().name()), (Throwable)e);
                installContext.print("Unable to uninstall Intel HAXM\n", ConsoleViewContentType.ERROR_OUTPUT);
                String message2 = e.getMessage();
                if (!StringUtil.endsWithLineBreak((CharSequence)message2)) {
                    message2 = message2 + "\n";
                }
                installContext.print(message2, ConsoleViewContentType.ERROR_OUTPUT);
            }
        } else {
            installContext.print("HAXM is not installed, so not proceeding with its uninstallation.", ConsoleViewContentType.NORMAL_OUTPUT);
            this.myHaxmInstallerSuccessfullyCompleted = true;
        }
    }

    private static boolean isInstalled(@NotNull InstallContext context, @NotNull File sdkRoot) {
        try {
            GeneralCommandLine command = Haxm.getInstallerCommandLine(sdkRoot);
            command.addParameter("-v");
            OSProcessHandler processHandler = new OSProcessHandler(command);
            processHandler.startNotify();
            processHandler.waitFor();
            Integer exitCode = processHandler.getExitCode();
            return exitCode != null && exitCode == 0;
        }
        catch (WizardException | ExecutionException | IOException exception) {
            context.print("Failed to determine whether HAXM is installed: " + exception.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            return false;
        }
    }

    private void runInstaller(@NotNull InstallContext installContext, @NotNull GeneralCommandLine commandLine) {
        try {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(true);
                progressIndicator.setText(RUNNING_INTEL_HAXM_INSTALLER_MESSAGE);
            }
            installContext.print("Running Intel\u00ae HAXM installer\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            final StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }
            });
            this.myProgressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                if (SystemInfo.isWindows && exitCode == 2) {
                    String rebootMessage = "Reboot required: HAXM installation succeeded, however the installer reported that a reboot is required in order for the changes to take effect";
                    installContext.print(rebootMessage, ConsoleViewContentType.NORMAL_OUTPUT);
                    AccelerationErrorSolution.promptAndRebootAsync(rebootMessage, ModalityState.NON_MODAL);
                    this.myHaxmInstallerSuccessfullyCompleted = true;
                    return;
                }
                if (this.myInstallationIntention == HaxmInstallationIntention.UNINSTALL) {
                    installContext.print("HAXM uninstallation failed", ConsoleViewContentType.ERROR_OUTPUT);
                } else {
                    installContext.print(String.format("HAXM installation failed. To install HAXM follow the instructions found at: %s", SystemInfo.isWindows ? "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-windows" : "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-mac-os-x"), ConsoleViewContentType.ERROR_OUTPUT);
                }
                Matcher m = Pattern.compile("installation log:\\s*\"(.*)\"").matcher(output.toString());
                if (m.find()) {
                    String file = m.group(1);
                    installContext.print(String.format("Installer log is located at %s", file), ConsoleViewContentType.ERROR_OUTPUT);
                    try {
                        installContext.print("Installer log contents:\n", ConsoleViewContentType.ERROR_OUTPUT);
                        installContext.print(FileUtil.loadFile((File)new File(file), (String)"UTF-16"), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        installContext.print("Failed to read installer output log.\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
                if (progressIndicator != null) {
                    progressIndicator.setFraction(1.0);
                }
                this.myHaxmInstallerSuccessfullyCompleted = false;
                return;
            }
            if (progressIndicator != null) {
                progressIndicator.setFraction(1.0);
            }
            this.myHaxmInstallerSuccessfullyCompleted = true;
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Intel HAXM installer: " + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private GeneralCommandLine getInstallCommandLine(@NotNull File sdk) throws WizardException, IOException {
        int memorySize = this.myStateStore.getNotNull(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        return Haxm.addInstallParameters(Haxm.getInstallerCommandLine(sdk), memorySize);
    }

    @NotNull
    private static GeneralCommandLine getInstallerCommandLine(@NotNull File sdk) throws WizardException, IOException {
        if (SystemInfo.isMac) {
            return Haxm.getMacHaxmCommandLine(Haxm.getSourceLocation(sdk));
        }
        if (SystemInfo.isWindows) {
            return Haxm.getWindowsHaxmCommandLine(Haxm.getSourceLocation(sdk));
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @NotNull
    private static GeneralCommandLine getUninstallCommandLine(File sdk) throws WizardException, IOException {
        if (SystemInfo.isMac) {
            return Haxm.addUninstallParameters(Haxm.getMacHaxmCommandLine(Haxm.getSourceLocation(sdk)));
        }
        if (SystemInfo.isWindows) {
            return Haxm.addUninstallParameters(Haxm.getWindowsHaxmCommandLine(Haxm.getSourceLocation(sdk)));
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @NotNull
    private static File getSourceLocation(File sdk) {
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        return new File(sdk, path);
    }

    @Override
    @NotNull
    public Collection<String> getRequiredSdkPackages() {
        return ImmutableList.of((Object)REPO_PACKAGE_PATH);
    }

    public static enum HaxmInstallationIntention {
        INSTALL_WITH_UPDATES,
        INSTALL_WITHOUT_UPDATES,
        UNINSTALL;

    }
}

