/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOp;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class InstallableComponent
extends ComponentTreeNode {
    protected final ScopedStateStore.Key<Boolean> myKey;
    protected final ScopedStateStore myStateStore;
    @NotNull
    private final String myName;
    private Boolean myUserSelection;
    private boolean myIsOptional = true;
    private boolean myIsInstalled = false;
    private static final ProgressIndicator PROGRESS_LOGGER = new StudioLoggerProgressIndicator(InstallableComponent.class);
    protected final FileOp myFileOp;
    protected final boolean myInstallUpdates;
    protected AndroidSdkHandler mySdkHandler;

    public InstallableComponent(@NotNull ScopedStateStore stateStore, @NotNull String name, @NotNull String description, boolean installUpdates, @NotNull FileOp fop) {
        super(description);
        this.myInstallUpdates = installUpdates;
        this.myStateStore = stateStore;
        this.myName = name;
        this.myKey = stateStore.createKey("component.enabled." + System.identityHashCode(this), Boolean.class);
        this.myFileOp = fop;
    }

    @Override
    public String getLabel() {
        String sizeLabel = this.isInstalled() ? "installed" : WelcomeUIUtils.getSizeLabel(this.getDownloadSize());
        return String.format("%s \u2013 (%s)", this.myName, sizeLabel);
    }

    private boolean isInstalled() {
        return this.myIsInstalled;
    }

    @NotNull
    public Collection<UpdatablePackage> getPackagesToInstall() {
        ArrayList result2 = Lists.newArrayList();
        Map consolidatedPackages = this.getRepositoryPackages().getConsolidatedPkgs();
        for (String path : this.getRequiredSdkPackages()) {
            UpdatablePackage p = (UpdatablePackage)consolidatedPackages.get(path);
            if (p == null || !p.hasRemote() || p.hasLocal() && (!this.myInstallUpdates || !p.isUpdate())) continue;
            result2.add(p);
        }
        return result2;
    }

    protected RepositoryPackages getRepositoryPackages() {
        return this.mySdkHandler.getSdkManager(PROGRESS_LOGGER).getPackages();
    }

    @NotNull
    protected abstract Collection<String> getRequiredSdkPackages();

    public abstract void configure(@NotNull InstallContext var1, @NotNull AndroidSdkHandler var2);

    protected boolean isSelectedByDefault() {
        return true;
    }

    @Override
    public boolean isOptional() {
        return this.myIsOptional;
    }

    protected boolean isOptionalForSdkLocation() {
        return true;
    }

    @Override
    public Collection<InstallableComponent> getChildrenToInstall() {
        if (!this.myStateStore.getNotNull(this.myKey, true).booleanValue()) {
            return Collections.emptySet();
        }
        return Collections.singleton(this);
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        return Collections.emptySet();
    }

    @Override
    public void updateState(@NotNull AndroidSdkHandler sdkHandler) {
        this.mySdkHandler = sdkHandler;
        boolean nothingToInstall = !SdkLocationUtils.isWritable(this.myFileOp, sdkHandler.getLocation()) || this.getPackagesToInstall().isEmpty();
        boolean bl = this.myIsOptional = !nothingToInstall && this.isOptionalForSdkLocation();
        boolean isSelected = !this.myIsOptional ? !nothingToInstall : (this.myUserSelection != null ? this.myUserSelection.booleanValue() : this.isSelectedByDefault());
        this.myStateStore.put(this.myKey, isSelected);
        this.myIsInstalled = this.checkInstalledPackages();
    }

    private boolean checkInstalledPackages() {
        if (this.mySdkHandler != null) {
            return this.getPackagesToInstall().isEmpty();
        }
        return false;
    }

    @Override
    public void toggle(boolean isSelected) {
        if (this.myIsOptional) {
            this.myUserSelection = isSelected;
            this.myStateStore.put(this.myKey, isSelected);
        }
    }

    @Override
    public Collection<ComponentTreeNode> getImmediateChildren() {
        return Collections.emptySet();
    }

    @Override
    public boolean isChecked() {
        return this.myStateStore.getNotNull(this.myKey, true);
    }

    public long getDownloadSize() {
        long size = 0L;
        for (UpdatablePackage updatable : this.getPackagesToInstall()) {
            Archive archive = updatable.getRemote().getArchive();
            if (archive == null) continue;
            size += archive.getComplete().getSize();
        }
        return size;
    }

    @Override
    public boolean componentStateChanged(@NotNull Set<ScopedStateStore.Key> modified) {
        return modified.contains(this.myKey);
    }
}

