/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.wizard.ConfigureInstallationModel;
import com.android.tools.idea.welcome.wizard.ConfirmFirstRunWizardCloseDialog;
import com.android.tools.idea.welcome.wizard.FirstRunWelcomeStep;
import com.android.tools.idea.welcome.wizard.InstallationTypeWizardStep;
import com.android.tools.idea.welcome.wizard.SelectThemeStep;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class StudioFirstRunWelcomeScreen
implements WelcomeScreen {
    @NotNull
    private final ModelWizard myModelWizard;
    @NotNull
    private final JComponent myMainPanel;
    private final FirstRunWizardMode myMode;

    public StudioFirstRunWelcomeScreen(FirstRunWizardMode mode) {
        this.myMode = mode;
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        ConfigureInstallationModel model2 = new ConfigureInstallationModel();
        boolean sdkExists = false;
        File initialSdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(mode);
        if (initialSdkLocation.isDirectory()) {
            StudioLoggerProgressIndicator progress;
            AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((File)initialSdkLocation);
            sdkExists = sdkHandler.getLocalPackage("tools", (ProgressIndicator)(progress = new StudioLoggerProgressIndicator(this.getClass()))) != null;
        }
        wizardBuilder.addStep(new FirstRunWelcomeStep(sdkExists));
        if (initialSdkLocation.getPath().isEmpty()) {
            model2.installationType().set(ConfigureInstallationModel.InstallationType.CUSTOM);
        } else {
            wizardBuilder.addStep(new InstallationTypeWizardStep(model2));
        }
        wizardBuilder.addStep(new SelectThemeStep());
        this.myModelWizard = wizardBuilder.build();
        ModelWizardDialog modelWizardDialog = new StudioWizardDialogBuilder(this.myModelWizard, "").build();
        this.myMainPanel = modelWizardDialog.getContentPanel();
        modelWizardDialog.getPeer().setContentPane((JComponent)new JPanel());
        Disposer.register((Disposable)this, (Disposable)modelWizardDialog.getDisposable());
        Disposer.register((Disposable)this, (Disposable)this.myModelWizard);
    }

    public JComponent getWelcomePanel() {
        return this.myMainPanel;
    }

    public void setupFrame(final @NotNull JFrame frame) {
        frame.setTitle(AndroidBundle.message("android.wizard.welcome.dialog.title", new Object[0]));
        frame.pack();
        frame.setLocationRelativeTo(null);
        WindowListener[] oldIdeaListeners = StudioFirstRunWelcomeScreen.removeAllWindowListeners(frame);
        frame.addWindowListener(new DelegatingListener(oldIdeaListeners));
        this.myModelWizard.addResultListener(new ModelWizard.WizardListener(){

            @Override
            public void onWizardFinished(@NotNull ModelWizard.WizardResult wizardResult) {
                StudioFirstRunWelcomeScreen.closeDialog(frame);
            }
        });
        this.myModelWizard.setCancelInterceptor(() -> this.shouldPreventWizardCancel(frame));
    }

    public void dispose() {
    }

    private static void closeDialog(Window frame) {
        frame.setVisible(false);
        frame.dispose();
        WelcomeFrame.showNow();
    }

    private boolean shouldPreventWizardCancel(Window frame) {
        ConfirmFirstRunWizardCloseDialog.Result result2 = new ConfirmFirstRunWizardCloseDialog().open();
        switch (result2) {
            case Skip: {
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.myMode.getInstallerTimestamp());
            }
            case Rerun: {
                StudioFirstRunWelcomeScreen.closeDialog(frame);
                return false;
            }
            case DoNotClose: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid Close result");
            }
        }
        return true;
    }

    private static WindowListener[] removeAllWindowListeners(Window frame) {
        WindowListener[] listeners;
        for (WindowListener listener2 : listeners = frame.getWindowListeners()) {
            frame.removeWindowListener(listener2);
        }
        return listeners;
    }

    private class DelegatingListener
    implements WindowListener {
        @NotNull
        private final WindowListener[] myIdeaListeners;

        public DelegatingListener(WindowListener[] ideaListeners) {
            this.myIdeaListeners = ideaListeners;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            for (WindowListener listener2 : this.myIdeaListeners) {
                listener2.windowOpened(e);
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            for (WindowListener listener2 : this.myIdeaListeners) {
                listener2.windowClosed(e);
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            for (WindowListener listener2 : this.myIdeaListeners) {
                listener2.windowIconified(e);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            StudioFirstRunWelcomeScreen.this.myModelWizard.cancel();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            for (WindowListener listener2 : this.myIdeaListeners) {
                listener2.windowDeiconified(e);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            for (WindowListener listener2 : this.myIdeaListeners) {
                listener2.windowActivated(e);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            for (WindowListener listener2 : this.myIdeaListeners) {
                listener2.windowDeactivated(e);
            }
        }
    }
}

