/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallSummaryStep
extends FirstRunWizardStep {
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private final ScopedStateStore.Key<String> myKeySdkInstallLocation;
    private final ScopedStateStore.Key<String> myKeyJdkLocation;
    private final Supplier<? extends Collection<RemotePackage>> myPackagesProvider;
    private JTextPane mySummaryText;
    private JPanel myRoot;

    public InstallSummaryStep(ScopedStateStore.Key<Boolean> keyCustomInstall, ScopedStateStore.Key<String> keySdkInstallLocation, ScopedStateStore.Key<String> keyJdkLocation, Supplier<? extends Collection<RemotePackage>> packagesProvider) {
        super("Verify Settings");
        this.myKeyCustomInstall = keyCustomInstall;
        this.myKeySdkInstallLocation = keySdkInstallLocation;
        this.myKeyJdkLocation = keyJdkLocation;
        this.myPackagesProvider = packagesProvider;
        this.$$$setupUI$$$();
        this.mySummaryText.setContentType("text/html");
        this.mySummaryText.setBorder(new EmptyBorder(0, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE));
        this.mySummaryText.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                URL url;
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = event.getURL()) != null) {
                    BrowserUtil.browse((URL)url);
                }
            }
        });
        this.setComponent(this.myRoot);
    }

    private static Section getPackagesSection(@NotNull Collection<RemotePackage> remotePackages) {
        return new Section("SDK Components to Download", InstallSummaryStep.getPackagesTable(remotePackages));
    }

    @Nullable
    private static String getPackagesTable(@NotNull Collection<RemotePackage> remotePackages) {
        if (remotePackages.isEmpty()) {
            return null;
        }
        TreeSet sortedPackagesList = Sets.newTreeSet((Comparator)new PackageInfoComparator());
        sortedPackagesList.addAll(remotePackages);
        StringBuilder table2 = new StringBuilder("<table>");
        for (RemotePackage remotePkgInfo : sortedPackagesList) {
            Archive archive = remotePkgInfo.getArchive();
            assert (archive != null);
            table2.append("<tr><td>").append(remotePkgInfo.getDisplayName()).append("</td><td>&nbsp;&nbsp;</td><td>").append(WelcomeUIUtils.getSizeLabel(archive.getComplete().getSize())).append("</td></tr>");
        }
        table2.append("</table>");
        return table2.toString();
    }

    private static Section getDownloadSizeSection(@NotNull Collection<RemotePackage> remotePackages) {
        long downloadSize = 0L;
        for (RemotePackage remotePackage : remotePackages) {
            Archive archive = remotePackage.getArchive();
            assert (archive != null);
            downloadSize += archive.getComplete().getSize();
        }
        return new Section("Total Download Size", downloadSize == 0L ? "" : WelcomeUIUtils.getSizeLabel(downloadSize));
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.generateSummary();
        this.invokeUpdate(null);
    }

    @Override
    public void init() {
    }

    private void generateSummary() {
        Collection<RemotePackage> packages = this.myPackagesProvider.get();
        if (packages == null) {
            this.mySummaryText.setText("An error occurred while trying to compute required packages.");
            return;
        }
        Section[] sections = new Section[]{this.getSetupTypeSection(), this.getSdkFolderSection(), this.getJdkFolderSection(), InstallSummaryStep.getDownloadSizeSection(packages), InstallSummaryStep.getPackagesSection(packages)};
        StringBuilder builder = new StringBuilder("<html><head>");
        builder.append(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground(), null, null)).append("</head><body>");
        for (Section section : sections) {
            if (section.isEmpty()) continue;
            builder.append(section.toHtml());
        }
        builder.append("</body></html>");
        this.mySummaryText.setText(builder.toString());
    }

    @NotNull
    private Section getJdkFolderSection() {
        String title = "JDK Location";
        String jdkLocation = "";
        if (((Boolean)StudioFlags.NPW_SHOW_JDK_STEP.get()).booleanValue()) {
            jdkLocation = this.myState.get(this.myKeyJdkLocation);
        }
        if (!StringUtil.isEmptyOrSpaces((String)jdkLocation) && !IdeSdks.isSameAsJavaHomeJdk(new File(jdkLocation))) {
            jdkLocation = jdkLocation + " (<b>Note:</b> Gradle may be using JAVA_HOME when invoked from command line. <a href=\"https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:why_is_there_more_than_one_daemon_process_on_my_machine\">More info...</a>)";
        }
        return new Section(title, jdkLocation);
    }

    private Section getSdkFolderSection() {
        File location = this.getSdkDirectory();
        String text = SdkLocationUtils.isWritable(FileOpUtils.create(), location) ? location.getAbsolutePath() : location.getAbsolutePath() + " (read-only)";
        return new Section("SDK Folder", text);
    }

    private File getSdkDirectory() {
        String path = this.myState.get(this.myKeySdkInstallLocation);
        assert (path != null);
        return new File(path);
    }

    private Section getSetupTypeSection() {
        String setupType = this.myState.getNotNull(this.myKeyCustomInstall, false) != false ? "Custom" : "Standard";
        return new Section("Setup Type", setupType);
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySummaryText;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>If you want to review or change any of your installation settings, click Previous.</html>");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), new Dimension(-1, 16)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Current Settings:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.mySummaryText = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jScrollPane.setViewportView(jTextPane);
        jLabel2.setLabelFor(jTextPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static class PackageInfoComparator
    implements Comparator<RemotePackage> {
        private PackageInfoComparator() {
        }

        @Override
        public int compare(RemotePackage o1, RemotePackage o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ComparisonChain comparisonChain = ComparisonChain.start();
            return comparisonChain.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName())).result();
        }
    }

    private static final class Section {
        @NotNull
        private final String myTitle;
        @NotNull
        private final String myText;

        private Section(@NotNull String title, @Nullable String text) {
            this.myTitle = title;
            this.myText = StringUtil.notNullize((String)text);
        }

        public boolean isEmpty() {
            return StringUtil.isEmptyOrSpaces((String)this.myText);
        }

        public String toHtml() {
            return String.format("<p><strong>%1$s:</strong><br>%2$s</p>", this.myTitle, this.myText);
        }
    }
}

