/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.structure.IdeSdksConfigurable;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkSetupStep
extends FirstRunWizardStep {
    private JPanel myRootPanel;
    private ComboboxWithBrowseButton myJdkLocationComboBox;
    private HyperlinkLabel myJdkWarningLink;
    private JLabel myJdkWarningLabel;

    public JdkSetupStep() {
        super("Select default JDK Location");
        this.$$$setupUI$$$();
        this.setUpJdkLocationComboBox();
        IdeSdksConfigurable.setUpJdkWarningLabelAndLink(this.myJdkWarningLabel, this.myJdkWarningLink);
        this.setComponent(this.myRootPanel);
    }

    private void setUpJdkLocationComboBox() {
        File validatedPath;
        String javaHomePath;
        File validatedPath2;
        FileChooserDescriptor descriptor2 = JdkSetupStep.createSingleFolderDescriptor((Function<? super File, Void>)((Function)file -> {
            File validatedFile = this.validateJdkPath((File)file);
            if (validatedFile == null) {
                throw new IllegalArgumentException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
            }
            this.setJdkLocationComboBox((File)file);
            return null;
        }));
        this.myJdkLocationComboBox.addBrowseFolderListener(this.getProject(), descriptor2);
        JComboBox comboBox = this.myJdkLocationComboBox.getComboBox();
        IdeSdks ideSdks = IdeSdks.getInstance();
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        if (embeddedPath != null && (validatedPath2 = this.validateJdkPath(embeddedPath)) != null) {
            comboBox.addItem(new IdeSdksConfigurable.LabelAndFileForLocation("Embedded JDK", validatedPath2));
        }
        if ((javaHomePath = IdeSdks.getJdkFromJavaHome()) != null && (validatedPath = this.validateJdkPath(new File(javaHomePath))) != null) {
            comboBox.addItem(new IdeSdksConfigurable.LabelAndFileForLocation("JAVA_HOME", validatedPath));
        }
        comboBox.setEditable(true);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object selectedItem;
                if (event.getStateChange() == 1 && (selectedItem = event.getItem()) instanceof IdeSdksConfigurable.LabelAndFileForLocation) {
                    ApplicationManager.getApplication().invokeLater(() -> JdkSetupStep.this.setJdkLocationComboBox(((IdeSdksConfigurable.LabelAndFileForLocation)selectedItem).getFile()));
                }
            }
        });
        this.setJdkLocationComboBox(embeddedPath);
    }

    private void setJdkLocationComboBox(@Nullable File path) {
        if (path == null) {
            this.myJdkLocationComboBox.getComboBox().setSelectedItem(null);
        } else {
            this.myJdkLocationComboBox.getComboBox().setSelectedItem(FileUtilRt.toSystemDependentName((String)path.getPath()));
        }
        this.setJdkWarningVisibility();
        this.updateIsValidPath();
    }

    private void setJdkWarningVisibility() {
        boolean visible = !IdeSdks.isSameAsJavaHomeJdk(this.getJdkLocation());
        this.myJdkWarningLink.setVisible(visible);
        this.myJdkWarningLabel.setVisible(visible);
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(final @NotNull Function<? super File, Void> validation2) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files2) {
                for (VirtualFile virtualFile : files2) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation2.fun((Object)file);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor2.withShowHiddenFiles(true);
        }
        descriptor2.setTitle("Choose JDK Location");
        return descriptor2;
    }

    private void updateIsValidPath() {
        this.invokeUpdate(null);
    }

    @Nullable
    private File validateJdkPath(@NotNull File file) {
        File possiblePath = IdeSdks.getInstance().validateJdkPath(file);
        if (possiblePath != null) {
            this.setJdkLocationComboBox(possiblePath);
            return possiblePath;
        }
        return null;
    }

    @Override
    public void init() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        this.setJdkLocationComboBox(embeddedPath);
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRootPanel;
    }

    @Override
    public boolean validate() {
        if (!this.isValidJdkPath()) {
            return false;
        }
        return super.validate();
    }

    private boolean isValidJdkPath() {
        return this.validateJdkPath(this.getJdkLocation()) != null;
    }

    @Override
    public boolean commitStep() {
        if (!this.isValidJdkPath()) {
            return false;
        }
        File path = FilePaths.toSystemDependentPath((String)this.getJdkLocation().getPath());
        ApplicationManager.getApplication().runWriteAction(() -> IdeSdks.getInstance().setJdkPath(path));
        this.myState.put(WizardConstants.KEY_JDK_LOCATION, path.getPath());
        return true;
    }

    @NotNull
    private File getJdkLocation() {
        return IdeSdksConfigurable.getLocationFromComboBoxWithBrowseButton(this.myJdkLocationComboBox);
    }

    @Override
    public boolean isStepVisible() {
        return (Boolean)StudioFlags.NPW_SHOW_JDK_STEP.get() != false && Boolean.TRUE.equals(this.myState.get(FirstRunWizard.KEY_CUSTOM_INSTALL));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        HyperlinkLabel hyperlinkLabel;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Center");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Select the directory where the Java Development Kit (JDK) is located.");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myJdkLocationComboBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myJdkWarningLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkWarningLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }
}

