/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.repository.Revision;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantBundle;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantConnectionOpener;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantURLProvider;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNewAssistantBundleCreator
implements AssistantBundleCreator {
    public static final String BUNDLE_ID = "DeveloperServices.WhatsNewAssistant";
    private static final int UNKNOWN_VERSION = -1;
    private static AssistantBundleCreator ourTestCreator = null;
    private WhatsNewAssistantURLProvider myURLProvider;
    private WhatsNewAssistantConnectionOpener myConnectionOpener;
    private int myLastSeenVersion = -1;

    public WhatsNewAssistantBundleCreator() {
        this(new WhatsNewAssistantURLProvider(), new WhatsNewAssistantConnectionOpener());
    }

    public WhatsNewAssistantBundleCreator(@NotNull WhatsNewAssistantURLProvider urlProvider) {
        this(urlProvider, new WhatsNewAssistantConnectionOpener());
    }

    public WhatsNewAssistantBundleCreator(@NotNull WhatsNewAssistantURLProvider urlProvider, @NotNull WhatsNewAssistantConnectionOpener connectionOpener) {
        this.myURLProvider = urlProvider;
        this.myConnectionOpener = connectionOpener;
    }

    void setURLProvider(@NotNull WhatsNewAssistantURLProvider urlProvider) {
        this.myURLProvider = urlProvider;
    }

    @Override
    @NotNull
    public String getBundleId() {
        return BUNDLE_ID;
    }

    @Override
    @Nullable
    public WhatsNewAssistantBundle getBundle(@NotNull Project project) {
        assert (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        this.updateConfig();
        return this.parseBundle();
    }

    @Override
    @Nullable
    public URL getConfig() {
        return null;
    }

    public boolean isNewConfigVersion() {
        assert (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        WhatsNewAssistantBundle oldBundle = this.parseBundle();
        if (oldBundle != null) {
            this.myLastSeenVersion = oldBundle.getVersion();
        }
        this.updateConfig();
        WhatsNewAssistantBundle newBundle = this.parseBundle();
        return newBundle != null && (this.myLastSeenVersion == -1 || newBundle.getVersion() > this.myLastSeenVersion);
    }

    @Nullable
    private WhatsNewAssistantBundle parseBundle() {
        WhatsNewAssistantBundle bundle = this.parseBundleWorker();
        if (bundle != null) {
            return bundle;
        }
        try {
            Path path = this.myURLProvider.getLocalConfig(WhatsNewAssistantBundleCreator.getVersion());
            Files.delete(path);
        }
        catch (IOException e) {
            WhatsNewAssistantBundleCreator.getLog().warn("Error deleting cached file", (Throwable)e);
            return null;
        }
        WhatsNewAssistantBundleCreator.getLog().info("Retrying WNA parseBundle after deleting possibly corrupt file.");
        this.updateConfig();
        return this.parseBundleWorker();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private WhatsNewAssistantBundle parseBundleWorker() {
        Path path = this.myURLProvider.getLocalConfig(WhatsNewAssistantBundleCreator.getVersion());
        try (InputStream configStream = this.openConfigStream();){
            if (configStream == null) {
                WhatsNewAssistantBundle whatsNewAssistantBundle2 = null;
                return whatsNewAssistantBundle2;
            }
            WhatsNewAssistantBundle whatsNewAssistantBundle = DefaultTutorialBundle.parse(configStream, WhatsNewAssistantBundle.class);
            return whatsNewAssistantBundle;
        }
        catch (Exception e) {
            WhatsNewAssistantBundleCreator.getLog().warn(String.format("Error parsing bundle from \"%s\"", path.toString()), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private InputStream openConfigStream() throws FileNotFoundException {
        Path path = this.myURLProvider.getLocalConfig(WhatsNewAssistantBundleCreator.getVersion());
        if (Files.exists(path, new LinkOption[0])) {
            return new FileInputStream(path.toFile());
        }
        return this.myURLProvider.getResourceFileAsStream(this, WhatsNewAssistantBundleCreator.getVersion());
    }

    private void updateConfig() {
        URL webConfig = this.myURLProvider.getWebConfig(WhatsNewAssistantBundleCreator.getVersion());
        Path localConfigPath = this.myURLProvider.getLocalConfig(WhatsNewAssistantBundleCreator.getVersion());
        if (((Boolean)StudioFlags.WHATS_NEW_ASSISTANT_DOWNLOAD_CONTENT.get()).booleanValue()) {
            this.downloadConfig(webConfig, localConfigPath);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean downloadConfig(@NotNull URL sourceUrl, @NotNull Path destinationFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getVersion() {
        Revision revision = Revision.parseRevision((String)ApplicationInfo.getInstance().getStrictVersion());
        return String.format("%d.%d.%d", revision.getMajor(), revision.getMinor(), revision.getMicro());
    }

    public static boolean shouldShowWhatsNew() {
        if (!WhatsNewAssistantBundleCreator.shouldShowReleaseNotes()) {
            return false;
        }
        return WhatsNewAssistantBundleCreator.hasResourceConfig();
    }

    static boolean shouldShowReleaseNotes() {
        if (!((Boolean)StudioFlags.WHATS_NEW_ASSISTANT_ENABLED.get()).booleanValue() || !IdeInfo.getInstance().isAndroidStudio()) {
            return false;
        }
        Optional<AssistantBundleCreator> creator = WhatsNewAssistantBundleCreator.getCreator();
        return creator.isPresent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasResourceConfig() {
        try (InputStream stream = WhatsNewAssistantBundleCreator.class.getResourceAsStream("/" + WhatsNewAssistantBundleCreator.getVersion() + ".xml");){
            boolean bl = stream != null;
            return bl;
        }
        catch (IOException e) {
            WhatsNewAssistantBundleCreator.getLog().warn((Throwable)e);
            return false;
        }
    }

    public static void setTestCreator(@Nullable AssistantBundleCreator testCreator) {
        ourTestCreator = testCreator;
    }

    private static Optional<AssistantBundleCreator> getCreator() {
        if (ourTestCreator != null) {
            return Optional.of(ourTestCreator);
        }
        return Arrays.stream(AssistantBundleCreator.EP_NAME.getExtensions()).filter(extension -> extension.getBundleId().equals(BUNDLE_ID)).findFirst();
    }

    private static Logger getLog() {
        return Logger.getInstance(WhatsNewAssistantBundleCreator.class);
    }
}

