/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.repository.Revision;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantBundleCreator;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantCheckVersionTask;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantSidePanelAction;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.WhatsNewAssistantEvent;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.xmlb.annotations.Tag;
import org.apache.http.concurrent.FutureCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNewStartupActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project) {
        if (!WhatsNewAssistantBundleCreator.shouldShowWhatsNew() || !((Boolean)StudioFlags.WHATS_NEW_ASSISTANT_AUTO_SHOW.get()).booleanValue()) {
            return;
        }
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        WhatsNewService service = (WhatsNewService)ServiceManager.getService(WhatsNewService.class);
        if (service == null) {
            return;
        }
        WhatsNewData data = service.getState();
        if (GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Revision applicationRevision = Revision.parseRevision((String)ApplicationInfo.getInstance().getStrictVersion());
        if (this.isNewStudioVersion(data, applicationRevision)) {
            WhatsNewStartupActivity.hideTipsAndOpenWhatsNewAssistant(project);
        } else {
            WhatsNewAssistantCheckVersionTask task = new WhatsNewAssistantCheckVersionTask(project, new VersionCheckCallback(project));
            task.queue();
        }
    }

    private static void hideTipsAndOpenWhatsNewAssistant(@NotNull Project project) {
        WhatsNewStartupActivity.hideTipsAndOpenWhatsNewAssistant(project, null);
    }

    static void hideTipsAndOpenWhatsNewAssistant(@NotNull Project project, @Nullable FutureCallback<Boolean> callback2) {
        boolean showTipsOnStartup = GeneralSettings.getInstance().isShowTipsOnStartup();
        if (showTipsOnStartup) {
            GeneralSettings.getInstance().setShowTipsOnStartup(false);
        }
        WhatsNewStartupActivity.openWhatsNewAssistant(project);
        if (showTipsOnStartup) {
            ApplicationManager.getApplication().invokeLater(() -> {
                GeneralSettings.getInstance().setShowTipsOnStartup(true);
                if (callback2 != null) {
                    callback2.completed((Object)true);
                }
            });
        } else if (callback2 != null) {
            callback2.completed((Object)true);
        }
    }

    private static void openWhatsNewAssistant(final @NotNull Project project) {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WHATS_NEW_ASSISTANT_EVENT).setWhatsNewAssistantEvent(WhatsNewAssistantEvent.newBuilder().setType(WhatsNewAssistantEvent.WhatsNewAssistantEventType.AUTO_OPEN)));
        new WhatsNewAssistantSidePanelAction().actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)new DataContext(){

            @Nullable
            public Object getData(@NotNull String dataId) {
                if (dataId.equalsIgnoreCase(CommonDataKeys.PROJECT.getName())) {
                    return project;
                }
                return null;
            }
        }));
    }

    boolean isNewStudioVersion(@NotNull WhatsNewData data, @NotNull Revision applicationRevision) {
        String seenRevisionStr = data.myRevision;
        Revision seenRevision = null;
        if (seenRevisionStr != null) {
            try {
                seenRevision = Revision.parseRevision((String)seenRevisionStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (seenRevision == null || applicationRevision.compareTo(seenRevision, Revision.PreviewComparison.ASCENDING) > 0) {
            data.myRevision = applicationRevision.toString();
            return true;
        }
        return false;
    }

    private static class VersionCheckCallback
    implements FutureCallback<Boolean> {
        private Project myProject;

        private VersionCheckCallback(Project project) {
            this.myProject = project;
        }

        public void cancelled() {
        }

        public void completed(Boolean result2) {
            if (result2.booleanValue()) {
                WhatsNewStartupActivity.hideTipsAndOpenWhatsNewAssistant(this.myProject);
            }
        }

        public void failed(Exception ex) {
            Logger.getInstance(WhatsNewStartupActivity.class).error((Throwable)ex);
        }
    }

    public static class WhatsNewData {
        @Tag(value="shownVersion")
        public String myRevision;
    }

    @State(name="whatsNew", storages={@Storage(value="androidStudioFirstRun.xml")})
    public static class WhatsNewService
    implements PersistentStateComponent<WhatsNewData> {
        private WhatsNewData myData;

        @NotNull
        public WhatsNewData getState() {
            if (this.myData == null) {
                this.myData = new WhatsNewData();
            }
            return this.myData;
        }

        public void loadState(@NotNull WhatsNewData state) {
            this.myData = state;
        }
    }
}

