/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableOptional;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.Stack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizard
implements Disposable {
    private final List<ModelWizardStep> mySteps;
    private final Map<ModelWizardStep, ModelWizardStep> myStepOwners = new HashMap<ModelWizardStep, ModelWizardStep>();
    private final BindingsManager myBindings = new BindingsManager();
    private final BoolProperty myCanGoBack = new BoolValueProperty();
    private final BoolProperty myCanGoForward = new BoolValueProperty();
    private final BoolProperty myOnLastStep = new BoolValueProperty();
    private final OptionalProperty<Action> myExtraAction = new OptionalValueProperty<Action>();
    private final Stack<ModelWizardStep> myPrevSteps = new Stack();
    private final TitleHeader myTitleHeader = new TitleHeader();
    private final JPanel myContentPanel = new JPanel(new BorderLayout());
    private final List<WizardListener> myWizardListeners = new ArrayList<WizardListener>(1);
    @NotNull
    private BooleanSupplier myCancelInterceptor = () -> false;
    private int myCurrIndex = -1;

    /*
     * WARNING - void declaration
     */
    private ModelWizard(@NotNull Collection<ModelWizardStep> steps) {
        boolean bl;
        void var3_6;
        this.mySteps = new ArrayList<ModelWizardStep>(steps.size());
        for (ModelWizardStep modelWizardStep : steps) {
            this.addStep(modelWizardStep);
        }
        if (this.mySteps.isEmpty()) {
            throw new IllegalStateException("Can't create a wizard with no steps");
        }
        this.myCanGoForward.addListener(() -> {
            if (((Boolean)this.myCanGoForward.get()).booleanValue()) {
                this.myOnLastStep.set(this.isOnLastVisibleStep());
            }
        });
        HashSet seenModels = new HashSet();
        for (ModelWizardStep step : this.mySteps) {
            Disposer.register((Disposable)this, (Disposable)step);
            Object model2 = step.getModel();
            if (!seenModels.add(model2)) continue;
            Disposer.register((Disposable)this, model2);
        }
        boolean bl2 = false;
        while (var3_6 < this.mySteps.size()) {
            ModelWizardStep step;
            step = this.mySteps.get((int)var3_6);
            step.onWizardStarting(new Facade((int)var3_6));
            ++var3_6;
        }
        boolean bl3 = false;
        for (ModelWizardStep step : this.mySteps) {
            if (!this.shouldShowStep(step)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.myCurrIndex = 1;
            Disposer.dispose((Disposable)this);
            throw new IllegalStateException("Trying to create a wizard but no steps are visible");
        }
        this.goForward();
    }

    @NotNull
    public ObservableBool canGoBack() {
        return this.myCanGoBack;
    }

    @NotNull
    public ObservableBool canGoForward() {
        return this.myCanGoForward;
    }

    @NotNull
    public ObservableBool onLastStep() {
        return this.myOnLastStep;
    }

    @NotNull
    public TitleHeader getTitleHeader() {
        return this.myTitleHeader;
    }

    public void setCancelInterceptor(@NotNull BooleanSupplier cancelInterceptor) {
        this.myCancelInterceptor = cancelInterceptor;
    }

    @Nullable
    public JComponent getPreferredFocusComponent() {
        if (this.isFinished()) {
            return null;
        }
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        return step.getPreferredFocusComponent();
    }

    private void addStep(@NotNull ModelWizardStep<?> step) {
        this.mySteps.add(step);
        for (ModelWizardStep subStep : step.createDependentSteps()) {
            this.myStepOwners.put(subStep, step);
            this.addStep(subStep);
        }
    }

    @NotNull
    ModelWizardStep getCurrentStep() {
        return this.mySteps.get(this.myCurrIndex);
    }

    @NotNull
    ObservableOptional<Action> getExtraAction() {
        return this.myExtraAction;
    }

    @NotNull
    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    public boolean goForward() {
        this.ensureWizardIsRunning();
        ModelWizardStep prevStep = null;
        if (this.myCurrIndex >= 0) {
            ModelWizardStep currStep = this.mySteps.get(this.myCurrIndex);
            if (!((Boolean)this.myCanGoForward.get()).booleanValue()) {
                return false;
            }
            prevStep = currStep;
            try {
                prevStep.onProceeding();
            }
            catch (Exception e) {
                for (WizardListener listener2 : this.getListeners()) {
                    listener2.onWizardAdvanceError(e);
                }
                throw e;
            }
        }
        ModelWizardStep nextStep = null;
        int nextIndex = this.myCurrIndex;
        while (++nextIndex < this.mySteps.size()) {
            ModelWizardStep step = this.mySteps.get(nextIndex);
            if (!this.shouldShowStep(step)) continue;
            nextStep = step;
            break;
        }
        try {
            if (nextStep != null) {
                nextStep.onEntering();
            }
        }
        catch (Exception e) {
            for (WizardListener listener3 : this.getListeners()) {
                listener3.onWizardAdvanceError(e);
            }
            throw e;
        }
        if (prevStep != null) {
            this.myPrevSteps.add((Object)prevStep);
        }
        if (nextStep != null) {
            this.myCurrIndex = nextIndex;
            this.updateNavigationProperties();
            this.showCurrentStep();
        } else {
            this.handleFinished(WizardResult.FINISHED);
        }
        return true;
    }

    public boolean goBack() {
        this.ensureWizardIsRunning();
        if (this.myPrevSteps.empty()) {
            throw new IllegalStateException("Calling back on wizard without any previous pages");
        }
        if (!((Boolean)this.myCanGoBack.get()).booleanValue()) {
            return false;
        }
        this.myCurrIndex = this.mySteps.indexOf(this.myPrevSteps.pop());
        this.updateNavigationProperties();
        this.showCurrentStep();
        return true;
    }

    public void cancel() {
        this.ensureWizardIsRunning();
        if (!this.myCancelInterceptor.getAsBoolean()) {
            this.handleFinished(WizardResult.CANCELLED);
        }
    }

    public void addResultListener(@NotNull WizardListener listener2) {
        this.myWizardListeners.add(listener2);
    }

    public void removeResultListener(@NotNull WizardListener listener2) {
        this.myWizardListeners.remove(listener2);
    }

    public boolean isFinished() {
        return this.myCurrIndex >= this.mySteps.size();
    }

    private void ensureWizardIsRunning() {
        if (this.isFinished()) {
            throw new IllegalStateException("Invalid operation attempted after wizard already finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinished(@NotNull WizardResult result2) {
        try {
            if (result2 == WizardResult.FINISHED) {
                Object model2;
                HashSet seenModels = new HashSet();
                for (ModelWizardStep step : this.myPrevSteps) {
                    model2 = step.getModel();
                    if (!seenModels.add(model2)) continue;
                    ((WizardModel)model2).handleFinished();
                }
                for (ModelWizardStep step : this.mySteps) {
                    model2 = step.getModel();
                    if (seenModels.add(model2)) {
                        ((WizardModel)model2).handleSkipped();
                    }
                    step.onWizardFinished();
                }
            }
        }
        finally {
            this.myCurrIndex = this.mySteps.size();
            this.myPrevSteps.clear();
            this.myCanGoBack.set(false);
            this.myCanGoForward.set(false);
            this.myOnLastStep.set(false);
            for (WizardListener listener2 : this.getListeners()) {
                listener2.onWizardFinished(result2);
            }
        }
    }

    private void showCurrentStep() {
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myTitleHeader.title().set(step.getTitle());
        this.myTitleHeader.stepIcon().setNullableValue(step.getIcon());
        this.myExtraAction.setNullableValue(step.getExtraAction());
        this.myContentPanel.removeAll();
        this.myContentPanel.add(step.getComponent());
        this.myContentPanel.repaint();
        JComponent focusedComponent = step.getPreferredFocusComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
        }
    }

    private void updateNavigationProperties() {
        this.myOnLastStep.set(this.isOnLastVisibleStep());
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myCanGoBack.set(!this.myPrevSteps.empty() && step.canGoBack());
        this.myCanGoForward.set(false);
        this.myBindings.bind(this.myCanGoForward, step.canGoForward());
    }

    private boolean shouldShowStep(ModelWizardStep step) {
        ModelWizardStep currStep = step;
        do {
            if (currStep.shouldShow()) continue;
            return false;
        } while ((currStep = this.myStepOwners.get(currStep)) != null);
        return true;
    }

    private boolean isOnLastVisibleStep() {
        float size = this.mySteps.size();
        boolean currPageIsLast = true;
        int i2 = this.myCurrIndex + 1;
        while ((float)i2 < size) {
            ModelWizardStep step = this.mySteps.get(i2);
            if (this.shouldShowStep(step)) {
                currPageIsLast = false;
                break;
            }
            ++i2;
        }
        return currPageIsLast;
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myWizardListeners.clear();
    }

    private Iterable<WizardListener> getListeners() {
        return new ArrayList<WizardListener>(this.myWizardListeners);
    }

    public final class Facade {
        private final int myAllowedIndex;

        public Facade(int allowedIndex) {
            this.myAllowedIndex = allowedIndex;
        }

        public void updateNavigationProperties() {
            if (this.myAllowedIndex != ModelWizard.this.myCurrIndex) {
                return;
            }
            ModelWizard.this.updateNavigationProperties();
        }

        public boolean goForward() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to goForward before the wizard has even started");
            }
            if (this.myAllowedIndex != ModelWizard.this.myCurrIndex) {
                throw new IllegalStateException("Step which isn't active is attempting to goForward");
            }
            return ModelWizard.this.goForward();
        }

        public void cancel() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to cancel before the wizard has even started");
            }
            if (this.myAllowedIndex != ModelWizard.this.myCurrIndex) {
                throw new IllegalStateException("Step which isn't active is attempting to cancel");
            }
            ModelWizard.this.cancel();
        }
    }

    public static final class TitleHeader {
        private final StringProperty myTitle = new StringValueProperty();
        private final OptionalValueProperty<Icon> myStepIcon = new OptionalValueProperty();

        @NotNull
        public StringProperty title() {
            return this.myTitle;
        }

        @NotNull
        public OptionalValueProperty<Icon> stepIcon() {
            return this.myStepIcon;
        }
    }

    public static final class Builder {
        private final List<ModelWizardStep> mySteps;

        public Builder(ModelWizardStep ... steps) {
            this.mySteps = Lists.newArrayList((Object[])steps);
        }

        public Builder addStep(@NotNull ModelWizardStep step) {
            this.mySteps.add(step);
            return this;
        }

        public ModelWizard build() {
            return new ModelWizard(this.mySteps);
        }
    }

    public static interface WizardListener {
        default public void onWizardFinished(@NotNull WizardResult result2) {
        }

        default public void onWizardAdvanceError(@NotNull Exception e) {
        }
    }

    public static enum WizardResult {
        FINISHED,
        CANCELLED;


        public boolean isFinished() {
            return this == FINISHED;
        }
    }
}

