/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.nativeSymbolizer;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.SourceProvider;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.nativeSymbolizer.SymbolFilesLocatorKt;
import com.android.utils.FileUtils;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u00a8\u0006\u0010"}, d2={"getArchToSymDirsMap", "", "", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "getModuleSymbolsDirs", "", "module", "Lcom/intellij/openapi/module/Module;", "abi", "Lcom/android/sdklib/devices/Abi;", "isDebugVariant", "", "Lcom/android/tools/idea/gradle/project/model/NdkVariant;", "native-symbolizer"})
public final class SymbolFilesLocatorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Set<File>> getArchToSymDirsMap(@NotNull Project project) {
        Map result2 = new HashMap();
        Function1 symbolDirFilter2 = getArchToSymDirsMap.symbolDirFilter.1.INSTANCE;
        List allSupportedAbis = CollectionsKt.listOf((Object[])new Abi[]{Abi.X86, Abi.X86_64, Abi.ARM64_V8A, Abi.ARMEABI, Abi.ARMEABI_V7A});
        for (Abi abi : allSupportedAbis) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)SymbolFilesLocatorKt.getModuleSymbolsDirs(module, abi);
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!((Boolean)symbolDirFilter2.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List symDirs = (List)destination$iv$iv;
                Set existingDirs2 = (Set)result2.computeIfAbsent(abi.getCpuArch(), getArchToSymDirsMap.existingDirs.1.INSTANCE);
                existingDirs2.addAll(symDirs);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<File> getModuleSymbolsDirs(Module module, Abi abi) {
        AndroidModuleModel androidModel;
        Iterable dirs;
        Object destination$iv$iv;
        Iterable $receiver$iv;
        Object it;
        Iterable $receiver$iv$iv;
        Iterable destination$iv$iv2;
        Iterable $receiver$iv2;
        NdkModuleModel ndkModuleModel;
        File file;
        Object object;
        Object object2;
        LinkedHashSet symDirs = Sets.newLinkedHashSet();
        String abiName = abi.toString();
        ApkFacet apkFacet = ApkFacet.getInstance(module);
        if (apkFacet != null) {
            Iterator $receiver$iv$iv2;
            void $receiver$iv3;
            Iterable iterable = ((ApkFacetConfiguration)apkFacet.getConfiguration()).getDebugSymbolFolderPaths(CollectionsKt.listOf((Object)abi));
            void var7_6 = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            object2 = $receiver$iv$iv2.iterator();
            while (object2.hasNext()) {
                Iterator it2;
                Object item$iv$iv = object2.next();
                String string = (String)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                file = new File(FileUtils.toSystemDependentPath(it2));
                object.add(file);
            }
            List dirs2 = (List)destination$iv$iv3;
            symDirs.addAll(dirs2);
        }
        if ((ndkModuleModel = NdkModuleModel.get(module)) != null) {
            $receiver$iv2 = ndkModuleModel.getVariants();
            object2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (NdkVariant)element$iv$iv;
                boolean bl = false;
                if (!(SymbolFilesLocatorKt.isDebugVariant((NdkVariant)it) == SymbolFilesLocatorKt.isDebugVariant(ndkModuleModel.getSelectedVariant()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (NdkVariant variant : (List)destination$iv$iv2) {
                Iterable $receiver$iv$iv3;
                $receiver$iv$iv = variant.getArtifacts();
                destination$iv$iv2 = $receiver$iv;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv3) {
                    NativeArtifact it3 = (NativeArtifact)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it3.getAbi(), (Object)abiName)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv3 = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv3) {
                    NativeArtifact it3 = (NativeArtifact)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    file = it3.getOutputFile().getParentFile();
                    object.add(file);
                }
                dirs = (List)destination$iv$iv;
                symDirs.addAll((Collection)dirs);
            }
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            Iterable $receiver$iv$iv4;
            Iterable nativeLibraries;
            dirs = androidModel.getActiveSourceProviders();
            $receiver$iv = $receiver$iv2;
            destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (SourceProvider)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getJniLibsDirectories();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void jniDir;
                it = (File)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                file = new File((File)jniDir, abiName);
                object.add(file);
            }
            List jniDirs = (List)destination$iv$iv2;
            symDirs.addAll(jniDirs);
            $receiver$iv$iv = androidModel.getSelectedVariant().getMainArtifact().getNativeLibraries();
            Iterable iterable = $receiver$iv$iv;
            if (iterable == null) {
                iterable = CollectionsKt.emptyList();
            }
            Iterable $receiver$iv4 = nativeLibraries = iterable;
            destination$iv$iv = $receiver$iv4;
            Collection destination$iv$iv4 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv4) {
                NativeLibrary it4 = (NativeLibrary)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it4.getAbi(), (Object)abiName)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $receiver$iv4 = (List)destination$iv$iv4;
            $receiver$iv$iv4 = $receiver$iv4;
            destination$iv$iv4 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv4) {
                NativeLibrary it5 = (NativeLibrary)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it5.getDebuggableLibraryFolders();
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            List nativeLibDirs = (List)destination$iv$iv4;
            symDirs.addAll(nativeLibDirs);
        }
        return symDirs;
    }

    public static final boolean isDebugVariant(@NotNull NdkVariant $receiver) {
        return StringsKt.contains$default((CharSequence)$receiver.getName(), (CharSequence)"debug", (boolean)false, (int)2, null);
    }
}

