/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.model;

import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\"\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011J\b\u0010$\u001a\u00020\u0013H\u0002J\b\u0010%\u001a\u00020\u0013H\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "", "()V", "value", "", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "lines", "", "Lcom/android/tools/property/panel/api/InspectorLineModel;", "lines$annotations", "getLines", "()Ljava/util/List;", "listeners", "Lcom/android/tools/adtui/model/stdui/ValueChangedListener;", "add", "", "line", "addValueChangedListener", "listener", "applyFilter", "applyFilterToTable", "Lcom/android/tools/property/panel/api/TableLineModel;", "clear", "enterInFilter", "", "findClosestNextLine", "lineIndex", "", "fireValueChanged", "moveToNextLineEditor", "propertyValuesChanged", "removeValueChangedListener", "restoreGroups", "updateFiltering", "intellij.android.property-editor"})
public final class InspectorPanelModel {
    private List<ValueChangedListener> listeners;
    @NotNull
    private final List<InspectorLineModel> lines;
    @NotNull
    private String filter;

    @VisibleForTesting
    public static /* synthetic */ void lines$annotations() {
    }

    @NotNull
    public final List<InspectorLineModel> getLines() {
        return this.lines;
    }

    @NotNull
    public final String getFilter() {
        return this.filter;
    }

    public final void setFilter(@NotNull String value2) {
        this.filter = value2;
        this.updateFiltering();
    }

    public final void clear() {
        this.lines.clear();
    }

    public final void moveToNextLineEditor(@NotNull InspectorLineModel line) {
        int index = this.lines.indexOf(line);
        if (index < 0) {
            return;
        }
        InspectorLineModel inspectorLineModel = this.findClosestNextLine(index);
        if (inspectorLineModel == null) {
            return;
        }
        InspectorLineModel nextLine = inspectorLineModel;
        nextLine.requestFocus();
    }

    private final InspectorLineModel findClosestNextLine(int lineIndex) {
        int index = (lineIndex + 1) % this.lines.size();
        while (index != lineIndex) {
            InspectorLineModel line = this.lines.get(index);
            if (line.getVisible() && line.getFocusable()) {
                return line;
            }
            index = (index + 1) % this.lines.size();
        }
        return null;
    }

    public final void propertyValuesChanged() {
        Iterable $receiver$iv = this.lines;
        for (Object element$iv : $receiver$iv) {
            InspectorLineModel it = (InspectorLineModel)element$iv;
            boolean bl = false;
            it.refresh();
        }
    }

    public final void add(@NotNull InspectorLineModel line) {
        this.lines.add(line);
    }

    public final void addValueChangedListener(@NotNull ValueChangedListener listener2) {
        this.listeners.add(listener2);
    }

    public final void removeValueChangedListener(@NotNull ValueChangedListener listener2) {
        this.listeners.add(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterInFilter() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        CharSequence charSequence = this.filter;
        if (charSequence.length() == 0) {
            return false;
        }
        Iterable iterable = $receiver$iv = (Iterable)this.lines;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            InspectorLineModel it = (InspectorLineModel)element$iv$iv;
            boolean bl = false;
            if (!(it.getVisible() && (it instanceof CollapsibleLabelModel || it instanceof TableLineModel))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List visibleLabels = (List)destination$iv$iv;
        $receiver$iv = visibleLabels;
        if ($receiver$iv.size() != 1) {
            return false;
        }
        InspectorLineModel label = (InspectorLineModel)visibleLabels.get(0);
        if (label instanceof CollapsibleLabelModel) {
            PropertyEditorModel propertyEditorModel = ((CollapsibleLabelModel)label).getEditorModel();
            if (propertyEditorModel == null) {
                return false;
            }
            PropertyEditorModel editor2 = propertyEditorModel;
            editor2.requestFocus();
            return true;
        }
        if (label instanceof TableLineModel) {
            ((TableLineModel)label).requestFocusInBestMatch();
            return true;
        }
        return false;
    }

    private final void updateFiltering() {
        CharSequence charSequence = this.filter;
        if (charSequence.length() > 0) {
            this.applyFilter();
        } else {
            this.restoreGroups();
        }
        this.fireValueChanged();
    }

    private final void applyFilter() {
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)('*' + this.filter)).build();
        Iterable $receiver$iv = this.lines;
        for (Object element$iv : $receiver$iv) {
            InspectorLineModel line = (InspectorLineModel)element$iv;
            boolean bl = false;
            if (!line.isSearchable()) {
                line.setVisible(false);
                continue;
            }
            if (line instanceof CollapsibleLabelModel) {
                ((CollapsibleLabelModel)line).hideForSearch(line.isMatch((Matcher)matcher));
                continue;
            }
            if (line instanceof TableLineModel) {
                this.applyFilterToTable((TableLineModel)line);
                continue;
            }
            line.setVisible(line.isMatch((Matcher)matcher));
        }
    }

    private final void applyFilterToTable(TableLineModel line) {
        line.setFilter(this.filter);
        line.setVisible(line.getItemCount() > 0);
    }

    private final void restoreGroups() {
        Iterable $receiver$iv = CollectionsKt.reversed((Iterable)this.lines);
        for (Object element$iv : $receiver$iv) {
            InspectorLineModel line = (InspectorLineModel)element$iv;
            boolean bl = false;
            if (line instanceof CollapsibleLabelModel) {
                ((CollapsibleLabelModel)line).restoreAfterSearch();
                continue;
            }
            if (line.isSearchable()) {
                line.setFilter("");
                continue;
            }
            line.setVisible(true);
        }
    }

    private final void fireValueChanged() {
        ValueChangedListener[] $receiver$iv = (ValueChangedListener[])this.listeners;
        if ($receiver$iv == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        ValueChangedListener[] thisCollection$iv = $receiver$iv;
        ValueChangedListener[] valueChangedListenerArray = thisCollection$iv.toArray(new ValueChangedListener[0]);
        if (valueChangedListenerArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $receiver$iv = valueChangedListenerArray;
        ValueChangedListener[] valueChangedListenerArray2 = $receiver$iv;
        int n = valueChangedListenerArray2.length;
        for (int j = 0; j < n; ++j) {
            ValueChangedListener element$iv;
            ValueChangedListener it = element$iv = valueChangedListenerArray2[j];
            boolean bl = false;
            it.valueChanged();
        }
    }

    public InspectorPanelModel() {
        List list;
        InspectorPanelModel inspectorPanelModel = this;
        inspectorPanelModel.listeners = list = (List)new ArrayList();
        inspectorPanelModel = this;
        inspectorPanelModel.lines = list = (List)new ArrayList();
        this.filter = "";
    }
}

