/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.tools.property.panel.impl.model.TableEditingRequest;
import com.android.tools.property.panel.impl.model.TableLineModelImpl;
import com.android.tools.property.panel.impl.model.TableRowEditListener;
import com.android.tools.property.panel.impl.model.TextFieldPropertyEditorModel;
import com.android.tools.property.panel.impl.support.HelpSupportBinding;
import com.android.tools.property.panel.impl.ui.PropertyTextField;
import com.android.tools.property.panel.impl.ui.TableEditor$WhenMappings;
import com.android.tools.property.ptable2.PTable;
import com.android.tools.property.ptable2.PTableCellEditorProvider;
import com.android.tools.property.ptable2.PTableCellRendererProvider;
import com.android.tools.property.ptable2.PTableColumn;
import com.android.tools.property.ptable2.PTableGroupItem;
import com.android.tools.property.ptable2.PTableItem;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\b\u0010'\u001a\u00020\u001cH\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/property/panel/impl/ui/TableEditor;", "", "lineModel", "Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "rendererProvider", "Lcom/android/tools/property/ptable2/PTableCellRendererProvider;", "editorProvider", "Lcom/android/tools/property/ptable2/PTableCellEditorProvider;", "(Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;Lcom/android/tools/property/ptable2/PTableCellRendererProvider;Lcom/android/tools/property/ptable2/PTableCellEditorProvider;)V", "component", "Ljavax/swing/JTable;", "getComponent", "()Ljavax/swing/JTable;", "getLineModel", "()Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "table", "Lcom/android/tools/property/ptable2/PTable;", "computeRowHeight", "", "findRowOf", "itemToEdit", "Lcom/android/tools/property/ptable2/PTableItem;", "findRowOfBestMatch", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "handleEditRequest", "", "request", "Lcom/android/tools/property/panel/impl/model/TableEditingRequest;", "item", "handleValueChanged", "isBetter", "", "best", "isMatch", "matcher", "Lcom/intellij/util/text/Matcher;", "updateUI", "intellij.android.property-editor"})
public final class TableEditor {
    private final PTable table;
    @NotNull
    private final JTable component;
    @NotNull
    private final TableLineModelImpl lineModel;

    @NotNull
    public final JTable getComponent() {
        return this.component;
    }

    private final void updateUI() {
        this.component.setRowHeight(this.computeRowHeight());
    }

    private final void handleValueChanged() {
        this.component.setVisible(this.lineModel.getVisible());
        this.table.setFilter(this.lineModel.getFilter());
        this.lineModel.setItemCount(this.table.getItemCount());
    }

    private final void handleEditRequest(TableEditingRequest request, PTableItem item) {
        this.handleValueChanged();
        switch (TableEditor$WhenMappings.$EnumSwitchMapping$0[request.ordinal()]) {
            case 1: {
                this.table.startEditing(this.findRowOf(item));
                break;
            }
            case 2: {
                this.table.startEditing(-1);
                break;
            }
            case 3: {
                this.table.startEditing(this.findRowOfBestMatch());
            }
        }
    }

    private final String getToolTipText(MouseEvent event) {
        JComponent control;
        int tableRow = this.component.rowAtPoint(event.getPoint());
        int tableColumn = this.component.columnAtPoint(event.getPoint());
        if (tableRow < 0 || tableColumn < 0) {
            return null;
        }
        Object item = this.component.getValueAt(tableRow, tableColumn);
        TableCellRenderer renderer = this.component.getCellRenderer(tableRow, tableColumn);
        Component component = renderer.getTableCellRendererComponent(this.component, item, false, false, tableRow, tableColumn);
        if (component == null) {
            return null;
        }
        Component cell = component;
        Rectangle rect = this.component.getCellRect(tableRow, tableColumn, true);
        cell.setBounds(0, 0, rect.width, rect.height);
        Component component2 = SwingUtilities.getDeepestComponentAt(cell, event.getX() - rect.x, event.getY() - rect.y);
        if (!(component2 instanceof JComponent)) {
            component2 = null;
        }
        JComponent jComponent = control = (JComponent)component2;
        return jComponent != null ? jComponent.getToolTipText(event) : null;
    }

    private final int computeRowHeight() {
        Object v1;
        Object v0;
        block3: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.lineModel.getTableModel().getItems();
            for (Object t : iterable2) {
                PTableItem it = (PTableItem)t;
                boolean bl = false;
                if (!(it instanceof PropertyItem)) continue;
                v0 = t;
                break block3;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof PropertyItem)) {
            v1 = null;
        }
        PropertyItem propertyItem = v1;
        if (propertyItem == null) {
            return JBUI.scale((int)24);
        }
        PropertyItem property2 = propertyItem;
        PropertyTextField textField2 = new PropertyTextField(new TextFieldPropertyEditorModel(property2, true));
        return Integer.max(textField2.getPreferredSize().height, JBUI.scale((int)20));
    }

    /*
     * WARNING - void declaration
     */
    private final int findRowOf(PTableItem itemToEdit) {
        int count = this.table.getItemCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            PTableItem item = this.table.item((int)i2);
            if (Intrinsics.areEqual((Object)item, (Object)itemToEdit)) {
                return (int)i2;
            }
            ++i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final int findRowOfBestMatch() {
        CharSequence charSequence = this.lineModel.getFilter();
        if (charSequence.length() == 0) {
            return -1;
        }
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)('*' + this.lineModel.getFilter())).build();
        int count = this.table.getItemCount();
        PTableItem best = null;
        int bestRow = -1;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void row;
            PTableItem item = this.table.item((int)row);
            if (this.isMatch((Matcher)matcher, item) && this.isBetter(item, best)) {
                best = item;
                bestRow = row;
            }
            ++row;
        }
        return bestRow;
    }

    private final boolean isMatch(Matcher matcher, PTableItem item) {
        PTableItem pTableItem = item;
        return pTableItem instanceof PTableGroupItem ? matcher.matches(item.getName()) : true;
    }

    private final boolean isBetter(PTableItem item, PTableItem best) {
        return !this.lineModel.getTableModel().isCellEditable(item, PTableColumn.VALUE) ? false : (best == null ? true : item.getName().length() < best.getName().length());
    }

    @NotNull
    public final TableLineModelImpl getLineModel() {
        return this.lineModel;
    }

    public TableEditor(@NotNull TableLineModelImpl lineModel, @NotNull PTableCellRendererProvider rendererProvider, @NotNull PTableCellEditorProvider editorProvider) {
        this.lineModel = lineModel;
        this.table = PTable.Companion.create(this.lineModel.getTableModel(), this.lineModel, rendererProvider, editorProvider, (Function1<? super MouseEvent, String>)((Function1)new Function1<MouseEvent, String>(this){
            final /* synthetic */ TableEditor this$0;

            @Nullable
            public final String invoke(@NotNull MouseEvent it) {
                return TableEditor.access$getToolTipText(this.this$0, it);
            }
            {
                this.this$0 = tableEditor;
                super(1);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                TableEditor.access$updateUI((TableEditor)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(TableEditor.class);
            }

            public final String getName() {
                return "updateUI";
            }

            public final String getSignature() {
                return "updateUI()V";
            }
        }));
        JComponent jComponent = this.table.getComponent();
        if (jComponent == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.JTable");
        }
        this.component = (JTable)jComponent;
        this.component.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.component.setRowHeight(this.computeRowHeight());
        this.lineModel.addValueChangedListener(new TableRowEditListener(){

            public void valueChanged() {
                this.handleValueChanged();
            }

            @Override
            public void editRequest(@NotNull TableEditingRequest type, @Nullable PTableItem item) {
                this.handleEditRequest(type, item);
            }
        });
        this.component.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                PTableItem pTableItem;
                int index = this.getComponent().getSelectedRow();
                if (index >= 0 && index < this.getComponent().getRowCount()) {
                    Object object = this.getComponent().getValueAt(index, 1);
                    if (!(object instanceof PTableItem)) {
                        object = null;
                    }
                    pTableItem = (PTableItem)object;
                } else {
                    pTableItem = null;
                }
                PTableItem item = pTableItem;
                this.getLineModel().setSelectedItem(item);
            }
        });
        HelpSupportBinding.registerHelpKeyActions$default(HelpSupportBinding.INSTANCE, this.component, (Function0)new Function0<PropertyItem>(){

            @Nullable
            public final PropertyItem invoke() {
                PTableItem pTableItem = this.getLineModel().getSelectedItem();
                if (!(pTableItem instanceof PropertyItem)) {
                    pTableItem = null;
                }
                return (PropertyItem)pTableItem;
            }
        }, 0, 4, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, (Function0)4.INSTANCE, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_UP(), (String)"pageUp", (Function0)5.INSTANCE, (int)0, (int)16, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, (Function0)6.INSTANCE, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_DOWN(), (String)"pageDown", (Function0)7.INSTANCE, (int)0, (int)16, null);
    }

    public static final /* synthetic */ String access$getToolTipText(TableEditor $this, MouseEvent event) {
        return $this.getToolTipText(event);
    }

    public static final /* synthetic */ void access$updateUI(TableEditor $this) {
        $this.updateUI();
    }
}

