/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.ptable;

import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.StarState;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.DataContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PTableGroupItem
extends PTableItem {
    private List<PTableItem> myItems;
    private boolean myExpanded;

    public void setChildren(@NotNull List<PTableItem> items2) {
        this.myItems = items2;
        for (PTableItem item : items2) {
            item.setParent(this);
        }
    }

    public void addChild(@NotNull PTableItem item) {
        this.addChild(item, null);
    }

    public void addChild(@NotNull PTableItem item, @Nullable PTableItem after) {
        int index;
        item.setParent(this);
        if (this.myItems == null) {
            this.myItems = Lists.newArrayList();
        }
        int n = index = after != null ? this.myItems.indexOf(after) : -1;
        if (index != -1) {
            this.myItems.add(index + 1, item);
        } else {
            this.myItems.add(item);
        }
    }

    public void deleteChild(@NotNull PTableItem item) {
        assert (this == item.getParent());
        item.setParent(null);
        this.myItems.remove(item);
    }

    @Override
    public List<PTableItem> getChildren() {
        return this.myItems == null ? Collections.emptyList() : this.myItems;
    }

    @Nullable
    public PTableItem getItemByName(@NotNull String propertyName) {
        for (PTableItem item : this.myItems) {
            if (!item.getName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.myItems != null && !this.myItems.isEmpty();
    }

    @Override
    public boolean isExpanded() {
        return this.myExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    @Override
    @NotNull
    public StarState getStarState() {
        return StarState.NOT_STAR_ABLE;
    }

    @Override
    public void setStarState(@NotNull StarState starState) {
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    public String getValue() {
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        throw new IllegalStateException();
    }

    @Override
    public boolean isDefaultValue(@Nullable String value2) {
        throw new IllegalStateException();
    }

    @Override
    public void setValue(@Nullable Object value2) {
        throw new IllegalStateException();
    }

    public void deleteGroupValues(DataContext context) {
        throw new IllegalStateException();
    }
}

