/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.adtui.LightCalloutPopup;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerBuilder;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.internal.MaterialColorPaletteProvider;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.internal.MaterialGraphicalColorPipetteProvider;
import com.android.utils.HashCodes;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.MouseInfo;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;

public class AndroidAnnotatorUtil {
    static final int MAX_ICON_SIZE = 5000;
    private static final String SET_COLOR_COMMAND_NAME = "Change Color";
    private static final int ICON_SIZE = 8;

    @Nullable
    public static VirtualFile resolveDrawableFile(@NotNull ResourceValue resourceValue2, @NotNull ResourceResolver resourceResolver, @NotNull AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        VirtualFile file = ResourceHelper.resolveDrawable((RenderResources)resourceResolver, resourceValue2, project);
        if (file != null && file.getPath().endsWith(".xml")) {
            file = AndroidAnnotatorUtil.pickBitmapFromXml(file, resourceResolver, project, facet, resourceValue2);
        }
        return AndroidAnnotatorUtil.pickBestBitmap(file);
    }

    @Nullable
    private static VirtualFile pickBitmapFromXml(@NotNull VirtualFile file, @NotNull ResourceResolver resourceResolver, @NotNull Project project, @NotNull AndroidFacet facet, @NotNull ResourceValue resourceValue2) {
        try {
            String source;
            String tagName;
            XmlPullParser parser = FileResourceReader.createXmlPullParser(file);
            if (parser == null) {
                return null;
            }
            if (parser.nextTag() != 2) {
                return null;
            }
            switch (tagName = parser.getName()) {
                case "vector": {
                    LocalResourceRepository resourceRepository = ResourceRepositoryManager.getAppResources(facet);
                    List<ResourceItem> items2 = resourceRepository.getResources(resourceValue2.getNamespace(), resourceValue2.getResourceType(), resourceValue2.getName());
                    for (ResourceItem item : items2) {
                        Density density;
                        FolderConfiguration configuration = item.getConfiguration();
                        DensityQualifier densityQualifier = configuration.getDensityQualifier();
                        if (densityQualifier == null || (density = densityQualifier.getValue()) == null || !density.isValidValueForDevice()) continue;
                        return ResourceHelper.getSourceAsVirtualFile(item);
                    }
                    return file;
                }
                case "bitmap": 
                case "nine-patch": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "src");
                    break;
                }
                case "clip": 
                case "inset": 
                case "scale": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable");
                    break;
                }
                case "layer-list": 
                case "level-list": 
                case "selector": 
                case "shape": 
                case "transition": {
                    return file;
                }
                default: {
                    return null;
                }
            }
            if (source == null) {
                return null;
            }
            ResourceValue resValue = resourceResolver.findResValue(source, resourceValue2.isFramework());
            return resValue == null ? null : ResourceHelper.resolveDrawable((RenderResources)resourceResolver, resValue, project);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile pickBestBitmap(@Nullable VirtualFile bitmap) {
        if (bitmap != null && bitmap.exists()) {
            VirtualFile smallest = AndroidAnnotatorUtil.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.getLength();
            if (length < 5000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findSmallestDpiVersion(@NotNull VirtualFile bitmap) {
        VirtualFile parentFile = bitmap.getParent();
        if (parentFile == null) {
            return null;
        }
        VirtualFile resFolder = parentFile.getParent();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            int i2 = densities.length;
            while (--i2 >= 0) {
                String folderName;
                VirtualFile folder;
                Density d = densities[i2];
                if (!d.isValidValueForDevice() || (folder = resFolder.findChild(folderName = parentName.replace(density.getResourceValue(), d.getResourceValue()))) == null || (bitmap = folder.findChild(fileName)) == null) continue;
                if (bitmap.getLength() > 5000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    public static ResourceValue findResourceValue(@NotNull ResourceType type, @NotNull String name, boolean isFramework, @NotNull Module module, @NotNull Configuration configuration) {
        if (isFramework) {
            ResourceRepository frameworkResources = configuration.getFrameworkResources();
            if (frameworkResources == null) {
                return null;
            }
            List items2 = frameworkResources.getResources(ResourceNamespace.ANDROID, type, name);
            if (items2.isEmpty()) {
                return null;
            }
            return ((ResourceItem)items2.get(0)).getResourceValue();
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(module);
        if (appResources == null) {
            return null;
        }
        if (!appResources.hasResources(ResourceNamespace.TODO(), type, name)) {
            return null;
        }
        return ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)appResources, (ResourceType)type, (String)name, (FolderConfiguration)configuration.getFullConfig());
    }

    @Nullable
    public static Configuration pickConfiguration(@NotNull PsiFile file, @NotNull AndroidFacet facet) {
        VirtualFile layout2;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return null;
        }
        String parentName = parent.getName();
        if (!parentName.startsWith("layout")) {
            layout2 = ResourceHelper.pickAnyLayoutFile(facet);
            if (layout2 == null) {
                return null;
            }
        } else {
            layout2 = virtualFile;
        }
        return ConfigurationManager.getOrCreateInstance(facet.getModule()).getConfiguration(layout2);
    }

    public static class ColorRenderer
    extends GutterIconRenderer {
        private final PsiElement myElement;
        private final Color myColor;
        private final Consumer<Color> mySetColorTask;
        private final boolean myIncludeClickAction;

        public ColorRenderer(@NotNull PsiElement element, @Nullable Color color, boolean includeClickAction) {
            this.myElement = element;
            this.myColor = color;
            this.myIncludeClickAction = includeClickAction;
            this.mySetColorTask = ColorRenderer.createSetColorTask(this.myElement);
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getCurrentColor();
            return color == null ? JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)8)) : JBUI.scale((JBUI.JBIcon)new ColorIcon(8, color));
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return ResourceHelper.parseColor(((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return ResourceHelper.parseColor(((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if (!this.myIncludeClickAction) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor2 != null) {
                        if (((Boolean)StudioFlags.NELE_NEW_COLOR_PICKER.get()).booleanValue()) {
                            this.openNewColorPicker(this.getCurrentColor());
                        } else {
                            Color color = ColorPicker.showDialog(editor2.getComponent(), "Choose Color", this.getCurrentColor(), true, null, false);
                            if (color != null) {
                                this.setColorToAttribute(color);
                            }
                        }
                    }
                }
            };
        }

        private void openNewColorPicker(@Nullable Color currentColor) {
            LightCalloutPopup dialog2 = new LightCalloutPopup();
            JPanel panel2 = new ColorPickerBuilder().setOriginalColor(currentColor).addSaturationBrightnessComponent().addColorAdjustPanel(new MaterialGraphicalColorPipetteProvider()).addColorValuePanel().withFocus().addSeparator().addCustomComponent(MaterialColorPaletteProvider.INSTANCE).addColorPickerListener((color, source) -> this.setColorToAttribute(color)).focusWhenDisplay(true).setFocusCycleRoot(true).build();
            dialog2.show((JComponent)panel2, null, MouseInfo.getPointerInfo().getLocation());
        }

        private void setColorToAttribute(@NotNull Color color) {
            Project project = this.myElement.getProject();
            TransactionGuard.submitTransaction((Disposable)project, () -> WriteCommandAction.runWriteCommandAction((Project)project, (String)AndroidAnnotatorUtil.SET_COLOR_COMMAND_NAME, null, () -> this.mySetColorTask.consume((Object)color), (PsiFile[])new PsiFile[0]));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorRenderer that = (ColorRenderer)((Object)o);
            if (!Objects.equals(this.myColor, that.myColor)) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return HashCodes.mix((int)this.myElement.hashCode(), (int)Objects.hashCode(this.myColor));
        }

        @VisibleForTesting
        public static Consumer<Color> createSetColorTask(@NotNull PsiElement element) {
            XmlAttribute xmlAttribute;
            if (element instanceof XmlTag) {
                XmlTagValue xmlTagValue = ((XmlTag)element).getValue();
                return color -> xmlTagValue.setText(ResourceHelper.colorToString(color));
            }
            if (element instanceof XmlAttributeValue && (xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null) {
                return color -> xmlAttribute.setValue(ResourceHelper.colorToString(color));
            }
            return EmptyConsumer.getInstance();
        }
    }
}

