/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.awt.Color;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        ResourceType type;
        AndroidPsiUtils.ResourceReferenceType referenceType;
        if (((Boolean)StudioFlags.GUTTER_ICON_ANNOTATOR_IN_BACKGROUND_ENABLED.get()).booleanValue()) {
            return;
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String tagName = tag.getName();
            if (ResourceType.COLOR.getName().equals(tagName) || ResourceType.DRAWABLE.getName().equals(tagName) || ResourceType.MIPMAP.getName().equals(tagName)) {
                DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag);
                if (domElement instanceof ResourceElement || ApplicationManager.getApplication().isUnitTestMode()) {
                    String value2 = tag.getValue().getText().trim();
                    AndroidColorAnnotator.annotateXml(element, holder, value2);
                }
            } else if ("item".equals(tagName)) {
                XmlTagValue value3 = tag.getValue();
                String text = value3.getText();
                AndroidColorAnnotator.annotateXml(element, holder, text);
            }
        } else if (element instanceof XmlAttributeValue) {
            XmlAttributeValue v = (XmlAttributeValue)element;
            String value4 = v.getValue();
            if (value4.isEmpty()) {
                return;
            }
            AndroidColorAnnotator.annotateXml(element, holder, value4);
        } else if (element instanceof PsiReferenceExpression && (referenceType = AndroidPsiUtils.getResourceReferenceType(element)) != AndroidPsiUtils.ResourceReferenceType.NONE && ((type = AndroidPsiUtils.getResourceType(element)) == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP)) {
            String name = AndroidPsiUtils.getResourceName(element);
            AndroidColorAnnotator.annotateResourceReference(type, holder, element, name, referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK);
        }
    }

    private static void annotateXml(@NotNull PsiElement element, @NotNull AnnotationHolder holder, @NotNull String value2) {
        if (value2.startsWith("#")) {
            PsiFile file = element.getContainingFile();
            if (file != null && AndroidResourceUtil.isInResourceSubdirectory(file, null)) {
                if (element instanceof XmlTag) {
                    Annotation annotation = holder.createInfoAnnotation(element, null);
                    annotation.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, null, true));
                } else {
                    assert (element instanceof XmlAttributeValue);
                    Color color = ResourceHelper.parseColor(value2);
                    if (color != null) {
                        Annotation annotation = holder.createInfoAnnotation(element, null);
                        annotation.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, null, true));
                    }
                }
            }
        } else if (value2.startsWith("@color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value2.substring("@color/".length()), false);
        } else if (value2.startsWith("@android:color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value2.substring("@android:color/".length()), true);
        } else if (value2.startsWith("@drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value2.substring("@drawable/".length()), false);
        } else if (value2.startsWith("@android:drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value2.substring("@android:drawable/".length()), true);
        } else if (value2.startsWith("@mipmap/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.MIPMAP, holder, element, value2.substring("@mipmap/".length()), false);
        }
    }

    private static void annotateResourceReference(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String name, boolean isFramework) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFile.class);
        if (file == null) {
            return;
        }
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration(file, facet);
        if (configuration == null) {
            return;
        }
        ResourceValue value2 = AndroidAnnotatorUtil.findResourceValue(type, name, isFramework, module, configuration);
        if (value2 != null) {
            AndroidColorAnnotator.annotateResourceValue(type, holder, element, value2, facet, configuration);
        }
    }

    private static void annotateResourceValue(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull ResourceValue value2, @NotNull AndroidFacet facet, @NotNull Configuration configuration) {
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        Project project = element.getProject();
        if (type == ResourceType.COLOR) {
            Color color = ResourceHelper.resolveColor((RenderResources)resourceResolver, value2, project);
            if (color != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, color, false));
            }
        } else {
            assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP);
            VirtualFile iconFile = AndroidAnnotatorUtil.resolveDrawableFile(value2, resourceResolver, facet);
            if (iconFile != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver, facet, iconFile, configuration));
            }
        }
    }
}

