/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidComponentSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    private final JavaSafeDeleteProcessor myBaseHandler = new JavaSafeDeleteProcessor();

    private JavaSafeDeleteProcessor getBaseHandler() {
        return this.myBaseHandler;
    }

    public boolean handlesElement(PsiElement element) {
        return this.getBaseHandler().handlesElement(element) && element instanceof PsiClass && AndroidFacet.getInstance(element) != null && AndroidUtils.isAndroidComponent((PsiClass)element);
    }

    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> result2) {
        ArrayList usages = new ArrayList();
        NonCodeUsageSearchInfo info = this.getBaseHandler().findUsages(element, allElementsToDelete, usages);
        if (info == null) {
            return info;
        }
        assert (element instanceof PsiClass);
        PsiClass componentClass = (PsiClass)element;
        AndroidAttributeValue<PsiClass> declaration = AndroidDomUtil.findComponentDeclarationInManifest(componentClass);
        if (declaration == null) {
            return info;
        }
        XmlAttributeValue declarationAttributeValue = declaration.getXmlAttributeValue();
        for (UsageInfo usage : usages) {
            if (declarationAttributeValue == usage.getElement()) continue;
            result2.add(usage);
        }
        return info;
    }

    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<PsiElement> allElementsToDelete) {
        return this.getBaseHandler().getElementsToSearch(element, module, allElementsToDelete);
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        return this.getBaseHandler().getAdditionalElementsToDelete(element, allElementsToDelete, askUser);
    }

    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        return this.getBaseHandler().findConflicts(element, allElementsToDelete);
    }

    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
        XmlTag declarationTag;
        XmlAttribute declarationAttr;
        assert (element instanceof PsiClass);
        AndroidAttributeValue<PsiClass> declaration = AndroidDomUtil.findComponentDeclarationInManifest((PsiClass)element);
        if (declaration != null && (declarationAttr = declaration.getXmlAttribute()) != null && (declarationTag = declarationAttr.getParent()) != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    declarationTag.delete();
                }
            });
        }
        this.getBaseHandler().prepareForDeletion(element);
    }

    public boolean isToSearchInComments(PsiElement element) {
        return this.getBaseHandler().isToSearchInComments(element);
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        this.getBaseHandler().setToSearchInComments(element, enabled);
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return this.getBaseHandler().isToSearchForTextOccurrences(element);
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        this.getBaseHandler().setToSearchForTextOccurrences(element, enabled);
    }
}

