/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.concurrency.WorkerThread;
import com.android.resources.ResourceFolderType;
import com.google.common.collect.ObjectArrays;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @WorkerThread
    public boolean canFindUsages(@NotNull PsiElement element) {
        AndroidFacet facet;
        XmlAttributeValue value2;
        PsiElement element1 = LazyValueResourceElementWrapper.computeLazyElement(element);
        if (element1 == null) {
            return false;
        }
        if (element1 instanceof XmlAttributeValue && AndroidResourceUtil.isIdDeclaration(value2 = (XmlAttributeValue)element1)) {
            return true;
        }
        if ((element1 = AndroidFindUsagesHandlerFactory.correctResourceElement(element1)) instanceof PsiField) {
            return AndroidResourceUtil.isResourceField((PsiField)element1);
        }
        if ((element1 instanceof PsiFile || element1 instanceof XmlTag) && (facet = AndroidFacet.getInstance(element1)) != null) {
            LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
            if (element1 instanceof PsiFile) {
                return resourceManager.getFileResourceFolderType((PsiFile)element1) != null;
            }
            ResourceFolderType fileResType = resourceManager.getFileResourceFolderType(element1.getContainingFile());
            if (ResourceFolderType.VALUES == fileResType) {
                return AndroidResourceUtil.getResourceTypeForResourceTag((XmlTag)element1) != null;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement correctResourceElement(PsiElement element) {
        if (element instanceof XmlElement && !(element instanceof XmlFile)) {
            XmlTag tag;
            XmlTag xmlTag = tag = element instanceof XmlTag ? (XmlTag)element : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag != null && ResourcesDomFileDescription.isResourcesFile((XmlFile)tag.getContainingFile())) {
                return tag;
            }
            return null;
        }
        return element;
    }

    private static XmlAttributeValue wrapIfNecessary(XmlAttributeValue value2) {
        if (value2 instanceof ResourceElementWrapper) {
            return value2;
        }
        return new ValueResourceElementWrapper(value2);
    }

    @WorkerThread
    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        XmlAttributeValue value2;
        PsiElement e = LazyValueResourceElementWrapper.computeLazyElement(element);
        if (e == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(e);
        if (facet == null) {
            return null;
        }
        if (e instanceof XmlAttributeValue && AndroidResourceUtil.isIdDeclaration(value2 = (XmlAttributeValue)e)) {
            e = AndroidFindUsagesHandlerFactory.wrapIfNecessary(value2);
            PsiField[] fields = forHighlightUsages ? PsiField.EMPTY_ARRAY : AndroidResourceUtil.findIdFields(value2);
            return new MyFindUsagesHandler(e, (PsiElement[])fields);
        }
        if ((e = AndroidFindUsagesHandlerFactory.correctResourceElement(e)) instanceof PsiFile) {
            PsiField[] fields;
            PsiField[] psiFieldArray = fields = forHighlightUsages ? PsiField.EMPTY_ARRAY : AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)e, true);
            if (fields.length == 0) {
                return null;
            }
            return new MyFindUsagesHandler(e, (PsiElement[])fields);
        }
        if (e instanceof XmlTag) {
            XmlAttributeValue nameValue;
            XmlTag tag = (XmlTag)e;
            XmlAttribute nameAttr = tag.getAttribute("name");
            XmlAttributeValue xmlAttributeValue = nameValue = nameAttr != null ? nameAttr.getValueElement() : null;
            assert (nameValue != null);
            Object[] fields = PsiField.EMPTY_ARRAY;
            if (!forHighlightUsages) {
                fields = AndroidResourceUtil.findResourceFieldsForValueResource(tag, true);
                if (fields.length == 0) {
                    return null;
                }
                Object[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, true);
                if (styleableFields.length > 0) {
                    fields = (PsiField[])ObjectArrays.concat((Object[])fields, (Object[])styleableFields, PsiField.class);
                }
            }
            return new MyFindUsagesHandler((PsiElement)nameValue, (PsiElement[])fields);
        }
        if (e instanceof PsiField) {
            PsiField field2 = (PsiField)e;
            List<PsiElement> resources = AndroidResourceUtil.findResourcesByField(field2);
            if (resources.isEmpty()) {
                return new MyFindUsagesHandler(e, new PsiElement[0]);
            }
            PsiElement resource = resources.get(0);
            return this.createFindUsagesHandler(resource, forHighlightUsages);
        }
        return null;
    }

    private static class MyFindUsagesHandler
    extends FindUsagesHandler {
        private final PsiElement[] myAdditionalElements;

        protected MyFindUsagesHandler(@NotNull PsiElement element, PsiElement ... additionalElements) {
            super(element);
            this.myAdditionalElements = additionalElements;
        }

        @NotNull
        public PsiElement[] getSecondaryElements() {
            return this.myAdditionalElements;
        }
    }
}

