/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGotoRelatedProvider
extends GotoRelatedProvider {
    public static boolean ourAddDeclarationToManifest;
    private static final String[] CONTEXT_CLASSES;

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement element) {
        Computable<List<GotoRelatedItem>> lazyItems = AndroidGotoRelatedProvider.getLazyItemsComputable(element);
        if (lazyItems == null) {
            return Collections.emptyList();
        }
        List computedItems = (List)lazyItems.compute();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (GotoRelatedItem item : computedItems) {
                assert (item != null) : "Null in computedItems.";
                assert (item.getGroup() != null) : "Item with null group: " + item;
            }
        }
        return computedItems;
    }

    @Nullable
    private static Computable<List<GotoRelatedItem>> getLazyItemsComputable(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof XmlFile) && !(file instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        Project project = element.getProject();
        if (!FileIndexFacade.getInstance((Project)project).isInContent(vFile)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        if (file instanceof PsiJavaFile) {
            PsiClass[] rootClasses;
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null && (rootClasses = ((PsiJavaFile)file).getClasses()).length == 1) {
                aClass = rootClasses[0];
            }
            if (aClass != null) {
                return AndroidGotoRelatedProvider.getLazyItemsForClass(aClass, facet, ourAddDeclarationToManifest);
            }
        } else {
            return AndroidGotoRelatedProvider.getLazyItemsForXmlFile((XmlFile)file, facet);
        }
        return null;
    }

    @Nullable
    public static Computable<List<GotoRelatedItem>> getLazyItemsForXmlFile(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        ResourceFolderType resourceType = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceFolderType((PsiFile)file);
        if (ResourceFolderType.LAYOUT == resourceType) {
            return AndroidGotoRelatedProvider.collectRelatedJavaFiles(file, facet);
        }
        return null;
    }

    @Nullable
    static Computable<List<GotoRelatedItem>> getLazyItemsForClass(@NotNull PsiClass aClass, @NotNull AndroidFacet facet, boolean addDeclarationInManifest) {
        List<GotoRelatedItem> items2;
        GotoRelatedItem item = AndroidGotoRelatedProvider.findDeclarationInManifest(aClass);
        boolean isContextClass = AndroidGotoRelatedProvider.isInheritorOfContextClass(aClass, facet.getModule());
        if (!isContextClass && item == null) {
            return null;
        }
        if (isContextClass) {
            items2 = new ArrayList<GotoRelatedItem>(AndroidGotoRelatedProvider.collectRelatedLayoutFiles(facet, aClass));
            if (addDeclarationInManifest && item != null) {
                items2.add(item);
            }
            if (items2.isEmpty()) {
                return null;
            }
        } else {
            items2 = Collections.singletonList(item);
        }
        return () -> items2;
    }

    @Nullable
    private static GotoRelatedItem findDeclarationInManifest(@NotNull PsiClass psiClass) {
        AndroidAttributeValue<PsiClass> domAttrValue = AndroidDomUtil.findComponentDeclarationInManifest(psiClass);
        if (domAttrValue == null) {
            return null;
        }
        XmlAttributeValue attrValue = domAttrValue.getXmlAttributeValue();
        return attrValue != null ? new MyGotoManifestItem(attrValue) : null;
    }

    private static boolean isInheritorOfContextClass(@NotNull PsiClass psiClass, @NotNull Module module) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (String contextClassName : CONTEXT_CLASSES) {
            PsiClass contextClass = facade.findClass(contextClassName, module.getModuleWithDependenciesAndLibrariesScope(false));
            if (contextClass == null || !psiClass.isInheritor(contextClass, true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Computable<List<GotoRelatedItem>> collectRelatedJavaFiles(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        String resourceName;
        String resType = ResourceType.LAYOUT.getName();
        PsiField[] fields = AndroidResourceUtil.findResourceFields(facet, resType, resourceName = AndroidCommonUtils.getResourceName((String)resType, (String)file.getName()), true);
        if (fields.length == 0 || fields.length > 1) {
            return null;
        }
        PsiField field2 = fields[0];
        Module module = facet.getModule();
        GlobalSearchScope scope = module.getModuleScope(false);
        return () -> {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
            ArrayList<PsiClass> psiContextClasses = new ArrayList<PsiClass>();
            PsiClass declared = AndroidPsiUtils.getContextClass(module, file);
            if (declared != null) {
                return Collections.singletonList(new GotoRelatedItem((PsiElement)declared, "JAVA"));
            }
            for (String contextClassName : CONTEXT_CLASSES) {
                PsiClass contextClass = facade.findClass(contextClassName, module.getModuleWithDependenciesAndLibrariesScope(false));
                if (contextClass == null) continue;
                psiContextClasses.add(contextClass);
            }
            if (psiContextClasses.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result2 = new ArrayList();
            ReferencesSearch.search((PsiElement)field2, (SearchScope)scope).forEach(reference2 -> {
                PsiClass relatedClass;
                PsiElement element = reference2.getElement();
                if (!(element instanceof PsiReferenceExpression)) {
                    return true;
                }
                if (!((element = element.getParent()) instanceof PsiExpressionList)) {
                    return true;
                }
                if (!((element = element.getParent()) instanceof PsiMethodCallExpression)) {
                    return true;
                }
                String methodName = ((PsiMethodCallExpression)element).getMethodExpression().getReferenceName();
                if (("setContentView".equals(methodName) || "inflate".equals(methodName)) && (relatedClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null && AndroidGotoRelatedProvider.isInheritorOfOne(relatedClass, psiContextClasses)) {
                    result2.add(new GotoRelatedItem((PsiElement)relatedClass, "JAVA"));
                }
                return true;
            });
            return result2;
        };
    }

    private static boolean isInheritorOfOne(@NotNull PsiClass psiClass, @NotNull Collection<PsiClass> possibleBaseClasses) {
        for (PsiClass baseClass : possibleBaseClasses) {
            if (!psiClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<GotoRelatedItem> collectRelatedLayoutFiles(final @NotNull AndroidFacet facet, @NotNull PsiClass context) {
        HashSet files2 = new HashSet();
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)files2){
            final /* synthetic */ Set val$files;
            {
                this.val$files = set;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                String resClassName = ResourceType.LAYOUT.getName();
                AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, expression, resClassName, true);
                if (info == null || info.isFromManifest()) {
                    return;
                }
                String resFieldName = info.getFieldName();
                LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
                List<PsiElement> resources = resourceManager.findResourcesByFieldName(ResourceNamespace.TODO(), resClassName, resFieldName);
                for (PsiElement resource : resources) {
                    if (!(resource instanceof PsiFile)) continue;
                    this.val$files.add((PsiFile)resource);
                }
            }
        });
        if (files2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GotoRelatedItem> result2 = new ArrayList<GotoRelatedItem>(files2.size());
        for (PsiFile file : files2) {
            result2.add(new MyGotoRelatedLayoutItem(file));
        }
        return result2;
    }

    static {
        CONTEXT_CLASSES = new String[]{"android.app.Activity", "android.app.Fragment", SdkConstants.CLASS_V4_FRAGMENT.oldName(), SdkConstants.CLASS_V4_FRAGMENT.newName(), "android.widget.Adapter"};
    }

    private static class MyGotoManifestItem
    extends GotoRelatedItem {
        public MyGotoManifestItem(@NotNull XmlAttributeValue attributeValue) {
            super((PsiElement)attributeValue);
        }

        @Nullable
        public String getCustomName() {
            return "AndroidManifest.xml";
        }

        @Nullable
        public String getCustomContainerName() {
            return "";
        }

        @Nullable
        public Icon getCustomIcon() {
            return XmlFileType.INSTANCE.getIcon();
        }
    }

    private static class MyGotoRelatedLayoutItem
    extends GotoRelatedItem {
        private final PsiFile myFile;

        public MyGotoRelatedLayoutItem(@NotNull PsiFile file) {
            super((PsiElement)file, "Layout Files");
            this.myFile = file;
        }

        @Nullable
        public String getCustomContainerName() {
            PsiDirectory directory = this.myFile.getContainingDirectory();
            return directory != null ? "(" + directory.getName() + ")" : null;
        }
    }
}

