/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Objects;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidJavaCompletionContributor
extends CompletionContributor {
    private static final String[] EXCLUDED_PACKAGES = new String[]{"javax.swing", "javafx"};

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet) {
        PsiReferenceExpression ref3;
        PsiReferenceExpression ref2;
        PsiReferenceExpression ref;
        super.fillCompletionVariants(parameters2, resultSet);
        PsiElement position = parameters2.getPosition();
        AndroidFacet facet = AndroidFacet.getInstance(position);
        if (facet == null) {
            return;
        }
        if (AndroidMavenUtil.isMavenizedModule(facet.getModule())) {
            resultSet.runRemainingContributors(parameters2, result2 -> {
                String qName;
                Object obj = result2.getLookupElement().getObject();
                if (obj instanceof PsiClass && (qName = ((PsiClass)obj).getQualifiedName()) != null && !AndroidJavaCompletionContributor.isAllowedInAndroid(qName)) {
                    return;
                }
                resultSet.passResult(result2);
            });
        }
        if (position.getParent() instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)position.getParent()).getQualifierExpression() != null && ref.getQualifierExpression() instanceof PsiReferenceExpression && (ref2 = (PsiReferenceExpression)ref.getQualifierExpression()).getQualifierExpression() instanceof PsiReferenceExpression && "R".equals((ref3 = (PsiReferenceExpression)ref2.getQualifierExpression()).getReferenceName())) {
            boolean filterPrivateResources = false;
            PsiExpression qualifierExpression = ref3.getQualifierExpression();
            if (qualifierExpression == null) {
                filterPrivateResources = true;
            } else if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                if (Objects.equals(AndroidManifestUtils.getPackageName(facet), referenceExpression.getQualifiedName()) || Objects.equals(AndroidManifestUtils.getTestPackageName(facet), referenceExpression.getQualifiedName())) {
                    filterPrivateResources = true;
                }
            }
            if (filterPrivateResources) {
                this.filterPrivateResources(parameters2, resultSet, facet);
            }
        }
    }

    public void filterPrivateResources(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet, AndroidFacet facet) {
        ResourceVisibilityLookup lookup = ResourceRepositoryManager.getInstance(facet).getResourceVisibility();
        if (lookup.isEmpty()) {
            return;
        }
        resultSet.runRemainingContributors(parameters2, result2 -> {
            ResourceType type;
            PsiClass rClass;
            PsiField field2;
            PsiClass containingClass;
            Object obj = result2.getLookupElement().getObject();
            if (obj instanceof PsiField && (containingClass = (field2 = (PsiField)obj).getContainingClass()) != null && (rClass = containingClass.getContainingClass()) != null && "R".equals(rClass.getName()) && (type = ResourceType.fromClassName((String)containingClass.getName())) != null && lookup.isPrivate(type, field2.getName())) {
                return;
            }
            resultSet.passResult(result2);
        });
    }

    private static boolean isAllowedInAndroid(@NotNull String qName) {
        for (String aPackage : EXCLUDED_PACKAGES) {
            if (!qName.startsWith(aPackage + ".")) continue;
            return false;
        }
        return true;
    }
}

